/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.menuframe.vo;

import java.util.ArrayList;
import java.util.List;
import org.september.pisces.menuframe.vo.SimpleMenu;

public class MenuTree {
    private List<SimpleMenu> root = new ArrayList<SimpleMenu>();
    private String groupLabel;

    public List<SimpleMenu> getRoot() {
        return this.root;
    }

    public void addMenu(String text, String url, String icon) {
        this.addMenu(text, url, icon, false);
    }

    public MenuTree clone() {
        MenuTree mt = new MenuTree();
        for (SimpleMenu menu : this.root) {
            mt.root.add(menu.simpleClone());
        }
        mt.groupLabel = this.groupLabel;
        return mt;
    }

    public void addMenu(String text, String url, String icon, boolean open) {
        String[] arr = text.split("-");
        List<SimpleMenu> parent = this.root;
        for (int i = 0; i < arr.length; ++i) {
            String mText = arr[i];
            SimpleMenu menu = this.findMenu(parent, mText);
            if (menu == null) {
                menu = new SimpleMenu();
                menu.setText(mText);
                menu.setIconClass(icon);
                if (i == arr.length - 1) {
                    menu.setUrl(url);
                    menu.setAutoOpen(open ? 1 : 0);
                }
                parent.add(menu);
            }
            parent = menu.getChildren();
        }
    }

    private SimpleMenu findMenu(List<SimpleMenu> parent, String mText) {
        for (SimpleMenu sm : parent) {
            if (!sm.getText().equals(mText)) continue;
            return sm;
        }
        return null;
    }

    public String getGroupLabel() {
        return this.groupLabel;
    }

    public void setGroupLabel(String groupLabel) {
        this.groupLabel = groupLabel;
    }
}

