/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.filestore.service.hik;

import cn.hutool.core.io.FileUtil;
import cn.hutool.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.september.pisces.filestore.service.hik.ByteArrayUtil;
import org.september.pisces.filestore.service.hik.GmtTimeUtil;
import org.september.pisces.filestore.service.hik.HikPoolService;
import org.september.pisces.filestore.service.hik.RequestHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImageClientImpl {
    @Autowired
    private HikPoolService poolService;
    private final String endStr = "\r\n";
    private final String twoHyphens = "--";
    private final String boundaryStr = "**************";
    private final String divide = "--**************";
    private final String tail_str = "--**************--\r\n\r\n";
    private final String contentType = "multipart/form-data";
    private final String PREFIX = "hikcstor";
    private final String BEST_NODE = "/HikCStor/BestNode";
    private final String UPLOAD_PIC_URI = "/HikCStor/Picture/Write";

    public String getBestNode(String serialID) {
        return this.poolService.getBestNode("/HikCStor/BestNode?SerialID=" + serialID + "&PoolID=" + HikPoolService.imagePoolId + "&Replication=0", "hikcstor", 0, "text/json");
    }

    public String uploadImage(byte[] data) throws IOException {
        String gmtTime = GmtTimeUtil.getGmtTime();
        String serialID = "" + new Random().nextInt(1000000);
        String authorization = this.poolService.postAuth("hikcstor", "multipart/form-data", gmtTime, "/HikCStor/Picture/Write", 0);
        String bestNode = this.getBestNode(serialID);
        JSONObject node = new JSONObject((Object)bestNode);
        String uri = "http://" + node.getStr((Object)"GatewayIP") + ":" + node.getStr((Object)"GatewayPort") + "/HikCStor/Picture/Write";
        PostMethod postMethod = new PostMethod(uri);
        String body = this.generateRequestBody(serialID, node.getStr((Object)"Token"), data.length);
        postMethod = this.generateHttpHeader(postMethod, gmtTime, authorization);
        byte[] bodyAndPic = ByteArrayUtil.byteMerger(body.getBytes(StandardCharsets.UTF_8), data);
        byte[] bytes = ByteArrayUtil.byteMerger(bodyAndPic, "--**************--\r\n\r\n".getBytes(StandardCharsets.UTF_8));
        postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(bytes));
        RequestHandler requestHandler = new RequestHandler();
        String result = requestHandler.sendRequest((HttpMethodBase)postMethod);
        String url = new JSONObject((Object)result).getStr((Object)"PictureUrl");
        return url;
    }

    public void downloadImage(String url, String localPath) {
        InputStream inputStream = this.getImageStream(url);
        FileUtil.writeFromStream((InputStream)inputStream, (String)localPath);
    }

    public InputStream getImageStream(String url) {
        String gmtTime = GmtTimeUtil.getGmtTime();
        String authorization = this.poolService.getAuth("hikcstor", "", gmtTime, url, 0);
        GetMethod getMethod = new GetMethod("http://" + this.poolService.getAddress() + url);
        getMethod.addRequestHeader("Accept-language", "zh-cn");
        getMethod.addRequestHeader("Authorization", authorization);
        getMethod.addRequestHeader("Host", this.poolService.getAddress());
        getMethod.addRequestHeader("Date", gmtTime);
        getMethod.addRequestHeader("Connection", "close");
        RequestHandler requestHandler = new RequestHandler();
        return requestHandler.sendRequestReturnStream((HttpMethodBase)getMethod);
    }

    public String generateRequestBody(String serialID, String token, int picLen) {
        StringBuilder body = new StringBuilder("--**************\r\n");
        body.append(" Content-Disposition: form-data;").append(" name=\"SerialID\"\r\n\r\n" + serialID + "\r\n--**************\r\nContent-Disposition: form-data;").append(" name=\"PoolID\"\r\n\r\n" + HikPoolService.imagePoolId + "\r\n--**************\r\nContent-Disposition: form-data;").append(" name=\"TimeStamp\"\r\n\r\n12345678\r\n--**************\r\nContent-Disposition: form-data;").append(" name=\"PictureType\"\r\n\r\n2\r\n--**************\r\nContent-Disposition: form-data;").append(" name=\"Token\"\r\n\r\n" + token + "\r\n--**************\r\nContent-Disposition: form-data;").append(" name=\"PictureLength\"\r\n\r\n" + picLen + "\r\n--**************\r\nContent-Disposition: form-data;").append(" name=\"Picture\"\r\nContent-Type: image/bmp\r\n\r\n");
        return body.toString();
    }

    private PostMethod generateHttpHeader(PostMethod postMethod, String gmtTime, String authorization) {
        postMethod.setRequestHeader("Host", this.poolService.getAddress());
        postMethod.setRequestHeader("Accept-Language", "zh-cn");
        postMethod.setRequestHeader("Authorization", authorization);
        postMethod.setRequestHeader("Date", gmtTime);
        postMethod.setRequestHeader("Content-Type", "multipart/form-data;boundary=**************");
        postMethod.setRequestHeader("Connection", "keep-alive");
        return postMethod;
    }
}

