/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.filestore.service.hik;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.september.pisces.filestore.service.hik.AuthorizationUtil;
import org.september.pisces.filestore.service.hik.GmtTimeUtil;
import org.september.pisces.filestore.service.hik.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HikPoolService {
    private static final Logger log = LoggerFactory.getLogger(HikPoolService.class);
    @Value(value="${hik.oss.ip:}")
    private String ip;
    @Value(value="${hik.oss.port:}")
    private String port;
    @Value(value="${hik.oss.accessKey:}")
    private String accessKey;
    @Value(value="${hik.oss.secretKey:}")
    private String secretKey;
    public static String imagePoolId;
    public static String videoPoolId;
    private static final String IMAGE_URI = "/HikCStor/PoolList?Marker=&MaxKeys=";
    private static final String VIDEO_URI = "/ISAPI/Storage/poolInfoList?marker=&maxKeys=";
    private static final String IMAGE_PREFIX = "hikcstor";
    private static final String VIDEO_PREFIX = "storage";

    public void initPoolSetting() {
        JSONObject INFO;
        log.info("initPoolSetting:{},{},{},{}", new Object[]{this.ip, this.port, this.accessKey, this.secretKey});
        String poolString = this.getPoolList(IMAGE_URI, IMAGE_PREFIX, 0);
        log.info("poolInfo:{}", (Object)poolString);
        JSONArray list = new JSONObject((Object)poolString).getJSONArray((Object)"List");
        if (list != null && !list.isEmpty()) {
            INFO = (JSONObject)list.get(0);
            imagePoolId = INFO.getStr((Object)"PoolID");
            log.info("imagePoolId:{}", (Object)imagePoolId);
        } else {
            log.info("imagePoolId is null");
        }
        poolString = this.getPoolList(VIDEO_URI, VIDEO_PREFIX, 1);
        log.info("poolInfo:{}", (Object)poolString);
        list = new JSONObject((Object)poolString).getJSONArray((Object)"List");
        if (list != null && !list.isEmpty()) {
            INFO = (JSONObject)list.get(0);
            videoPoolId = INFO.getStr((Object)"poolID");
            log.info("videoPoolId:{}", (Object)videoPoolId);
        } else {
            log.info("videoPoolId is null");
        }
    }

    public String getBestNode(String url, String authorizationPrefix, Integer encryption, String contentType) {
        String gmtTime = GmtTimeUtil.getGmtTime();
        String authorization = this.getAuth(authorizationPrefix, contentType, gmtTime, url, encryption);
        GetMethod getMethod = new GetMethod("http://" + this.getAddress() + url);
        getMethod.addRequestHeader("Accept-language", "zh-cn");
        getMethod.addRequestHeader("Authorization", authorization);
        getMethod.addRequestHeader("Host", this.getAddress());
        getMethod.addRequestHeader("Date", gmtTime);
        getMethod.addRequestHeader("Connection", "close");
        getMethod.addRequestHeader("Content-Type", contentType);
        RequestHandler requestHandler = new RequestHandler();
        String result = requestHandler.sendRequest((HttpMethodBase)getMethod);
        return result;
    }

    public String getPoolList(String url, String authPrefix, Integer encryption) {
        String gmtTime = GmtTimeUtil.getGmtTime();
        String authorization = this.getAuth(authPrefix, "", gmtTime, url, encryption);
        String poolUrl = "http://" + this.getAddress() + url;
        GetMethod getMethod = new GetMethod(poolUrl);
        getMethod.addRequestHeader("Authorization", authorization);
        getMethod.addRequestHeader("Host", this.getAddress());
        getMethod.addRequestHeader("Date", gmtTime);
        getMethod.addRequestHeader("Connection", "close");
        RequestHandler requestHandler = new RequestHandler();
        String result = requestHandler.sendRequest((HttpMethodBase)getMethod);
        return result;
    }

    public String getAuth(String prefix, String contentType, String gmtTime, String url, Integer encryp) {
        return AuthorizationUtil.getAuthorization(prefix, this.accessKey, this.secretKey, "GET", contentType, gmtTime, url, encryp);
    }

    public String postAuth(String prefix, String contentType, String gmtTime, String url, Integer encryp) {
        return AuthorizationUtil.getAuthorization(prefix, this.accessKey, this.secretKey, "POST", contentType, gmtTime, url, encryp);
    }

    public String getAddress() {
        return this.ip + ":" + this.port;
    }
}

