/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.filestore.service.hik;

import cn.hutool.core.codec.Base64;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AuthorizationUtil {
    public static String getAuthorization(String authorizationPrefix, String accessKey, String secretKey, String httpVerb, String contentType, String date, String uri, int encryptionAlgrithm) {
        StringBuffer auth_data = new StringBuffer();
        auth_data.append(authorizationPrefix).append(" ");
        auth_data.append(accessKey).append(":");
        String signature = AuthorizationUtil.getSignature(secretKey, httpVerb, "", contentType, date, uri, encryptionAlgrithm);
        auth_data.append(signature);
        return auth_data.toString();
    }

    public static String getSignature(String secretKey, String httpVerb, String contentMd5, String contentType, String date, String uri, int encryptionAlgrithm) {
        String StringToSign = AuthorizationUtil.getStringToSign(httpVerb, contentMd5, contentType, date, uri);
        String encoderData = Base64.encode((byte[])AuthorizationUtil.getHMACData(StringToSign, secretKey, encryptionAlgrithm));
        return encoderData;
    }

    private static byte[] getHMACData(String data, String secretKey, int encryptionAlgrithm) {
        byte[] byteHMAC = null;
        String MAC_NAME = null;
        if (0 == encryptionAlgrithm) {
            MAC_NAME = "HmacSHA1";
        } else if (1 == encryptionAlgrithm) {
            MAC_NAME = "HmacSHA256";
        } else {
            System.out.println("Invalid encryption algrithm");
            return null;
        }
        try {
            Mac mac = Mac.getInstance(MAC_NAME);
            SecretKeySpec spec = new SecretKeySpec(secretKey.getBytes(), MAC_NAME);
            mac.init(spec);
            byteHMAC = mac.doFinal(data.getBytes());
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return byteHMAC;
    }

    private static String getStringToSign(String httpVerb, String contentMd5, String contentType, String date, String uri) {
        StringBuffer sign_data = new StringBuffer("");
        sign_data.append(httpVerb).append("\n");
        sign_data.append(contentMd5).append("\n");
        sign_data.append(contentType).append("\n");
        sign_data.append(date).append("\n");
        sign_data.append(uri);
        return sign_data.toString();
    }
}

