/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.filestore.service;

import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.september.core.component.ApplicationContextHolder;
import org.september.core.component.log.LogHelper;
import org.september.core.exception.BusinessException;
import org.september.pisces.filestore.api.FileStoreService;
import org.september.pisces.filestore.entity.FileStoreItem;
import org.september.pisces.filestore.entity.FileStorePool;
import org.september.pisces.filestore.enums.StorePoolTypeEnum;
import org.september.pisces.filestore.service.DiskFileStoreService;
import org.september.pisces.filestore.service.HikFileStoreService;
import org.september.pisces.filestore.service.hik.HikPoolService;
import org.september.smartdao.CommonDaoHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FileStoreManager {
    @Value(value="${hik.oss.ip:}")
    private String ip;
    @Value(value="${hik.oss.port:}")
    private String port;
    @Value(value="${hik.oss.accessKey:}")
    private String accessKey;
    @Value(value="${hik.oss.secretKey:}")
    private String secretKey;
    @Autowired
    private HikPoolService hikPoolService;
    public static List<FileStorePool> allPool = null;
    protected LogHelper log = LogHelper.getLogger(this.getClass());
    private static final String Default_Pool_Name = "_default";

    public FileStoreItem save(String poolName, byte[] data, String ext, boolean needThumb, Float thumbRate) {
        if (!StringUtils.hasText((String)poolName)) {
            poolName = Default_Pool_Name;
        }
        FileStoreItem item = new FileStoreItem();
        FileStorePool pool = this.getPool(poolName);
        if (pool.getStoreType() == null) {
            throw new BusinessException("\u5b58\u50a8\u6c60" + poolName + "\u7c7b\u578b\u914d\u7f6e\u9519\u8bef");
        }
        String path = this.getFileStoreService(pool.getStoreType()).saveWithThumb(pool, data, ext, needThumb, thumbRate.floatValue());
        item.setFileUUID(UUID.randomUUID().toString());
        item.setPath(path);
        item.setExt(ext);
        item.setPoolId(pool.getId());
        CommonDaoHolder.getCommonDao().save((Object)item);
        return item;
    }

    public InputStream getInputStreamByUUID(FileStoreItem po, boolean thumb) {
        if (po == null) {
            throw new BusinessException("\u6587\u4ef6\u5b58\u50a8\u6c60\u4e0d\u5b58\u5728\u6216\u914d\u7f6e\u9519\u8bef");
        }
        FileStorePool pool = (FileStorePool)((Object)CommonDaoHolder.getCommonDao().get(FileStorePool.class, (Object)po.getPoolId()));
        return this.getFileStoreService(pool.getStoreType()).getInputStream(pool, po, thumb);
    }

    public FileStoreItem getFileItem(String uuid) {
        if (!StringUtils.hasText((String)uuid)) {
            throw new BusinessException("\u6587\u4ef6\u4e0d\u5b58\u5728,uuid=" + uuid);
        }
        FileStoreItem item = new FileStoreItem();
        item.setFileUUID(uuid);
        item.setDeleteFlag(0);
        FileStoreItem po = (FileStoreItem)((Object)CommonDaoHolder.getCommonDao().getByExample((Object)item));
        if (po == null) {
            return null;
        }
        return po;
    }

    private FileStorePool getPool(String poolName) {
        FileStorePool vo = new FileStorePool();
        vo.setPoolName(poolName);
        vo.setDeleteFlag(0);
        return (FileStorePool)((Object)CommonDaoHolder.getCommonDao().getByExample((Object)vo));
    }

    public void getAllPool() {
        FileStorePool vo = new FileStorePool();
        vo.setDeleteFlag(0);
        allPool = CommonDaoHolder.getCommonDao().listByExample((Object)vo);
    }

    private FileStoreService getFileStoreService(int type) {
        if (StorePoolTypeEnum.\u672c\u5730\u78c1\u76d8.code == type) {
            return (FileStoreService)ApplicationContextHolder.getContext().getBean(DiskFileStoreService.class);
        }
        if (StorePoolTypeEnum.HIK.code == type) {
            return (FileStoreService)ApplicationContextHolder.getContext().getBean(HikFileStoreService.class);
        }
        throw new BusinessException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u6c60\u7c7b\u578b");
    }

    public void initDefaultPool() {
        FileStorePool po = this.getPool(Default_Pool_Name);
        if (po == null) {
            FileStorePool vo = new FileStorePool();
            vo.setPoolName(Default_Pool_Name);
            vo.setDeleteFlag(0);
            vo.setStoreType(StorePoolTypeEnum.\u672c\u5730\u78c1\u76d8.code);
            vo.setDiskPath("/_default_pool/");
            CommonDaoHolder.getCommonDao().save((Object)vo);
        } else {
            this.getAllPool();
        }
        if (StringUtils.hasText((String)this.ip) && StringUtils.hasText((String)this.port) && StringUtils.hasText((String)this.accessKey) && StringUtils.hasText((String)this.secretKey)) {
            this.hikPoolService.initPoolSetting();
        }
    }

    public void deleteFile(String fileUuid) {
        try {
            FileStoreItem item = new FileStoreItem();
            item.setFileUUID(fileUuid);
            item.setDeleteFlag(0);
            FileStoreItem po = (FileStoreItem)((Object)CommonDaoHolder.getCommonDao().getByExample((Object)item));
            if (po == null) {
                return;
            }
            CommonDaoHolder.getCommonDao().delete((Object)po);
            FileStorePool pool = (FileStorePool)((Object)CommonDaoHolder.getCommonDao().get(FileStorePool.class, (Object)po.getPoolId()));
            if (pool == null) {
                return;
            }
            this.getFileStoreService(pool.getStoreType()).deleteFile(pool, po);
        }
        catch (Exception ex) {
            this.log.getBuilder().warn("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff1auuid=" + fileUuid, (Throwable)ex);
        }
    }
}

