/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.filestore.controller;

import jakarta.validation.Valid;
import org.september.core.exception.BusinessException;
import org.september.pisces.filestore.entity.FileStorePool;
import org.september.pisces.filestore.service.FileStoreManager;
import org.september.pisces.user.permission.service.OperationLogService;
import org.september.simpleweb.controller.BaseController;
import org.september.simpleweb.model.ResponseVo;
import org.september.smartdao.common.BaseEntity;
import org.september.smartdao.common.BaseService;
import org.september.smartdao.model.Page;
import org.september.smartdao.model.ParamMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class FileStorePoolController
extends BaseController {
    @Autowired
    private BaseService baseService;
    @Autowired
    private OperationLogService operationLogService;
    @Autowired
    private FileStoreManager fileStoreManager;
    private static final String Mapping_Prefix = "/pisces/fileStore/pool";
    public static final String List_Page = "/pisces/fileStore/pool/poolList";
    public static final String List_Data = "/pisces/fileStore/pool/listPoolData";
    public static final String Add_Page = "/pisces/fileStore/pool/addPool";
    public static final String Add_Action = "/pisces/fileStore/pool/doAddPool";
    public static final String Edit_Page = "/pisces/fileStore/pool/editPool";
    public static final String Edit_Action = "/pisces/fileStore/pool/doUpdatePool";
    public static final String Delete_Action = "/pisces/fileStore/pool/delete";

    @RequestMapping(value={"/pisces/fileStore/pool/poolList"})
    public ModelAndView poolList() throws Exception {
        ModelAndView mv = new ModelAndView();
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/pisces/fileStore/pool/listPoolData"})
    public ResponseVo<Page<FileStorePool>> listPoolData(Page<FileStorePool> page, FileStorePool vo) throws Exception {
        ParamMap pm = new ParamMap((Object)vo);
        page = this.baseService.getCommonDao().findPageByParams(FileStorePool.class, page, "PiscesFileStorePool.listPoolData", pm);
        return ResponseVo.BUILDER().setData((Object)page).setCode(Integer.valueOf(0));
    }

    @RequestMapping(value={"/pisces/fileStore/pool/addPool"})
    public ModelAndView addPool() throws Exception {
        ModelAndView mv = new ModelAndView();
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/pisces/fileStore/pool/doAddPool"})
    public ResponseVo<String> doAddPool(FileStorePool vo) throws Exception {
        this.baseService.save((BaseEntity)vo);
        this.operationLogService.addLog("\u6dfb\u52a0\u4e86\u5b58\u50a8\u6c60\u3010" + vo.getId() + "\u3011");
        return ResponseVo.BUILDER().setData((Object)"\u6dfb\u52a0\u6587\u4ef6\u5b58\u50a8\u6c60\u9700\u8981\u91cd\u542f\u5e94\u7528\u540e\u751f\u6548").setCode(Integer.valueOf(0));
    }

    @RequestMapping(value={"/pisces/fileStore/pool/editPool"})
    public ModelAndView editPool(Long id) throws Exception {
        ModelAndView mv = new ModelAndView();
        FileStorePool po = (FileStorePool)((Object)this.baseService.getCommonDao().get(FileStorePool.class, (Object)id));
        mv.addObject("pool", (Object)po);
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/pisces/fileStore/pool/doUpdatePool"})
    public ResponseVo<String> doUpdatePool(@Valid FileStorePool po) throws Exception {
        this.baseService.update((BaseEntity)po);
        this.operationLogService.addLog("\u66f4\u65b0\u4e86\u5b58\u50a8\u6c60\u3010" + po.getPoolName() + "\u3011");
        return ResponseVo.BUILDER().setData((Object)"").setCode(Integer.valueOf(0));
    }

    @ResponseBody
    @RequestMapping(value={"/pisces/fileStore/pool/delete"})
    public ResponseVo<String> delete(Long id) throws Exception {
        FileStorePool po = (FileStorePool)((Object)this.baseService.getCommonDao().get(FileStorePool.class, (Object)id));
        if (po == null) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        this.baseService.delete((BaseEntity)po);
        this.operationLogService.addLog("\u5220\u9664\u4e86\u5b58\u50a8\u6c60\u3010" + po.getPoolName() + "\u3011");
        return ResponseVo.BUILDER().setCode(Integer.valueOf(0));
    }
}

