/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.filestore.controller;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.september.core.exception.BusinessException;
import org.september.pisces.filestore.entity.FileStoreItem;
import org.september.pisces.filestore.service.FileStoreManager;
import org.september.simpleweb.auth.PublicMethod;
import org.september.simpleweb.controller.BaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class FileStoreController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(FileStoreController.class);
    @Autowired
    private FileStoreManager fileStoreManager;
    public static final String Get_File_Action = "/pisces/fileStore/getFile";

    @PublicMethod
    @ResponseBody
    @RequestMapping(value={"/pisces/fileStore/getFile"})
    public void getFile(HttpServletResponse response, String uuid, Boolean thumb, String fileName) throws Exception {
        thumb = thumb != null && thumb != false;
        FileStoreItem item = this.fileStoreManager.getFileItem(uuid);
        InputStream ins = null;
        for (int i = 0; i < 7 && (ins = this.fileStoreManager.getInputStreamByUUID(item, thumb)) == null; ++i) {
            log.info("uuid={},\u6ca1\u83b7\u53d6\u5230\u6d41,500ms\u540e\u91cd\u8bd5,i={}", (Object)uuid, (Object)i);
            Thread.sleep(500L);
        }
        if (ins == null) {
            throw new BusinessException("\u8d44\u6e90\u8fd8\u6ca1\u51c6\u5907\u597d!");
        }
        if (fileName != null) {
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            response.setContentType("application/octet-stream;charset=UTF-8");
        }
        ServletOutputStream out = response.getOutputStream();
        String type = URLConnection.guessContentTypeFromName(item.getPath());
        response.setContentType(type);
        ins.transferTo((OutputStream)out);
        out.close();
    }
}

