/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.excel.controller;

import com.alibaba.excel.util.FileUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.september.core.exception.BusinessException;
import org.september.pisces.excel.entity.ExcelTemplate;
import org.september.pisces.excel.service.PiscesExcelService;
import org.september.pisces.excel.vo.ExcelImage;
import org.september.pisces.filestore.entity.FileStoreItem;
import org.september.pisces.filestore.service.FileStoreManager;
import org.september.simpleweb.controller.BaseController;
import org.september.simpleweb.model.ResponseVo;
import org.september.smartdao.common.BaseService;
import org.september.smartdao.model.Page;
import org.september.smartdao.model.ParamMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ExcelTmplController
extends BaseController {
    @Autowired
    private BaseService baseService;
    @Autowired
    private PiscesExcelService piseceExcelService;
    @Autowired
    private FileStoreManager fileStoreManager;
    private static final String Mapping_Prefix = "/pisces/excel";
    public static final String List_Page = "/pisces/excel/tmplList";
    public static final String List_Data = "/pisces/excel/listTmplData";
    public static final String Import_Action = "/pisces/excel/doImportTmpl";
    public static final String Delete_Action = "/pisces/excel/deleteTmpl";
    public static final String Download_Action = "/pisces/excel/downloadTmpl";

    @RequestMapping(value={"/pisces/excel/tmplList"})
    public ModelAndView tmplList() throws Exception {
        ModelAndView mv = new ModelAndView();
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/pisces/excel/listTmplData"})
    public ResponseVo<Page<ExcelTemplate>> listTmplData(Page<ExcelTemplate> page) throws Exception {
        ParamMap pm = new ParamMap();
        page = this.baseService.getCommonDao().findPageByParams(ExcelTemplate.class, page, "ExcelTemplate.listTmplData", pm);
        return ResponseVo.BUILDER().setData((Object)page).setCode(Integer.valueOf(0));
    }

    @ResponseBody
    @RequestMapping(value={"/pisces/excel/doImportTmpl"})
    public ResponseVo<String> doImportTmpl(MultipartFile file) throws Exception {
        if (file.getSize() <= 6604L) {
            return ResponseVo.BUILDER().setDesc("\u4e0a\u4f20\u7684\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a").setCode(Integer.valueOf(-1));
        }
        List list = this.baseService.getCommonDao().listByParams(ExcelTemplate.class, "ExcelTemplate.listTmplData", new ParamMap());
        for (ExcelTemplate template : list) {
            if (!template.getName().equals(file.getOriginalFilename())) continue;
            return ResponseVo.BUILDER().setDesc("\u8be5\u6587\u4ef6\u5df2\u5b58\u5728").setCode(Integer.valueOf(-1));
        }
        this.piseceExcelService.addExcelTmpl(file.getOriginalFilename(), file.getBytes());
        return ResponseVo.BUILDER().setData((Object)"").setCode(Integer.valueOf(0));
    }

    @ResponseBody
    @RequestMapping(value={"/pisces/excel/deleteTmpl"})
    public ResponseVo<String> deleteTmpl(Long id) throws Exception {
        this.piseceExcelService.deleteTemplate(id);
        return ResponseVo.BUILDER().setCode(Integer.valueOf(0));
    }

    @ResponseBody
    @RequestMapping(value={"/pisces/excel/downloadTmpl"})
    public void downloadTmpl(HttpServletResponse response, Long tplId) throws Exception {
        ExcelTemplate tpl = (ExcelTemplate)((Object)this.baseService.getCommonDao().get(ExcelTemplate.class, (Object)tplId));
        if (tpl == null) {
            throw new BusinessException("\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        FileStoreItem item = this.fileStoreManager.getFileItem(tpl.getFileUuid());
        InputStream ins = this.fileStoreManager.getInputStreamByUUID(item, false);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode(tpl.getName(), "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName);
        response.getOutputStream().write(IOUtils.toByteArray((InputStream)ins));
        ins.close();
        response.getOutputStream().close();
    }

    @ResponseBody
    @RequestMapping(value={"/testExport"})
    public void testExportExcel(HttpServletResponse response, Long tplId) throws Exception {
        ExcelTemplate tpl = (ExcelTemplate)((Object)this.baseService.getCommonDao().get(ExcelTemplate.class, (Object)tplId));
        if (tpl == null || tpl.getDeleteFlag() == 1) {
            throw new BusinessException("\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> data1 = new HashMap<String, Object>();
        data1.put("name", "yexinzhou");
        data1.put("comp", this.getTestImageData());
        datas.add(data1);
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put("name", "yexinzhou2");
        data2.put("comp", "dddz2");
        datas.add(data2);
        this.piseceExcelService.doExport(response, tpl.getName(), datas, "test.xlsx");
    }

    private ExcelImage getTestImageData() throws IOException {
        ExcelImage img = new ExcelImage();
        img.setDatas(FileUtils.readFileToByteArray((File)new File("D:\\work\\\u6587\u6863\\\u4ea4\u901a\\traffic\\\u9879\u76ee\u4fe1\u606f\\\u5b89\u5fbd\\\u5b89\u5e86\\\u4e24\u7ad9\u4e00\u573a\u603b\u4f53\u65b9\u6848.png")));
        return img;
    }
}

