/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.config;

import com.github.pagehelper.PageInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.september.core.component.ApplicationContextHolder;
import org.september.smartdao.config.MyBatisConfigManager;
import org.september.smartdao.config.MyBatisResourceCustomerResolver;
import org.september.smartdao.datasource.SmartRoutingDataSource;
import org.september.smartdao.model.ParamMap;
import org.september.smartdao.mybatisPlugs.MapWrapperFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@Configuration
public class MyBatisConfig
implements TransactionManagementConfigurer {
    @Autowired(required=false)
    private MyBatisConfigManager myBatisConfigManager;
    @Resource
    SmartRoutingDataSource dataSource;
    @Autowired
    private ApplicationContextHolder applicationContextHolder;

    @Bean(name={"sqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactoryBean() {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource((DataSource)((Object)this.dataSource));
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        org.apache.ibatis.session.Configuration configuration = new org.apache.ibatis.session.Configuration();
        configuration.setCacheEnabled(false);
        configuration.setUseGeneratedKeys(true);
        configuration.setCallSettersOnNulls(true);
        configuration.setLogPrefix("dao.");
        configuration.setDefaultExecutorType(ExecutorType.REUSE);
        configuration.getTypeAliasRegistry().registerAlias("ParamMap", ParamMap.class);
        if (this.myBatisConfigManager != null) {
            this.myBatisConfigManager.config(configuration);
        }
        PageInterceptor pageInterceptor = new PageInterceptor();
        Properties prop = new Properties();
        prop.put("helperDialect", this.dataSource.getDialect());
        pageInterceptor.setProperties(prop);
        configuration.addInterceptor((Interceptor)pageInterceptor);
        bean.setConfiguration(configuration);
        bean.setObjectWrapperFactory((ObjectWrapperFactory)new MapWrapperFactory());
        try {
            org.springframework.core.io.Resource[] resources1 = new org.springframework.core.io.Resource[]{};
            resources1 = this.myBatisConfigManager != null ? resolver.getResources(this.myBatisConfigManager.getMapperLocation()) : resolver.getResources("classpath*:/mybatis/mapper/**/*.xml");
            ArrayList<org.springframework.core.io.Resource> list = new ArrayList<org.springframework.core.io.Resource>();
            org.springframework.core.io.Resource[] resourceArray = resources1;
            int n = resources1.length;
            int n2 = 0;
            while (n2 < n) {
                org.springframework.core.io.Resource res = resourceArray[n2];
                if (!res.getFilename().contains("CommonEntityMapper.xml")) {
                    list.add(res);
                }
                ++n2;
            }
            resources1 = list.toArray(new org.springframework.core.io.Resource[0]);
            ArrayList<org.springframework.core.io.Resource> resourcesList = new ArrayList<org.springframework.core.io.Resource>();
            resourcesList.add(resolver.getResource("classpath:mybatis/mapper/CommonEntityMapper.xml"));
            if (ApplicationContextHolder.getContext().getBeansOfType(MyBatisResourceCustomerResolver.class) != null) {
                for (MyBatisResourceCustomerResolver resolverx : ApplicationContextHolder.getContext().getBeansOfType(MyBatisResourceCustomerResolver.class).values()) {
                    resourcesList.addAll(resolverx.getResourcesList((ResourcePatternResolver)resolver));
                }
            }
            if (this.myBatisConfigManager != null) {
                this.myBatisConfigManager.addMapperResources(resourcesList);
            }
            org.springframework.core.io.Resource[] resources2 = resourcesList.toArray(new org.springframework.core.io.Resource[0]);
            int length = resources1.length + resourcesList.size();
            org.springframework.core.io.Resource[] resources = Arrays.copyOf(resources1, length);
            System.arraycopy(resources2, 0, resources, resources1.length, resources2.length);
            bean.setMapperLocations(resources);
            return bean.getObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Bean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Bean
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return new DataSourceTransactionManager((DataSource)((Object)this.dataSource));
    }
}

