/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.status;

import com.dji.sdk.cloudapi.device.UpdateTopo;
import com.dji.sdk.common.Common;
import com.dji.sdk.exception.CloudSDKException;
import com.dji.sdk.mqtt.MqttGatewayPublish;
import com.dji.sdk.mqtt.status.TopicStatusRequest;
import com.dji.sdk.mqtt.status.TopicStatusResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.CollectionUtils;

@Configuration
public class StatusRouter {
    @Resource
    private MqttGatewayPublish gatewayPublish;

    @Bean
    public IntegrationFlow statusRouterFlow() {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((String)"inboundStatus").transform(Message.class, source -> {
            try {
                TopicStatusRequest response = (TopicStatusRequest)Common.getObjectMapper().readValue((byte[])source.getPayload(), (TypeReference)new TypeReference<TopicStatusRequest<UpdateTopo>>(){});
                String topic = String.valueOf(source.getHeaders().get((Object)"mqtt_receivedTopic"));
                return response.setFrom(topic.substring("sys/product/".length(), topic.indexOf("/status")));
            }
            catch (IOException e) {
                throw new CloudSDKException(e);
            }
        }, null)).route(response -> Optional.ofNullable((UpdateTopo)response.getData()).map(UpdateTopo::getSubDevices).map(CollectionUtils::isEmpty).orElse(true), mapping -> mapping.channelMapping((Object)true, "inboundStatusOffline").channelMapping((Object)false, "inboundStatusOnline"))).get();
    }

    @Bean
    public IntegrationFlow replySuccessStatus() {
        return ((IntegrationFlowBuilder)IntegrationFlows.from((String)"outboundStatus").handle(this::publish)).nullChannel();
    }

    private TopicStatusResponse publish(TopicStatusResponse request, MessageHeaders headers) {
        if (Objects.isNull(request)) {
            return null;
        }
        this.gatewayPublish.publishReply(request, headers);
        return request;
    }
}

