/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.state;

import com.dji.sdk.cloudapi.device.FirmwareVersion;
import com.dji.sdk.cloudapi.device.PayloadFirmwareVersion;
import com.dji.sdk.cloudapi.device.PayloadModelConst;
import com.dji.sdk.cloudapi.device.RcDroneControlSource;
import com.dji.sdk.cloudapi.device.RcLiveStatus;
import com.dji.sdk.cloudapi.livestream.RcLivestreamAbilityUpdate;
import com.dji.sdk.exception.CloudSDKException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public enum RcStateDataKeyEnum {
    FIRMWARE_VERSION(Set.of("firmware_version"), FirmwareVersion.class),
    LIVE_CAPACITY(Set.of("live_capacity"), RcLivestreamAbilityUpdate.class),
    CONTROL_SOURCE(Set.of("control_source"), RcDroneControlSource.class),
    LIVE_STATUS(Set.of("live_status"), RcLiveStatus.class),
    PAYLOAD_FIRMWARE(PayloadModelConst.getAllModelWithPosition(), PayloadFirmwareVersion.class);

    private final Set<String> keys;
    private final Class classType;

    private RcStateDataKeyEnum(Set<String> keys, Class classType) {
        this.keys = keys;
        this.classType = classType;
    }

    public Class getClassType() {
        return this.classType;
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    public static RcStateDataKeyEnum find(Set<String> keys) {
        return Arrays.stream(RcStateDataKeyEnum.values()).filter(keyEnum -> !Collections.disjoint(keys, keyEnum.keys)).findAny().orElseThrow(() -> new CloudSDKException(RcStateDataKeyEnum.class, keys));
    }
}

