/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.requests;

import com.dji.sdk.cloudapi.config.RequestsConfigRequest;
import com.dji.sdk.cloudapi.flightarea.FlightAreasGetRequest;
import com.dji.sdk.cloudapi.map.OfflineMapGetRequest;
import com.dji.sdk.cloudapi.media.StorageConfigGet;
import com.dji.sdk.cloudapi.organization.AirportBindStatusRequest;
import com.dji.sdk.cloudapi.organization.AirportOrganizationBindRequest;
import com.dji.sdk.cloudapi.organization.AirportOrganizationGetRequest;
import com.dji.sdk.cloudapi.wayline.FlighttaskResourceGetRequest;
import java.util.Arrays;

public enum RequestsMethodEnum {
    STORAGE_CONFIG_GET("storage_config_get", "inboundRequestsStorageConfigGet", StorageConfigGet.class),
    AIRPORT_BIND_STATUS("airport_bind_status", "inboundRequestsAirportBindStatus", AirportBindStatusRequest.class),
    AIRPORT_ORGANIZATION_BIND("airport_organization_bind", "inboundRequestsAirportOrganizationBind", AirportOrganizationBindRequest.class),
    AIRPORT_ORGANIZATION_GET("airport_organization_get", "inboundRequestsAirportOrganizationGet", AirportOrganizationGetRequest.class),
    FLIGHT_TASK_RESOURCE_GET("flighttask_resource_get", "inboundRequestsFlightTaskResourceGet", FlighttaskResourceGetRequest.class),
    CONFIG("config", "inboundRequestsConfig", RequestsConfigRequest.class),
    FLIGHT_AREAS_GET("flight_areas_get", "inboundRequestsFlightAreasGet", FlightAreasGetRequest.class),
    OFFLINE_MAP_GET("offline_map_get", "inboundRequestsOfflineMapGet", OfflineMapGetRequest.class),
    UNKNOWN("", "default", Object.class);

    private final String method;
    private final String channelName;
    private final Class classType;

    private RequestsMethodEnum(String method, String channelName, Class classType) {
        this.method = method;
        this.channelName = channelName;
        this.classType = classType;
    }

    public String getMethod() {
        return this.method;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public Class getClassType() {
        return this.classType;
    }

    public static RequestsMethodEnum find(String method) {
        return Arrays.stream(RequestsMethodEnum.values()).filter(methodEnum -> methodEnum.method.equals(method)).findAny().orElse(UNKNOWN);
    }
}

