/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.osd;

import com.dji.sdk.cloudapi.device.PayloadModelConst;
import com.dji.sdk.common.Common;
import com.dji.sdk.common.SDKManager;
import com.dji.sdk.config.version.GatewayManager;
import com.dji.sdk.exception.CloudSDKException;
import com.dji.sdk.mqtt.osd.OsdDeviceTypeEnum;
import com.dji.sdk.mqtt.osd.TopicOsdRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.RouterSpec;
import org.springframework.messaging.Message;

@Configuration
public class OsdRouter {
    @Bean
    public IntegrationFlow osdRouterFlow() {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((String)"inboundOsd").transform(Message.class, source -> {
            try {
                TopicOsdRequest response = (TopicOsdRequest)Common.getObjectMapper().readValue((byte[])source.getPayload(), (TypeReference)new TypeReference<TopicOsdRequest>(){});
                String topic = String.valueOf(source.getHeaders().get((Object)"mqtt_receivedTopic"));
                return response.setFrom(topic.substring("thing/product/".length(), topic.indexOf("/osd")));
            }
            catch (IOException e) {
                throw new CloudSDKException(e);
            }
        }, null)).handle((response, headers) -> {
            GatewayManager gateway = SDKManager.getDeviceSDK(response.getGateway());
            OsdDeviceTypeEnum typeEnum = OsdDeviceTypeEnum.find(gateway.getType(), response.getFrom().equals(response.getGateway()));
            Map data = (Map)response.getData();
            if (!typeEnum.isGateway()) {
                List payloadData = data.getOrDefault("payload", new ArrayList());
                PayloadModelConst.getAllIndexWithPosition().stream().filter(data::containsKey).map(data::get).forEach(payloadData::add);
                data.put("payload", payloadData);
            }
            return response.setData(Common.getObjectMapper().convertValue((Object)data, typeEnum.getClassType()));
        })).route(response -> OsdDeviceTypeEnum.find(response.getData().getClass()), mapping -> Arrays.stream(OsdDeviceTypeEnum.values()).forEach(key -> {
            RouterSpec routerSpec2 = mapping.channelMapping((Object)key, key.getChannelName());
        }))).get();
    }
}

