/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.wayline;

import com.dji.sdk.cloudapi.device.DeviceEnum;
import com.dji.sdk.cloudapi.wayline.ActionTypeEnum;
import com.dji.sdk.cloudapi.wayline.WaylineTypeEnum;
import com.dji.sdk.common.BaseModel;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@Schema(description="The data of the wayline file.")
public class GetWaylineListResponse
extends BaseModel {
    @NotNull
    @Schema(description="wayline file name", example="waylineFile")
    @Pattern(regexp="^[^<>:\"/|?*._\\\\]+$")
    private @NotNull @Pattern(regexp="^[^<>:\"/|?*._\\\\]+$") String name;
    @NotNull
    @Pattern(regexp="^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$")
    @Schema(description="wayline file id", format="uuid")
    private @NotNull @Pattern(regexp="^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$") String id;
    @NotNull
    @JsonProperty(value="drone_model_key")
    @Schema(description="drone device product enum", example="0-67-0")
    private DeviceEnum droneModelKey;
    private String sign;
    @NotNull
    @Size(min=1)
    @JsonProperty(value="payload_model_keys")
    @Schema(description="payload device product enum", example="[\"1-53-0\"]")
    private @NotNull @Size(min=1) List<DeviceEnum> payloadModelKeys;
    @NotNull
    @Schema(description="Is the wayline file favorited?")
    private Boolean favorited;
    @NotNull
    @Size(min=1)
    @Schema(description="wayline template collection", example="[0]")
    @JsonProperty(value="template_types")
    private @NotNull @Size(min=1) List<WaylineTypeEnum> templateTypes;
    @NotNull
    @Schema(description="The key of the object in the bucket", example="wayline/waylineFile.kmz")
    @JsonProperty(value="object_key")
    private String objectKey;
    @NotNull
    @JsonProperty(value="user_name")
    @Schema(description="uploader's username", example="admin")
    private String username;
    @NotNull
    @Min(value=123456789012L)
    @Schema(description="update time (millisecond). The field named `update time` must exist in the table.", example="123456789012")
    @JsonProperty(value="update_time")
    private @NotNull @Min(value=123456789012L) Long updateTime;
    @NotNull
    @Min(value=123456789012L)
    @Schema(description="create time (millisecond). The field named `create time` must exist in the table.", example="123456789012")
    @JsonProperty(value="create_time")
    private @NotNull @Min(value=123456789012L) Long createTime;
    @JsonProperty(value="action_type")
    @Parameter(name="action_type", description="wayline template type collection", example="1")
    private ActionTypeEnum actionType;

    public String toString() {
        return "GetWaylineListResponse{name='" + this.name + "', id='" + this.id + "', droneModelKey=" + String.valueOf((Object)this.droneModelKey) + ", sign='" + this.sign + "', payloadModelKeys=" + String.valueOf(this.payloadModelKeys) + ", favorited=" + String.valueOf(this.favorited) + ", templateTypes=" + String.valueOf(this.templateTypes) + ", objectKey='" + this.objectKey + "', username='" + this.username + "', updateTime=" + String.valueOf(this.updateTime) + ", createTime=" + String.valueOf(this.createTime) + ", actionType=" + String.valueOf((Object)this.actionType) + "}";
    }

    public String getName() {
        return this.name;
    }

    public GetWaylineListResponse setName(String name) {
        this.name = name;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public GetWaylineListResponse setId(String id) {
        this.id = id;
        return this;
    }

    public DeviceEnum getDroneModelKey() {
        return this.droneModelKey;
    }

    public GetWaylineListResponse setDroneModelKey(DeviceEnum droneModelKey) {
        this.droneModelKey = droneModelKey;
        return this;
    }

    public String getSign() {
        return this.sign;
    }

    public GetWaylineListResponse setSign(String sign) {
        this.sign = sign;
        return this;
    }

    public List<DeviceEnum> getPayloadModelKeys() {
        return this.payloadModelKeys;
    }

    public GetWaylineListResponse setPayloadModelKeys(List<DeviceEnum> payloadModelKeys) {
        this.payloadModelKeys = payloadModelKeys;
        return this;
    }

    public Boolean getFavorited() {
        return this.favorited;
    }

    public GetWaylineListResponse setFavorited(Boolean favorited) {
        this.favorited = favorited;
        return this;
    }

    public List<WaylineTypeEnum> getTemplateTypes() {
        return this.templateTypes;
    }

    public GetWaylineListResponse setTemplateTypes(List<WaylineTypeEnum> templateTypes) {
        this.templateTypes = templateTypes;
        return this;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public GetWaylineListResponse setObjectKey(String objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public GetWaylineListResponse setUsername(String username) {
        this.username = username;
        return this;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public GetWaylineListResponse setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public GetWaylineListResponse setCreateTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    public ActionTypeEnum getActionType() {
        return this.actionType;
    }

    public GetWaylineListResponse setActionType(ActionTypeEnum actionType) {
        this.actionType = actionType;
        return this;
    }
}

