/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.map;

import com.dji.sdk.cloudapi.map.ElementGeometryType;
import com.dji.sdk.cloudapi.map.ElementLineStringGeometry;
import com.dji.sdk.cloudapi.map.ElementPointGeometry;
import com.dji.sdk.cloudapi.map.ElementPolygonGeometry;
import com.dji.sdk.cloudapi.map.ElementResourceTypeEnum;
import com.dji.sdk.exception.CloudSDKException;
import java.util.Optional;

public enum ElementTypeEnum {
    POINT(ElementResourceTypeEnum.POINT),
    LINE_STRING(ElementResourceTypeEnum.LINE_STRING),
    POLYGON(ElementResourceTypeEnum.POLYGON);

    private ElementResourceTypeEnum typeEnum;

    private ElementTypeEnum(ElementResourceTypeEnum typeEnum) {
        this.typeEnum = typeEnum;
    }

    public static Optional<ElementGeometryType> findType(int val) {
        if (ElementTypeEnum.POINT.typeEnum.getType() == val) {
            return Optional.of(new ElementPointGeometry());
        }
        if (ElementTypeEnum.LINE_STRING.typeEnum.getType() == val) {
            return Optional.of(new ElementLineStringGeometry());
        }
        if (ElementTypeEnum.POLYGON.typeEnum.getType() == val) {
            return Optional.of(new ElementPolygonGeometry());
        }
        return Optional.empty();
    }

    public String getDesc() {
        return this.typeEnum.getTypeName();
    }

    public static int findVal(String desc) {
        if (ElementTypeEnum.POINT.typeEnum.getTypeName().equals(desc)) {
            return ElementTypeEnum.POINT.typeEnum.getType();
        }
        if (ElementTypeEnum.LINE_STRING.typeEnum.getTypeName().equals(desc)) {
            return ElementTypeEnum.LINE_STRING.typeEnum.getType();
        }
        if (ElementTypeEnum.POLYGON.typeEnum.getTypeName().equals(desc)) {
            return ElementTypeEnum.POLYGON.typeEnum.getType();
        }
        throw new CloudSDKException("unknown type:" + desc);
    }
}

