/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.log.api;

import com.dji.sdk.cloudapi.log.FileUploadListRequest;
import com.dji.sdk.cloudapi.log.FileUploadListResponse;
import com.dji.sdk.cloudapi.log.FileUploadProgress;
import com.dji.sdk.cloudapi.log.FileUploadStartRequest;
import com.dji.sdk.cloudapi.log.FileUploadUpdateRequest;
import com.dji.sdk.cloudapi.log.LogMethodEnum;
import com.dji.sdk.config.version.GatewayManager;
import com.dji.sdk.mqtt.MqttReply;
import com.dji.sdk.mqtt.events.EventsDataRequest;
import com.dji.sdk.mqtt.events.TopicEventsRequest;
import com.dji.sdk.mqtt.events.TopicEventsResponse;
import com.dji.sdk.mqtt.services.ServicesPublish;
import com.dji.sdk.mqtt.services.ServicesReplyData;
import com.dji.sdk.mqtt.services.TopicServicesResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import javax.annotation.Resource;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.MessageHeaders;

public abstract class AbstractLogService {
    @Resource
    private ServicesPublish servicesPublish;

    @ServiceActivator(inputChannel="inboundEventsFileUploadProgress", outputChannel="outboundEvents")
    public TopicEventsResponse<MqttReply> fileuploadProgress(TopicEventsRequest<EventsDataRequest<FileUploadProgress>> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("fileuploadProgress not implemented");
    }

    public TopicServicesResponse<ServicesReplyData<FileUploadListResponse>> fileuploadList(GatewayManager gateway, FileUploadListRequest request) {
        return this.servicesPublish.publish(new TypeReference<FileUploadListResponse>(){}, gateway.getGatewaySn(), LogMethodEnum.FILE_UPLOAD_LIST.getMethod(), request);
    }

    public TopicServicesResponse<ServicesReplyData> fileuploadStart(GatewayManager gateway, FileUploadStartRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), LogMethodEnum.FILE_UPLOAD_START.getMethod(), request);
    }

    public TopicServicesResponse<ServicesReplyData> fileuploadUpdate(GatewayManager gateway, FileUploadUpdateRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), LogMethodEnum.FILE_UPLOAD_UPDATE.getMethod(), request);
    }
}

