/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.livestream.api;

import com.dji.sdk.cloudapi.livestream.DockLivestreamAbilityUpdate;
import com.dji.sdk.cloudapi.livestream.LiveLensChangeRequest;
import com.dji.sdk.cloudapi.livestream.LiveSetQualityRequest;
import com.dji.sdk.cloudapi.livestream.LiveStartPushRequest;
import com.dji.sdk.cloudapi.livestream.LiveStopPushRequest;
import com.dji.sdk.cloudapi.livestream.LiveStreamMethodEnum;
import com.dji.sdk.cloudapi.livestream.RcLivestreamAbilityUpdate;
import com.dji.sdk.config.version.GatewayManager;
import com.dji.sdk.mqtt.services.ServicesPublish;
import com.dji.sdk.mqtt.services.ServicesReplyData;
import com.dji.sdk.mqtt.services.TopicServicesResponse;
import com.dji.sdk.mqtt.state.TopicStateRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import javax.annotation.Resource;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.MessageHeaders;

public abstract class AbstractLivestreamService {
    @Resource
    private ServicesPublish servicesPublish;
    private static final long DEFAULT_TIMEOUT = 20000L;

    @ServiceActivator(inputChannel="inboundStateDockLiveCapacity")
    public void dockLivestreamAbilityUpdate(TopicStateRequest<DockLivestreamAbilityUpdate> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("dockLivestreamAbilityUpdate not implemented");
    }

    @ServiceActivator(inputChannel="inboundStateRcLiveCapacity")
    public void rcLivestreamAbilityUpdate(TopicStateRequest<RcLivestreamAbilityUpdate> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("rcLivestreamAbilityUpdate not implemented");
    }

    public TopicServicesResponse<ServicesReplyData<String>> liveStartPush(GatewayManager gateway, LiveStartPushRequest request) {
        return this.servicesPublish.publish(new TypeReference<String>(){}, gateway.getGatewaySn(), LiveStreamMethodEnum.LIVE_START_PUSH.getMethod(), (Object)request, 20000L);
    }

    public TopicServicesResponse<ServicesReplyData> liveStopPush(GatewayManager gateway, LiveStopPushRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), LiveStreamMethodEnum.LIVE_STOP_PUSH.getMethod(), (Object)request, 20000L);
    }

    public TopicServicesResponse<ServicesReplyData> liveSetQuality(GatewayManager gateway, LiveSetQualityRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), LiveStreamMethodEnum.LIVE_SET_QUALITY.getMethod(), (Object)request, 20000L);
    }

    public TopicServicesResponse<ServicesReplyData> liveLensChange(GatewayManager gateway, LiveLensChangeRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), LiveStreamMethodEnum.LIVE_LENS_CHANGE.getMethod(), (Object)request, 20000L);
    }
}

