/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.device;

import com.dji.sdk.exception.CloudSDKException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum DockModeCodeEnum {
    IDLE(0),
    DEBUGGING(1),
    REMOTE_DEBUGGING(2),
    UPGRADING(3),
    WORKING(4),
    OTHER(5);

    private final int code;

    private DockModeCodeEnum(int code) {
        this.code = code;
    }

    @JsonValue
    public int getCode() {
        return this.code;
    }

    @JsonCreator
    public static DockModeCodeEnum find(int code) {
        return Arrays.stream(DockModeCodeEnum.values()).filter(modeCode -> modeCode.code == code).findAny().orElseThrow(() -> new CloudSDKException(DockModeCodeEnum.class, code));
    }
}

