/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.control.api;

import com.dji.sdk.annotations.CloudSDKVersion;
import com.dji.sdk.cloudapi.control.CameraAimRequest;
import com.dji.sdk.cloudapi.control.CameraExposureModeSetRequest;
import com.dji.sdk.cloudapi.control.CameraExposureSetRequest;
import com.dji.sdk.cloudapi.control.CameraFocalLengthSetRequest;
import com.dji.sdk.cloudapi.control.CameraFocusModeSetRequest;
import com.dji.sdk.cloudapi.control.CameraFocusValueSetRequest;
import com.dji.sdk.cloudapi.control.CameraLookAtRequest;
import com.dji.sdk.cloudapi.control.CameraModeSwitchRequest;
import com.dji.sdk.cloudapi.control.CameraPhotoStopRequest;
import com.dji.sdk.cloudapi.control.CameraPhotoTakeProgress;
import com.dji.sdk.cloudapi.control.CameraPhotoTakeRequest;
import com.dji.sdk.cloudapi.control.CameraPointFocusActionRequest;
import com.dji.sdk.cloudapi.control.CameraRecordingStartRequest;
import com.dji.sdk.cloudapi.control.CameraRecordingStopRequest;
import com.dji.sdk.cloudapi.control.CameraScreenSplitRequest;
import com.dji.sdk.cloudapi.control.ControlMethodEnum;
import com.dji.sdk.cloudapi.control.DelayInfoPush;
import com.dji.sdk.cloudapi.control.DrcModeEnterRequest;
import com.dji.sdk.cloudapi.control.DrcStatusNotify;
import com.dji.sdk.cloudapi.control.DroneControlRequest;
import com.dji.sdk.cloudapi.control.DroneControlResponse;
import com.dji.sdk.cloudapi.control.FlyToPointProgress;
import com.dji.sdk.cloudapi.control.FlyToPointRequest;
import com.dji.sdk.cloudapi.control.FlyToPointUpdateRequest;
import com.dji.sdk.cloudapi.control.GimbalResetRequest;
import com.dji.sdk.cloudapi.control.HeartBeatRequest;
import com.dji.sdk.cloudapi.control.HsiInfoPush;
import com.dji.sdk.cloudapi.control.IrMeteringAreaSetRequest;
import com.dji.sdk.cloudapi.control.IrMeteringModeSetRequest;
import com.dji.sdk.cloudapi.control.IrMeteringPointSetRequest;
import com.dji.sdk.cloudapi.control.JoystickInvalidNotify;
import com.dji.sdk.cloudapi.control.OsdInfoPush;
import com.dji.sdk.cloudapi.control.PayloadAuthorityGrabRequest;
import com.dji.sdk.cloudapi.control.PayloadControlMethodEnum;
import com.dji.sdk.cloudapi.control.PhotoStorageSetRequest;
import com.dji.sdk.cloudapi.control.PoiCircleSpeedSetRequest;
import com.dji.sdk.cloudapi.control.PoiModeEnterRequest;
import com.dji.sdk.cloudapi.control.PoiStatusNotify;
import com.dji.sdk.cloudapi.control.TakeoffToPointProgress;
import com.dji.sdk.cloudapi.control.TakeoffToPointRequest;
import com.dji.sdk.cloudapi.control.VideoStorageSetRequest;
import com.dji.sdk.common.BaseModel;
import com.dji.sdk.common.Common;
import com.dji.sdk.common.SpringBeanUtils;
import com.dji.sdk.config.version.CloudSDKVersionEnum;
import com.dji.sdk.config.version.GatewayManager;
import com.dji.sdk.config.version.GatewayTypeEnum;
import com.dji.sdk.exception.CloudSDKException;
import com.dji.sdk.mqtt.MqttReply;
import com.dji.sdk.mqtt.drc.DrcDownPublish;
import com.dji.sdk.mqtt.drc.DrcUpData;
import com.dji.sdk.mqtt.drc.TopicDrcRequest;
import com.dji.sdk.mqtt.events.EventsDataRequest;
import com.dji.sdk.mqtt.events.TopicEventsRequest;
import com.dji.sdk.mqtt.events.TopicEventsResponse;
import com.dji.sdk.mqtt.services.ServicesPublish;
import com.dji.sdk.mqtt.services.ServicesReplyData;
import com.dji.sdk.mqtt.services.TopicServicesResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.MessageHeaders;

public abstract class AbstractControlService {
    @Resource
    protected ServicesPublish servicesPublish;
    @Resource
    private DrcDownPublish drcDownPublish;

    @ServiceActivator(inputChannel="inboundEventsFlyToPointProgress", outputChannel="outboundEvents")
    public TopicEventsResponse<MqttReply> flyToPointProgress(TopicEventsRequest<FlyToPointProgress> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("flyToPointProgress not implemented");
    }

    @ServiceActivator(inputChannel="inboundEventsTakeoffToPointProgress", outputChannel="outboundEvents")
    public TopicEventsResponse<MqttReply> takeoffToPointProgress(TopicEventsRequest<TakeoffToPointProgress> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("takeoffToPointProgress not implemented");
    }

    @ServiceActivator(inputChannel="inboundEventsDrcStatusNotify", outputChannel="outboundEvents")
    public TopicEventsResponse<MqttReply> drcStatusNotify(TopicEventsRequest<DrcStatusNotify> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("drcStatusNotify not implemented");
    }

    @ServiceActivator(inputChannel="inboundEventsJoystickInvalidNotify", outputChannel="outboundEvents")
    public TopicEventsResponse<MqttReply> joystickInvalidNotify(TopicEventsRequest<JoystickInvalidNotify> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("joystickInvalidNotify not implemented");
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> flightAuthorityGrab(GatewayManager gateway) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.FLIGHT_AUTHORITY_GRAB.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> payloadAuthorityGrab(GatewayManager gateway, PayloadAuthorityGrabRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.PAYLOAD_AUTHORITY_GRAB.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> drcModeEnter(GatewayManager gateway, DrcModeEnterRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.DRC_MODE_ENTER.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> drcModeExit(GatewayManager gateway) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.DRC_MODE_EXIT.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> takeoffToPoint(GatewayManager gateway, TakeoffToPointRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.TAKEOFF_TO_POINT.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> flyToPoint(GatewayManager gateway, FlyToPointRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.FLY_TO_POINT.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_2, exclude={GatewayTypeEnum.RC}, include={GatewayTypeEnum.DOCK})
    public TopicServicesResponse<ServicesReplyData> flyToPointUpdate(GatewayManager gateway, FlyToPointUpdateRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.FLY_TO_POINT_UPDATE.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> flyToPointStop(GatewayManager gateway) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.FLY_TO_POINT_STOP.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> cameraModeSwitch(GatewayManager gateway, CameraModeSwitchRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.CAMERA_MODE_SWITCH.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> cameraPhotoTake(GatewayManager gateway, CameraPhotoTakeRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.CAMERA_PHOTO_TAKE.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_2, exclude={GatewayTypeEnum.RC}, include={GatewayTypeEnum.DOCK})
    public TopicServicesResponse<ServicesReplyData> cameraPhotoStop(GatewayManager gateway, CameraPhotoStopRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.CAMERA_PHOTO_STOP.getMethod(), request);
    }

    @ServiceActivator(inputChannel="inboundEventsCameraPhotoTakeProgress", outputChannel="outboundEvents")
    public TopicEventsResponse<MqttReply> cameraPhotoTakeProgress(TopicEventsRequest<EventsDataRequest<CameraPhotoTakeProgress>> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("cameraPhotoTakeProgress not implemented");
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> cameraRecordingStart(GatewayManager gateway, CameraRecordingStartRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.CAMERA_RECORDING_START.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> cameraRecordingStop(GatewayManager gateway, CameraRecordingStopRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.CAMERA_RECORDING_STOP.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> cameraAim(GatewayManager gateway, CameraAimRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.CAMERA_AIM.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> cameraFocalLengthSet(GatewayManager gateway, CameraFocalLengthSetRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.CAMERA_FOCAL_LENGTH_SET.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> gimbalReset(GatewayManager gateway, GimbalResetRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.GIMBAL_RESET.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0, exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> cameraLookAt(GatewayManager gateway, CameraLookAtRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.CAMERA_LOOK_AT.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0, exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> cameraScreenSplit(GatewayManager gateway, CameraScreenSplitRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.CAMERA_SCREEN_SPLIT.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0, exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> photoStorageSet(GatewayManager gateway, PhotoStorageSetRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.PHOTO_STORAGE_SET.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0, exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> videoStorageSet(GatewayManager gateway, VideoStorageSetRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.VIDEO_STORAGE_SET.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_2, include={GatewayTypeEnum.DOCK})
    public TopicServicesResponse<ServicesReplyData> cameraExposureSet(GatewayManager gateway, CameraExposureSetRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.CAMERA_EXPOSURE_SET.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_2, include={GatewayTypeEnum.DOCK})
    public TopicServicesResponse<ServicesReplyData> cameraExposureModeSet(GatewayManager gateway, CameraExposureModeSetRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.CAMERA_EXPOSURE_MODE_SET.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_2, include={GatewayTypeEnum.DOCK})
    public TopicServicesResponse<ServicesReplyData> cameraFocusModeSet(GatewayManager gateway, CameraFocusModeSetRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.CAMERA_FOCUS_MODE_SET.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_2, include={GatewayTypeEnum.DOCK})
    public TopicServicesResponse<ServicesReplyData> cameraFocusValueSet(GatewayManager gateway, CameraFocusValueSetRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.CAMERA_FOCUS_VALUE_SET.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_2, include={GatewayTypeEnum.DOCK})
    public TopicServicesResponse<ServicesReplyData> irMeteringModeSet(GatewayManager gateway, IrMeteringModeSetRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.IR_METERING_MODE_SET.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_2, include={GatewayTypeEnum.DOCK})
    public TopicServicesResponse<ServicesReplyData> irMeteringPointSet(GatewayManager gateway, IrMeteringPointSetRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.IR_METERING_POINT_SET.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_2, include={GatewayTypeEnum.DOCK})
    public TopicServicesResponse<ServicesReplyData> irMeteringAreaSet(GatewayManager gateway, IrMeteringAreaSetRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.IR_METERING_AREA_SET.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_2, include={GatewayTypeEnum.DOCK})
    public TopicServicesResponse<ServicesReplyData> cameraPointFocusAction(GatewayManager gateway, CameraPointFocusActionRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.CAMERA_POINT_FOCUS_ACTION.getMethod(), request);
    }

    public TopicServicesResponse<ServicesReplyData> payloadControl(GatewayManager gateway, PayloadControlMethodEnum methodEnum, BaseModel request) {
        try {
            AbstractControlService abstractControlService = (AbstractControlService)SpringBeanUtils.getBean(this.getClass());
            Method method = abstractControlService.getClass().getDeclaredMethod(Common.convertSnake(methodEnum.getPayloadMethod().getMethod()), GatewayManager.class, methodEnum.getClazz());
            return (TopicServicesResponse)method.invoke((Object)abstractControlService, gateway, request);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new CloudSDKException(e);
        }
        catch (InvocationTargetException e) {
            throw new CloudSDKException(e.getTargetException());
        }
    }

    @ServiceActivator(inputChannel="inboundEventsPoiStatusNotify", outputChannel="outboundEvents")
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_2, include={GatewayTypeEnum.DOCK})
    public TopicEventsResponse<MqttReply> poiStatusNotify(TopicEventsRequest<PoiStatusNotify> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("poiStatusNotify not implemented");
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_2, exclude={GatewayTypeEnum.RC}, include={GatewayTypeEnum.DOCK})
    public TopicServicesResponse<ServicesReplyData> poiModeEnter(GatewayManager gateway, PoiModeEnterRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.POI_MODE_ENTER.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_2, exclude={GatewayTypeEnum.RC}, include={GatewayTypeEnum.DOCK})
    public TopicServicesResponse<ServicesReplyData> poiModeExit(GatewayManager gateway) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.POI_MODE_EXIT.getMethod());
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_2, exclude={GatewayTypeEnum.RC}, include={GatewayTypeEnum.DOCK})
    public TopicServicesResponse<ServicesReplyData> poiCircleSpeedSet(GatewayManager gateway, PoiCircleSpeedSetRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.POI_CIRCLE_SPEED_SET.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    protected void droneControlDown(GatewayManager gateway, DroneControlRequest request) {
        this.drcDownPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.DRONE_CONTROL.getMethod(), request);
    }

    @ServiceActivator(inputChannel="inboundDrcUpDroneControl")
    public void droneControlUp(TopicDrcRequest<DrcUpData<DroneControlResponse>> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("droneControlUp not implemented");
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public void droneEmergencyStopDown(GatewayManager gateway) {
        this.drcDownPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.DRONE_EMERGENCY_STOP.getMethod());
    }

    @ServiceActivator(inputChannel="inboundDrcUpDroneEmergencyStop")
    public void droneEmergencyStopUp(TopicDrcRequest<DrcUpData> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("droneEmergencyStopUp not implemented");
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public void heartBeatDown(GatewayManager gateway, HeartBeatRequest request) {
        this.drcDownPublish.publish(gateway.getGatewaySn(), ControlMethodEnum.HEART_BEAT.getMethod(), request);
    }

    @ServiceActivator(inputChannel="inboundDrcUpHeartBeat")
    public void heartBeatUp(TopicDrcRequest<HeartBeatRequest> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("heartBeatUp not implemented");
    }

    @ServiceActivator(inputChannel="inboundDrcUpHsiInfoPush")
    public void hsiInfoPush(TopicDrcRequest<HsiInfoPush> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("hsiInfoPush not implemented");
    }

    @ServiceActivator(inputChannel="inboundDrcUpDelayInfoPush")
    public void delayInfoPush(TopicDrcRequest<DelayInfoPush> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("delayInfoPush not implemented");
    }

    @ServiceActivator(inputChannel="inboundDrcUpOsdInfoPush")
    public void osdInfoPush(TopicDrcRequest<OsdInfoPush> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("osdInfoPush not implemented");
    }
}

