/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.engine;

import ai.djl.BaseModel;
import ai.djl.Device;
import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.nn.Block;
import ai.djl.paddlepaddle.engine.PaddlePredictor;
import ai.djl.paddlepaddle.engine.PpNDManager;
import ai.djl.paddlepaddle.engine.PpPredictor;
import ai.djl.paddlepaddle.engine.PpSymbolBlock;
import ai.djl.paddlepaddle.jni.JniUtils;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Translator;
import ai.djl.util.Utils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;

public class PpModel
extends BaseModel {
    private PaddlePredictor paddlePredictor;
    private Device device;

    PpModel(String name, Device device, NDManager manager) {
        super(name);
        this.device = device == null ? Device.cpu() : device;
        this.manager = manager;
        this.dataType = DataType.FLOAT32;
        manager.setName("PpModel");
    }

    public void load(Path modelPath, String prefix, Map<String, ?> options) throws IOException {
        this.setModelDir(modelPath);
        String[] modelFiles = this.findModelFile(this.modelDir);
        if (modelFiles.length == 0) {
            throw new FileNotFoundException("no __model__ or model file found in: " + this.modelDir);
        }
        long config = JniUtils.createConfig(modelFiles[0], modelFiles[1], this.device);
        if (options != null) {
            if (options.containsKey("removePass")) {
                String[] values;
                for (String value : values = ((String)options.get("removePass")).split(",")) {
                    JniUtils.removePass(config, value);
                }
            }
            if (options.containsKey("enableMKLDNN")) {
                JniUtils.enableMKLDNN(config);
            }
            if (options.containsKey("DisableGlog")) {
                JniUtils.disableGLog(config);
            }
            if (options.containsKey("CMLNumThreads")) {
                JniUtils.cpuMathLibraryNumThreads(config, ArgumentsUtil.intValue(options, (String)"CMLNumThreads"));
            }
            if (options.containsKey("SwitchIrOptim")) {
                JniUtils.switchIrOptim(config, ArgumentsUtil.booleanValue(options, (String)"SwitchIrOptim"));
            }
            if (options.containsKey("enableONNXRuntime")) {
                JniUtils.enableONNXRuntime(config);
            }
            if (options.containsKey("enableOrtOptimization")) {
                JniUtils.enableOrtOptimization(config);
            }
        }
        this.paddlePredictor = new PaddlePredictor(JniUtils.createPredictor(config));
        JniUtils.deleteConfig(config);
        this.setBlock((Block)new PpSymbolBlock(this.paddlePredictor, (PpNDManager)this.manager));
    }

    private String[] findModelFile(Path dir) {
        String[][] patterns;
        String[] paths = new String[2];
        for (String[] pattern : patterns = new String[][]{{"model", "params"}, {"__model__", "__params__"}, {"inference.pdmodel", "inference.pdiparams"}}) {
            Path modelFile = dir.resolve(pattern[0]);
            if (!Files.isRegularFile(modelFile, new LinkOption[0])) continue;
            paths[0] = modelFile.toString();
            Path paramFile = dir.resolve(pattern[1]);
            if (Files.isRegularFile(paramFile, new LinkOption[0])) {
                paths[1] = paramFile.toString();
            } else {
                paths[0] = dir.toString();
            }
            return paths;
        }
        return Utils.EMPTY_ARRAY;
    }

    public <I, O> Predictor<I, O> newPredictor(Translator<I, O> translator, Device device) {
        return new PpPredictor<I, O>((Model)this, this.paddlePredictor.copy(), translator, device);
    }

    public void close() {
        if (this.paddlePredictor != null) {
            JniUtils.deletePredictor(this.paddlePredictor);
            this.paddlePredictor = null;
        }
        super.close();
    }
}

