/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.Application;
import ai.djl.Model;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.cv.translator.ImageClassificationTranslator;
import ai.djl.modality.cv.translator.ImageServingTranslator;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.NoopServingTranslatorFactory;
import ai.djl.translate.ServingTranslator;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.Pair;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServingTranslatorFactory
implements TranslatorFactory {
    private static final Logger logger = LoggerFactory.getLogger(ServingTranslatorFactory.class);

    @Override
    public Set<Pair<Type, Type>> getSupportedTypes() {
        return Collections.singleton(new Pair<Class<Input>, Class<Output>>(Input.class, Output.class));
    }

    @Override
    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) throws TranslateException {
        TranslatorFactory factory;
        if (!this.isSupported(input, output)) {
            throw new IllegalArgumentException("Unsupported input/output types.");
        }
        Path modelDir = model.getModelPath();
        String factoryClass = ArgumentsUtil.stringValue(arguments, "translatorFactory");
        if (factoryClass != null && !factoryClass.isEmpty() && (factory = this.loadTranslatorFactory(factoryClass)) != null && factory.isSupported(input, output)) {
            logger.info("Using TranslatorFactory: {}", (Object)factory.getClass().getName());
            return factory.newInstance(input, output, model, arguments);
        }
        String className = (String)arguments.get("translator");
        Path libPath = modelDir.resolve("libs");
        if (!Files.isDirectory(libPath, new LinkOption[0]) && !Files.isDirectory(libPath = modelDir.resolve("lib"), new LinkOption[0]) && className == null) {
            return this.loadDefaultTranslator(arguments);
        }
        ServingTranslator translator = this.findTranslator(libPath, className);
        if (translator != null) {
            translator.setArguments(arguments);
            logger.info("Using translator: {}", (Object)translator.getClass().getName());
            return translator;
        }
        if (className != null) {
            throw new TranslateException("Failed to load translator: " + className);
        }
        return this.loadDefaultTranslator(arguments);
    }

    private ServingTranslator findTranslator(Path path, String className) {
        Path classesDir = path.resolve("classes");
        ClassLoaderUtils.compileJavaClass(classesDir);
        return ClassLoaderUtils.findImplementation(path, ServingTranslator.class, className);
    }

    private TranslatorFactory loadTranslatorFactory(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Class<TranslatorFactory> subclass = clazz.asSubclass(TranslatorFactory.class);
            Constructor<TranslatorFactory> constructor = subclass.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            logger.trace("Not able to load TranslatorFactory: " + className, e);
            return null;
        }
    }

    private Translator<Input, Output> loadDefaultTranslator(Map<String, ?> arguments) {
        Application application;
        String appName = ArgumentsUtil.stringValue(arguments, "application");
        if (appName != null && (application = Application.of(appName)) == Application.CV.IMAGE_CLASSIFICATION) {
            return this.getImageClassificationTranslator(arguments);
        }
        NoopServingTranslatorFactory factory = new NoopServingTranslatorFactory();
        return factory.newInstance(Input.class, Output.class, null, arguments);
    }

    private Translator<Input, Output> getImageClassificationTranslator(Map<String, ?> arguments) {
        return new ImageServingTranslator(ImageClassificationTranslator.builder(arguments).build());
    }
}

