/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.sunchenbin.mybatis.actable.manager.system;

import com.baomidou.mybatisplus.annotation.TableName;
import com.gitee.sunchenbin.mybatis.actable.annotation.IgnoreUpdate;
import com.gitee.sunchenbin.mybatis.actable.annotation.Index;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import com.gitee.sunchenbin.mybatis.actable.annotation.Unique;
import com.gitee.sunchenbin.mybatis.actable.command.CreateTableParam;
import com.gitee.sunchenbin.mybatis.actable.command.MySqlTypeAndLength;
import com.gitee.sunchenbin.mybatis.actable.command.SysMysqlColumns;
import com.gitee.sunchenbin.mybatis.actable.command.SysMysqlTable;
import com.gitee.sunchenbin.mybatis.actable.command.TableConfig;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlCharsetConstant;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlEngineConstant;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlTypeConstant;
import com.gitee.sunchenbin.mybatis.actable.dao.system.CreateMysqlTablesMapper;
import com.gitee.sunchenbin.mybatis.actable.manager.system.SysMysqlCreateTableManager;
import com.gitee.sunchenbin.mybatis.actable.manager.util.ConfigurationUtil;
import com.gitee.sunchenbin.mybatis.actable.utils.ClassScaner;
import com.gitee.sunchenbin.mybatis.actable.utils.ClassTools;
import com.gitee.sunchenbin.mybatis.actable.utils.ColumnUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Transactional
@Service(value="sysMysqlCreateTableManager")
public class SysMysqlCreateTableManagerImpl
implements SysMysqlCreateTableManager {
    private static final Logger log = LoggerFactory.getLogger(SysMysqlCreateTableManagerImpl.class);
    @Autowired
    private CreateMysqlTablesMapper createMysqlTablesMapper;
    @Autowired
    private ConfigurationUtil springContextUtil;
    private static String pack = null;
    private static String tableAuto = null;

    @Override
    public void createMysqlTable() {
        pack = this.springContextUtil.getConfig("mybatis.model.pack");
        tableAuto = this.springContextUtil.getConfig("mybatis.table.auto");
        if (!("none".equals(tableAuto) || "update".equals(tableAuto) || "create".equals(tableAuto) || "add".equals(tableAuto))) {
            log.warn("\u914d\u7f6emybatis.table.auto\u9519\u8bef\u65e0\u6cd5\u8bc6\u522b\uff0c\u5f53\u524d\u914d\u7f6e\u53ea\u652f\u6301[none/update/create/add]\u4e09\u79cd\u7c7b\u578b!");
            return;
        }
        if ("none".equals(tableAuto)) {
            log.info("\u914d\u7f6emybatis.table.auto=none\uff0c\u4e0d\u9700\u8981\u505a\u4efb\u4f55\u4e8b\u60c5");
            return;
        }
        String[] packs = pack.split(",|;");
        Set<Class> classes = ClassScaner.scan(packs, Table.class, TableName.class, javax.persistence.Table.class);
        Map<String, Map<String, TableConfig>> baseTableMap = this.initTableMap();
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Class clas : classes) {
            if (!ColumnUtils.hasTableAnnotation(clas) || ColumnUtils.hasIgnoreTableAnnotation(clas)) {
                log.warn("{}\uff0c\u6ca1\u6709@Table\u6216\u914d\u7f6e\u4e86@IgnoreTable\u6ce8\u89e3\u76f4\u63a5\u8df3\u8fc7", (Object)clas.getName());
                continue;
            }
            this.checkTableName(tableNames, clas);
            this.buildTableMapConstruct(clas, baseTableMap);
        }
        this.createOrModifyTableConstruct(baseTableMap);
    }

    private void checkTableName(List<String> tableNames, Class<?> clas) {
        String tableName = ColumnUtils.getTableName(clas);
        if (tableNames.contains(tableName)) {
            throw new RuntimeException(tableName + "\u8868\u540d\u51fa\u73b0\u91cd\u590d\uff0c\u7981\u6b62\u521b\u5efa\uff01");
        }
        tableNames.add(tableName);
    }

    private Map<String, Map<String, TableConfig>> initTableMap() {
        HashMap<String, Map<String, TableConfig>> baseTableMap = new HashMap<String, Map<String, TableConfig>>();
        baseTableMap.put("newTableMap", new HashMap());
        baseTableMap.put("modifyTableMap", new HashMap());
        baseTableMap.put("addTableMap", new HashMap());
        baseTableMap.put("removeTableMap", new HashMap());
        baseTableMap.put("dropKeyTableMap", new HashMap());
        baseTableMap.put("dropIndexAndUniqueTableMap", new HashMap());
        baseTableMap.put("addIndexTableMap", new HashMap());
        baseTableMap.put("addUniqueTableMap", new HashMap());
        baseTableMap.put("modifyTablePropertyMap", new HashMap());
        return baseTableMap;
    }

    private void buildTableMapConstruct(Class<?> clas, Map<String, Map<String, TableConfig>> baseTableMap) {
        SysMysqlTable table;
        List<Object> allFieldList;
        String tableName = ColumnUtils.getTableName(clas);
        String tableComment = ColumnUtils.getTableComment(clas);
        MySqlCharsetConstant tableCharset = ColumnUtils.getTableCharset(clas);
        MySqlEngineConstant tableEngine = ColumnUtils.getTableEngine(clas);
        try {
            allFieldList = this.getAllFields(clas);
            if (allFieldList.size() == 0) {
                log.warn("\u626b\u63cf\u53d1\u73b0" + clas.getName() + "\u6ca1\u6709\u5efa\u8868\u5b57\u6bb5\u8bf7\u68c0\u67e5\uff01");
                return;
            }
        }
        catch (Exception e) {
            log.error("\u8868\uff1a{}\uff0c\u521d\u59cb\u5316\u5b57\u6bb5\u7ed3\u6784\u5931\u8d25\uff01", (Object)tableName);
            throw new RuntimeException(e);
        }
        if ("create".equals(tableAuto)) {
            log.info("\u7531\u4e8e\u914d\u7f6e\u7684\u6a21\u5f0f\u662fcreate\uff0c\u56e0\u6b64\u5148\u5220\u9664\u8868\u540e\u7eed\u6839\u636e\u7ed3\u6784\u91cd\u5efa\uff0c\u5220\u9664\u8868\uff1a{}", (Object)tableName);
            this.createMysqlTablesMapper.dropTableByName(tableName);
        }
        if ((table = this.createMysqlTablesMapper.findTableByTableName(tableName)) == null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (!StringUtils.isEmpty((Object)tableComment)) {
                map.put("table_comment", tableComment);
            }
            if (tableCharset != null && tableCharset != MySqlCharsetConstant.DEFAULT) {
                map.put("table_collation", tableCharset.toString().toLowerCase());
            }
            if (tableEngine != null && tableEngine != MySqlEngineConstant.DEFAULT) {
                map.put("engine", tableEngine.toString());
            }
            baseTableMap.get("newTableMap").put(tableName, new TableConfig(allFieldList, map));
            baseTableMap.get("addIndexTableMap").put(tableName, new TableConfig(this.getAddIndexList(null, allFieldList)));
            baseTableMap.get("addUniqueTableMap").put(tableName, new TableConfig(this.getAddUniqueList(null, allFieldList)));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((Object)tableComment) && !tableComment.equals(table.getTable_comment())) {
            map.put("table_comment", tableComment);
        }
        if (tableCharset != null && tableCharset != MySqlCharsetConstant.DEFAULT && !tableCharset.toString().toLowerCase().equals(table.getTable_collation().replace("_general_ci", ""))) {
            map.put("table_collation", tableCharset.toString().toLowerCase());
        }
        if (tableEngine != null && tableEngine != MySqlEngineConstant.DEFAULT && !tableEngine.toString().equals(table.getEngine())) {
            map.put("engine", tableEngine.toString());
        }
        baseTableMap.get("modifyTablePropertyMap").put(tableName, new TableConfig(map));
        List<SysMysqlColumns> tableColumnList = this.createMysqlTablesMapper.findTableEnsembleByTableName(tableName);
        List<String> columnNames = ClassTools.getPropertyValueList(tableColumnList, "column_name");
        List<Object> addFieldList = this.getAddFieldList(allFieldList, columnNames);
        List<Object> removeFieldList = this.getRemoveFieldList(columnNames, allFieldList);
        List<Object> modifyFieldList = this.getModifyFieldList(tableColumnList, allFieldList);
        List<Object> dropKeyFieldList = this.getDropKeyFieldList(tableColumnList, allFieldList);
        String uniPrefix = this.springContextUtil.getConfig("actable.unique.prefix");
        String idxPrefix = this.springContextUtil.getConfig("actable.index.prefix");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tableName", tableName);
        paramMap.put("uniquePrefix", uniPrefix);
        paramMap.put("indexPrefix", idxPrefix);
        Set<String> allIndexAndUniqueNames = this.createMysqlTablesMapper.findTableIndexByTableName(paramMap);
        List<Object> dropIndexAndUniqueFieldList = this.getDropIndexAndUniqueList(allIndexAndUniqueNames, allFieldList);
        List<Object> addIndexFieldList = this.getAddIndexList(allIndexAndUniqueNames, allFieldList);
        List<Object> addUniqueFieldList = this.getAddUniqueList(allIndexAndUniqueNames, allFieldList);
        if (addFieldList.size() != 0) {
            baseTableMap.get("addTableMap").put(tableName, new TableConfig(addFieldList));
        }
        if (removeFieldList.size() != 0) {
            baseTableMap.get("removeTableMap").put(tableName, new TableConfig(removeFieldList));
        }
        if (modifyFieldList.size() != 0) {
            baseTableMap.get("modifyTableMap").put(tableName, new TableConfig(modifyFieldList));
        }
        if (dropKeyFieldList.size() != 0) {
            baseTableMap.get("dropKeyTableMap").put(tableName, new TableConfig(dropKeyFieldList));
        }
        if (dropIndexAndUniqueFieldList.size() != 0) {
            baseTableMap.get("dropIndexAndUniqueTableMap").put(tableName, new TableConfig(dropIndexAndUniqueFieldList));
        }
        if (addIndexFieldList.size() != 0) {
            baseTableMap.get("addIndexTableMap").put(tableName, new TableConfig(addIndexFieldList));
        }
        if (addUniqueFieldList.size() != 0) {
            baseTableMap.get("addUniqueTableMap").put(tableName, new TableConfig(addUniqueFieldList));
        }
    }

    private List<Object> getAddIndexList(Set<String> allIndexAndUniqueNames, List<Object> allFieldList) {
        ArrayList<Object> addIndexFieldList = new ArrayList<Object>();
        if (null == allIndexAndUniqueNames) {
            allIndexAndUniqueNames = new HashSet<String>();
        }
        for (Object obj : allFieldList) {
            CreateTableParam createTableParam = (CreateTableParam)obj;
            if (null == createTableParam.getFiledIndexName() || allIndexAndUniqueNames.contains(createTableParam.getFiledIndexName())) continue;
            addIndexFieldList.add(createTableParam);
        }
        return addIndexFieldList;
    }

    private List<Object> getAddUniqueList(Set<String> allIndexAndUniqueNames, List<Object> allFieldList) {
        ArrayList<Object> addUniqueFieldList = new ArrayList<Object>();
        if (null == allIndexAndUniqueNames) {
            allIndexAndUniqueNames = new HashSet<String>();
        }
        for (Object obj : allFieldList) {
            CreateTableParam createTableParam = (CreateTableParam)obj;
            if (null == createTableParam.getFiledUniqueName() || allIndexAndUniqueNames.contains(createTableParam.getFiledUniqueName())) continue;
            addUniqueFieldList.add(createTableParam);
        }
        return addUniqueFieldList;
    }

    private List<Object> getDropIndexAndUniqueList(Set<String> allIndexAndUniqueNames, List<Object> allFieldList) {
        ArrayList<Object> dropIndexAndUniqueFieldList = new ArrayList<Object>();
        if (null == allIndexAndUniqueNames || allIndexAndUniqueNames.size() == 0) {
            return dropIndexAndUniqueFieldList;
        }
        ArrayList<String> currentModelIndexAndUnique = new ArrayList<String>();
        for (Object obj : allFieldList) {
            CreateTableParam createTableParam = (CreateTableParam)obj;
            if (null != createTableParam.getFiledIndexName()) {
                currentModelIndexAndUnique.add(createTableParam.getFiledIndexName());
            }
            if (null == createTableParam.getFiledUniqueName()) continue;
            currentModelIndexAndUnique.add(createTableParam.getFiledUniqueName());
        }
        for (String string : allIndexAndUniqueNames) {
            if (currentModelIndexAndUnique.contains(string)) continue;
            dropIndexAndUniqueFieldList.add(string);
        }
        return dropIndexAndUniqueFieldList;
    }

    private List<Object> getDropKeyFieldList(List<SysMysqlColumns> tableColumnList, List<Object> allFieldList) {
        Map<String, CreateTableParam> fieldMap = this.getAllFieldMap(allFieldList);
        ArrayList<Object> dropKeyFieldList = new ArrayList<Object>();
        for (SysMysqlColumns sysColumn : tableColumnList) {
            CreateTableParam createTableParam = fieldMap.get(sysColumn.getColumn_name().toLowerCase());
            if (createTableParam == null || !"PRI".equals(sysColumn.getColumn_key()) || createTableParam.isFieldIsKey()) continue;
            dropKeyFieldList.add(createTableParam);
        }
        return dropKeyFieldList;
    }

    private List<Object> getModifyFieldList(List<SysMysqlColumns> tableColumnList, List<Object> allFieldList) {
        Map<String, CreateTableParam> fieldMap = this.getAllFieldMap(allFieldList);
        ArrayList<Object> modifyFieldList = new ArrayList<Object>();
        for (SysMysqlColumns sysColumn : tableColumnList) {
            CreateTableParam createTableParam = fieldMap.get(sysColumn.getColumn_name().toLowerCase());
            if (createTableParam == null || createTableParam.getIgnoreUpdate()) continue;
            CreateTableParam modifyTableParam = createTableParam.clone();
            if (!"PRI".equals(sysColumn.getColumn_key()) && createTableParam.isFieldIsKey()) {
                modifyFieldList.add(modifyTableParam);
                continue;
            }
            if ("PRI".equals(sysColumn.getColumn_key()) && createTableParam.isFieldIsKey()) {
                modifyTableParam.setFieldIsKey(false);
            }
            if (!sysColumn.getData_type().toLowerCase().equals(createTableParam.getFieldType().toLowerCase())) {
                modifyFieldList.add(modifyTableParam);
                continue;
            }
            String typeAndLength = createTableParam.getFieldType().toLowerCase();
            if (createTableParam.getFileTypeLength() == 1) {
                typeAndLength = typeAndLength + "(" + createTableParam.getFieldLength() + ")";
            } else if (createTableParam.getFileTypeLength() == 2) {
                typeAndLength = typeAndLength + "(" + createTableParam.getFieldLength() + "," + createTableParam.getFieldDecimalLength() + ")";
            }
            if (!sysColumn.getColumn_type().toLowerCase().equals(typeAndLength)) {
                modifyFieldList.add(modifyTableParam);
                continue;
            }
            if ("auto_increment".equals(sysColumn.getExtra()) && !createTableParam.isFieldIsAutoIncrement()) {
                modifyFieldList.add(modifyTableParam);
                continue;
            }
            if (!"auto_increment".equals(sysColumn.getExtra()) && createTableParam.isFieldIsAutoIncrement()) {
                modifyFieldList.add(modifyTableParam);
                continue;
            }
            if (sysColumn.getColumn_default() == null || sysColumn.getColumn_default().equals("")) {
                if (createTableParam.getFieldDefaultValue() != null && !"DEFAULT".equals(createTableParam.getFieldDefaultValue())) {
                    modifyFieldList.add(modifyTableParam);
                    continue;
                }
            } else if (!sysColumn.getColumn_default().equals(createTableParam.getFieldDefaultValue())) {
                if (MySqlTypeConstant.BIT.toString().toLowerCase().equals(createTableParam.getFieldType()) && !createTableParam.isFieldDefaultValueNative()) {
                    if (("true".equals(createTableParam.getFieldDefaultValue()) || "1".equals(createTableParam.getFieldDefaultValue())) && !"b'1'".equals(sysColumn.getColumn_default())) {
                        modifyFieldList.add(modifyTableParam);
                        continue;
                    }
                    if (("false".equals(createTableParam.getFieldDefaultValue()) || "0".equals(createTableParam.getFieldDefaultValue())) && !"b'0'".equals(sysColumn.getColumn_default())) {
                        modifyFieldList.add(modifyTableParam);
                        continue;
                    }
                } else {
                    modifyFieldList.add(modifyTableParam);
                    continue;
                }
            }
            if (sysColumn.getIs_nullable().equals("NO") && !createTableParam.isFieldIsKey()) {
                if (createTableParam.isFieldIsNull()) {
                    modifyFieldList.add(modifyTableParam);
                    continue;
                }
            } else if (sysColumn.getIs_nullable().equals("YES") && !createTableParam.isFieldIsKey() && !createTableParam.isFieldIsNull()) {
                modifyFieldList.add(modifyTableParam);
                continue;
            }
            if (sysColumn.getColumn_comment().equals(createTableParam.getFieldComment())) continue;
            modifyFieldList.add(modifyTableParam);
        }
        return modifyFieldList;
    }

    private Map<String, CreateTableParam> getAllFieldMap(List<Object> allFieldList) {
        HashMap<String, CreateTableParam> fieldMap = new HashMap<String, CreateTableParam>();
        for (Object obj : allFieldList) {
            CreateTableParam createTableParam = (CreateTableParam)obj;
            fieldMap.put(createTableParam.getFieldName().toLowerCase(), createTableParam);
        }
        return fieldMap;
    }

    private List<Object> getRemoveFieldList(List<String> columnNames, List<Object> allFieldList) {
        List<String> toLowerCaseColumnNames = ClassTools.toLowerCase(columnNames);
        Map<String, CreateTableParam> fieldMap = this.getAllFieldMap(allFieldList);
        ArrayList<Object> removeFieldList = new ArrayList<Object>();
        for (String fieldNm : toLowerCaseColumnNames) {
            if (fieldMap.get(fieldNm) != null) continue;
            removeFieldList.add(fieldNm);
        }
        return removeFieldList;
    }

    private List<Object> getAddFieldList(List<Object> allFieldList, List<String> columnNames) {
        List<String> toLowerCaseColumnNames = ClassTools.toLowerCase(columnNames);
        ArrayList<Object> addFieldList = new ArrayList<Object>();
        for (Object obj : allFieldList) {
            CreateTableParam createTableParam = (CreateTableParam)obj;
            if (toLowerCaseColumnNames.contains(createTableParam.getFieldName().toLowerCase())) continue;
            addFieldList.add(obj);
        }
        return addFieldList;
    }

    @Override
    public List<Object> getAllFields(Class<?> clas) {
        String idxPrefix = this.springContextUtil.getConfig("actable.index.prefix");
        String uniPrefix = this.springContextUtil.getConfig("actable.unique.prefix");
        ArrayList<Object> fieldList = new ArrayList<Object>();
        Field[] fields = clas.getDeclaredFields();
        for (Field field : fields = this.recursionParents(clas, fields)) {
            IgnoreUpdate ignoreUpdate;
            Unique unique;
            if (!ColumnUtils.hasColumnAnnotation(field, clas)) continue;
            CreateTableParam param = new CreateTableParam();
            param.setFieldName(ColumnUtils.getColumnName(field, clas));
            MySqlTypeAndLength mySqlTypeAndLength = ColumnUtils.getMySqlTypeAndLength(field, clas);
            param.setFieldType(mySqlTypeAndLength.getType().toLowerCase());
            param.setFileTypeLength(mySqlTypeAndLength.getLengthCount());
            if (mySqlTypeAndLength.getLengthCount() == 1) {
                param.setFieldLength(mySqlTypeAndLength.getLength());
            } else if (mySqlTypeAndLength.getLengthCount() == 2) {
                param.setFieldLength(mySqlTypeAndLength.getLength());
                param.setFieldDecimalLength(mySqlTypeAndLength.getDecimalLength());
            }
            param.setFieldIsNull(ColumnUtils.isNull(field, clas));
            param.setFieldIsKey(ColumnUtils.isKey(field, clas));
            param.setFieldIsAutoIncrement(ColumnUtils.isAutoIncrement(field, clas));
            param.setFieldDefaultValue(ColumnUtils.getDefaultValue(field, clas));
            param.setFieldDefaultValueNative(ColumnUtils.getDefaultValueNative(field, clas));
            param.setFieldComment(ColumnUtils.getComment(field, clas));
            Index index = field.getAnnotation(Index.class);
            if (null != index) {
                String[] indexValue = index.columns();
                param.setFiledIndexName(index.value() == null || index.value().equals("") ? idxPrefix + (indexValue.length == 0 ? ColumnUtils.getColumnName(field, clas) : this.stringArrFormat(indexValue)) : idxPrefix + index.value());
                param.setFiledIndexValue(indexValue.length == 0 ? Arrays.asList(ColumnUtils.getColumnName(field, clas)) : Arrays.asList(indexValue));
            }
            if (null != (unique = field.getAnnotation(Unique.class))) {
                String[] uniqueValue = unique.columns();
                param.setFiledUniqueName(unique.value() == null || unique.value().equals("") ? uniPrefix + (uniqueValue.length == 0 ? ColumnUtils.getColumnName(field, clas) : this.stringArrFormat(uniqueValue)) : uniPrefix + unique.value());
                param.setFiledUniqueValue(uniqueValue.length == 0 ? Arrays.asList(ColumnUtils.getColumnName(field, clas)) : Arrays.asList(uniqueValue));
            }
            if (null != (ignoreUpdate = field.getAnnotation(IgnoreUpdate.class))) {
                param.setIgnoreUpdate(ignoreUpdate.value());
            }
            fieldList.add(param);
        }
        return fieldList;
    }

    private String stringArrFormat(String[] arr) {
        return String.valueOf(Arrays.toString(arr)).replaceAll(",", "_").replaceAll(" ", "").replace("[", "").replace("]", "");
    }

    private Field[] recursionParents(Class<?> clas, Field[] fields) {
        if (clas.getSuperclass() != null) {
            Class<?> clsSup = clas.getSuperclass();
            ArrayList<Field> fieldList = new ArrayList<Field>();
            fieldList.addAll(Arrays.asList(fields));
            List<String> fdNames = this.getFieldNames(fieldList);
            for (Field pfd : Arrays.asList(clsSup.getDeclaredFields())) {
                if (fdNames.contains(pfd.getName())) continue;
                fieldList.add(pfd);
            }
            fields = new Field[fieldList.size()];
            int i = 0;
            for (Object field : fieldList.toArray()) {
                fields[i] = (Field)field;
                ++i;
            }
            fields = this.recursionParents(clsSup, fields);
        }
        return fields;
    }

    private List<String> getFieldNames(List<Field> fieldList) {
        ArrayList<String> fdNames = new ArrayList<String>();
        for (Field fd : fieldList) {
            fdNames.add(fd.getName());
        }
        return fdNames;
    }

    private void createOrModifyTableConstruct(Map<String, Map<String, TableConfig>> baseTableMap) {
        this.createTableByMap(baseTableMap.get("newTableMap"));
        if (!"add".equals(tableAuto)) {
            this.dropFieldsKeyByMap(baseTableMap.get("dropKeyTableMap"));
        }
        if (!"add".equals(tableAuto)) {
            this.dropIndexAndUniqueByMap(baseTableMap.get("dropIndexAndUniqueTableMap"));
            this.removeFieldsByMap(baseTableMap.get("removeTableMap"));
            this.modifyTableCommentByMap(baseTableMap.get("modifyTablePropertyMap"));
            this.modifyFieldsByMap(baseTableMap.get("modifyTableMap"));
        }
        this.addFieldsByMap(baseTableMap.get("addTableMap"));
        this.addIndexByMap(baseTableMap.get("addIndexTableMap"));
        this.addUniqueByMap(baseTableMap.get("addUniqueTableMap"));
    }

    private void dropIndexAndUniqueByMap(Map<String, TableConfig> dropIndexAndUniqueMap) {
        if (dropIndexAndUniqueMap.size() > 0) {
            for (Map.Entry<String, TableConfig> entry : dropIndexAndUniqueMap.entrySet()) {
                for (Object obj : entry.getValue().getList()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(entry.getKey(), obj);
                    log.info("\u5f00\u59cb\u5220\u9664\u8868" + entry.getKey() + "\u4e2d\u7684\u7d22\u5f15" + obj);
                    this.createMysqlTablesMapper.dropTabelIndex(map);
                    log.info("\u5b8c\u6210\u5220\u9664\u8868" + entry.getKey() + "\u4e2d\u7684\u7d22\u5f15" + obj);
                }
            }
        }
    }

    private void addIndexByMap(Map<String, TableConfig> addIndexMap) {
        if (addIndexMap.size() > 0) {
            for (Map.Entry<String, TableConfig> entry : addIndexMap.entrySet()) {
                for (Object obj : entry.getValue().getList()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(entry.getKey(), obj);
                    CreateTableParam fieldProperties = (CreateTableParam)obj;
                    if (null == fieldProperties.getFiledIndexName()) continue;
                    log.info("\u5f00\u59cb\u521b\u5efa\u8868" + entry.getKey() + "\u4e2d\u7684\u7d22\u5f15" + fieldProperties.getFiledIndexName());
                    this.createMysqlTablesMapper.addTableIndex(map);
                    log.info("\u5b8c\u6210\u521b\u5efa\u8868" + entry.getKey() + "\u4e2d\u7684\u7d22\u5f15" + fieldProperties.getFiledIndexName());
                }
            }
        }
    }

    private void addUniqueByMap(Map<String, TableConfig> addUniqueMap) {
        if (addUniqueMap.size() > 0) {
            for (Map.Entry<String, TableConfig> entry : addUniqueMap.entrySet()) {
                for (Object obj : entry.getValue().getList()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(entry.getKey(), obj);
                    CreateTableParam fieldProperties = (CreateTableParam)obj;
                    if (null == fieldProperties.getFiledUniqueName()) continue;
                    log.info("\u5f00\u59cb\u521b\u5efa\u8868" + entry.getKey() + "\u4e2d\u7684\u552f\u4e00\u7ea6\u675f" + fieldProperties.getFiledUniqueName());
                    this.createMysqlTablesMapper.addTableUnique(map);
                    log.info("\u5b8c\u6210\u521b\u5efa\u8868" + entry.getKey() + "\u4e2d\u7684\u552f\u4e00\u7ea6\u675f" + fieldProperties.getFiledUniqueName());
                }
            }
        }
    }

    private void modifyFieldsByMap(Map<String, TableConfig> modifyTableMap) {
        if (modifyTableMap.size() > 0) {
            for (Map.Entry<String, TableConfig> entry : modifyTableMap.entrySet()) {
                for (Object obj : entry.getValue().getList()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(entry.getKey(), obj);
                    CreateTableParam fieldProperties = (CreateTableParam)obj;
                    log.info("\u5f00\u59cb\u4fee\u6539\u8868" + entry.getKey() + "\u4e2d\u7684\u5b57\u6bb5" + fieldProperties.getFieldName());
                    this.createMysqlTablesMapper.modifyTableField(map);
                    log.info("\u5b8c\u6210\u4fee\u6539\u8868" + entry.getKey() + "\u4e2d\u7684\u5b57\u6bb5" + fieldProperties.getFieldName());
                }
            }
        }
    }

    private void removeFieldsByMap(Map<String, TableConfig> removeTableMap) {
        if (removeTableMap.size() > 0) {
            for (Map.Entry<String, TableConfig> entry : removeTableMap.entrySet()) {
                for (Object obj : entry.getValue().getList()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(entry.getKey(), obj);
                    String fieldName = (String)obj;
                    log.info("\u5f00\u59cb\u5220\u9664\u8868" + entry.getKey() + "\u4e2d\u7684\u5b57\u6bb5" + fieldName);
                    this.createMysqlTablesMapper.removeTableField(map);
                    log.info("\u5b8c\u6210\u5220\u9664\u8868" + entry.getKey() + "\u4e2d\u7684\u5b57\u6bb5" + fieldName);
                }
            }
        }
    }

    private void modifyTableCommentByMap(Map<String, TableConfig> modifyTableCommentMap) {
        if (modifyTableCommentMap.size() > 0) {
            for (Map.Entry<String, TableConfig> entry : modifyTableCommentMap.entrySet()) {
                for (String property : entry.getValue().getMap().keySet()) {
                    HashMap<String, TableConfig> map = new HashMap<String, TableConfig>();
                    HashMap<String, Object> tcMap = new HashMap<String, Object>();
                    Object value = entry.getValue().getMap().get(property);
                    tcMap.put(property, value);
                    map.put(entry.getKey(), new TableConfig(tcMap));
                    log.info("\u5f00\u59cb\u66f4\u65b0\u8868" + entry.getKey() + "\u7684" + property + "\u4e3a" + value);
                    this.createMysqlTablesMapper.modifyTableProperty(map);
                    log.info("\u5b8c\u6210\u66f4\u65b0\u8868" + entry.getKey() + "\u7684" + property + "\u4e3a" + value);
                }
            }
        }
    }

    private void addFieldsByMap(Map<String, TableConfig> addTableMap) {
        if (addTableMap.size() > 0) {
            for (Map.Entry<String, TableConfig> entry : addTableMap.entrySet()) {
                for (Object obj : entry.getValue().getList()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(entry.getKey(), obj);
                    CreateTableParam fieldProperties = (CreateTableParam)obj;
                    log.info("\u5f00\u59cb\u4e3a\u8868" + entry.getKey() + "\u589e\u52a0\u5b57\u6bb5" + fieldProperties.getFieldName());
                    this.createMysqlTablesMapper.addTableField(map);
                    log.info("\u5b8c\u6210\u4e3a\u8868" + entry.getKey() + "\u589e\u52a0\u5b57\u6bb5" + fieldProperties.getFieldName());
                }
            }
        }
    }

    private void dropFieldsKeyByMap(Map<String, TableConfig> dropKeyTableMap) {
        if (dropKeyTableMap.size() > 0) {
            for (Map.Entry<String, TableConfig> entry : dropKeyTableMap.entrySet()) {
                for (Object obj : entry.getValue().getList()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(entry.getKey(), obj);
                    CreateTableParam fieldProperties = (CreateTableParam)obj;
                    log.info("\u5f00\u59cb\u4e3a\u8868" + entry.getKey() + "\u5220\u9664\u4e3b\u952e" + fieldProperties.getFieldName());
                    this.createMysqlTablesMapper.dropKeyTableField(map);
                    log.info("\u5b8c\u6210\u4e3a\u8868" + entry.getKey() + "\u5220\u9664\u4e3b\u952e" + fieldProperties.getFieldName());
                }
            }
        }
    }

    private void createTableByMap(Map<String, TableConfig> newTableMap) {
        if (newTableMap.size() > 0) {
            for (Map.Entry<String, TableConfig> entry : newTableMap.entrySet()) {
                HashMap<String, TableConfig> map = new HashMap<String, TableConfig>();
                map.put(entry.getKey(), entry.getValue());
                log.info("\u5f00\u59cb\u521b\u5efa\u8868\uff1a" + entry.getKey());
                this.createMysqlTablesMapper.createTable(map);
                log.info("\u5b8c\u6210\u521b\u5efa\u8868\uff1a" + entry.getKey());
            }
        }
    }
}

