/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.zoo.cv.objectdetection;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Rectangle;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.paddlepaddle.zoo.cv.objectdetection.BoundFinder;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslatorContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PpWordDetectionTranslator
implements NoBatchifyTranslator<Image, DetectedObjects> {
    private final int maxLength;

    public PpWordDetectionTranslator(Map<String, ?> arguments) {
        this.maxLength = ArgumentsUtil.intValue(arguments, (String)"maxLength", (int)960);
    }

    public DetectedObjects processOutput(TranslatorContext ctx, NDList list) {
        List<Object> boxes;
        NDArray result = list.singletonOrThrow();
        ImageFactory factory = ImageFactory.getInstance();
        if ("ai.djl.opencv.OpenCVImageFactory".equals(factory.getClass().getName())) {
            result = result.squeeze(0);
            Image image = factory.fromNDArray(result);
            boxes = image.findBoundingBoxes().parallelStream().filter(box -> {
                Rectangle rect = (Rectangle)box;
                return rect.getWidth() * (double)image.getWidth() > 5.0 || rect.getHeight() * (double)image.getHeight() > 5.0;
            }).collect(Collectors.toList());
        } else {
            result = result.squeeze().mul((Number)Float.valueOf(255.0f)).toType(DataType.UINT8, true).neq((Number)0);
            boolean[] flattened = result.toBooleanArray();
            Shape shape = result.getShape();
            int w = (int)shape.get(0);
            int h = (int)shape.get(1);
            boolean[][] grid = new boolean[w][h];
            IntStream.range(0, flattened.length).parallel().forEach(i -> {
                grid[i / h][i % h] = flattened[i];
            });
            boxes = new BoundFinder(grid).getBoxes();
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Double> probs = new ArrayList<Double>();
        int boxSize = boxes.size();
        for (int i2 = 0; i2 < boxSize; ++i2) {
            names.add("word");
            probs.add(1.0);
        }
        return new DetectedObjects(names, probs, boxes);
    }

    public NDList processInput(TranslatorContext ctx, Image input) {
        NDArray img = input.toNDArray(ctx.getNDManager());
        int h = input.getHeight();
        int w = input.getWidth();
        int[] hw = this.scale(h, w, this.maxLength);
        img = NDImageUtils.resize((NDArray)img, (int)hw[1], (int)hw[0]);
        img = NDImageUtils.toTensor((NDArray)img);
        img = NDImageUtils.normalize((NDArray)img, (float[])new float[]{0.485f, 0.456f, 0.406f}, (float[])new float[]{0.229f, 0.224f, 0.225f});
        img = img.expandDims(0);
        return new NDList(new NDArray[]{img});
    }

    private int[] scale(int h, int w, int max) {
        int localMax = Math.max(h, w);
        float scale = 1.0f;
        if (max < localMax) {
            scale = (float)max * 1.0f / (float)localMax;
        }
        return this.resize32((float)h * scale, (float)w * scale);
    }

    private int[] resize32(double h, double w) {
        double min = Math.min(h, w);
        if (min < 32.0) {
            h = 32.0 / min * h;
            w = 32.0 / min * w;
        }
        int h32 = (int)h / 32;
        int w32 = (int)w / 32;
        return new int[]{h32 * 32, w32 * 32};
    }
}

