/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.jni;

import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.Platform;
import ai.djl.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String NATIVE_LIB_NAME = "paddle_inference";
    private static final String LIB_NAME = "djl_paddle";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+)(-SNAPSHOT)?(-\\d+)?");

    private LibUtils() {
    }

    public static void loadLibrary() {
        String libName = LibUtils.findOverrideLibrary();
        AtomicBoolean fallback = new AtomicBoolean(false);
        if (libName == null && (libName = LibUtils.findLibraryInClasspath(fallback)) == null) {
            throw new IllegalStateException("Native library not found");
        }
        if (System.getProperty("os.name").startsWith("Linux")) {
            LibUtils.loadLinuxDependencies(libName);
        } else if (System.getProperty("os.name").startsWith("Win")) {
            LibUtils.loadWindowsDependencies(libName);
        } else if (System.getProperty("os.name").startsWith("Mac")) {
            LibUtils.loadMacOsDependencies(libName);
        }
        logger.debug("Now loading " + libName);
        System.load(libName);
        Path nativeLibDir = Paths.get(libName, new String[0]).getParent();
        if (nativeLibDir == null || !nativeLibDir.toFile().isDirectory()) {
            throw new IllegalStateException("Native folder cannot be found");
        }
        libName = LibUtils.copyJniLibraryFromClasspath(nativeLibDir);
        logger.debug("Loading paddle library from: {}", (Object)libName);
        System.load(libName);
    }

    public static void loadLinuxDependencies(String libName) {
        Path libDir = Paths.get(libName, new String[0]).getParent();
        if (libDir != null) {
            logger.info("Paddle MKL/GPU requires user to set LD_LIBRARY_PATH=" + libDir + ", the current one is set to: " + Utils.getenv((String)"LD_LIBRARY_PATH"));
            List<String> names = Arrays.asList("libdnnl.so.2", "libiomp5.so", "libmklml_intel.so", "libonnxruntime.so", "libpaddle2onnx.so");
            names.forEach(name -> {
                Path path = libDir.resolve((String)name);
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    String lib = path.toAbsolutePath().toString();
                    logger.debug("Now loading " + lib);
                    System.load(lib);
                } else {
                    logger.debug(name + " is not found, skip loading...");
                }
            });
        }
    }

    public static void loadWindowsDependencies(String libName) {
        Path libDir = Paths.get(libName, new String[0]).getParent();
        List<String> names = Arrays.asList("openblas.dll", "mkldnn.dll", "onnxruntime.dll", "paddle2onnx.dll");
        names.forEach(name -> {
            Path path = libDir.resolve((String)name);
            if (Files.isRegularFile(path, new LinkOption[0])) {
                String lib = path.toAbsolutePath().toString();
                logger.debug("Now loading " + lib);
                System.load(lib);
            } else {
                logger.debug(name + " is not found, skip loading...");
            }
        });
    }

    public static void loadMacOsDependencies(String libName) {
        Path libDir = Paths.get(libName, new String[0]).getParent();
        List<String> names = Arrays.asList("libonnxruntime.dylib", "libpaddle2onnx.dylib");
        names.forEach(name -> {
            Path path = libDir.resolve((String)name);
            if (Files.isRegularFile(path, new LinkOption[0])) {
                String lib = path.toAbsolutePath().toString();
                logger.debug("Now loading " + lib);
                System.load(lib);
            } else {
                logger.debug(name + " is not found, skip loading...");
            }
        });
    }

    private static String findOverrideLibrary() {
        String libName;
        String libPath = Utils.getEnvOrSystemProperty((String)"PADDLE_LIBRARY_PATH");
        if (libPath != null && (libName = LibUtils.findLibraryInPath(libPath)) != null) {
            return libName;
        }
        libPath = System.getProperty("java.library.path");
        if (libPath != null) {
            return LibUtils.findLibraryInPath(libPath);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private static String copyJniLibraryFromClasspath(Path nativeDir) {
        String string;
        InputStream is;
        Path tmp;
        block13: {
            block12: {
                String name = System.mapLibraryName(LIB_NAME);
                Platform platform = Platform.detectPlatform((String)"paddlepaddle");
                String classifier = platform.getClassifier();
                String djlVersion = platform.getApiVersion();
                Path path = nativeDir.resolve(djlVersion + '-' + name);
                if (Files.exists(path, new LinkOption[0])) {
                    return path.toAbsolutePath().toString();
                }
                tmp = null;
                String libPath = "jnilib/" + classifier + "/cpu/" + name;
                is = ClassLoaderUtils.getResourceAsStream((String)libPath);
                logger.info("Extracting {} to cache ...", (Object)libPath);
                tmp = Files.createTempFile(nativeDir, "jni", "tmp", new FileAttribute[0]);
                Files.copy(is, tmp, StandardCopyOption.REPLACE_EXISTING);
                Utils.moveQuietly((Path)tmp, (Path)path);
                string = path.toAbsolutePath().toString();
                if (is == null) break block12;
                is.close();
            }
            if (tmp == null) break block13;
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot copy jni files", e);
                    }
                }
                catch (Throwable throwable3) {
                    if (tmp != null) {
                        Utils.deleteQuietly(tmp);
                    }
                    throw throwable3;
                }
            }
        }
    }

    private static synchronized String findLibraryInClasspath(AtomicBoolean fallback) {
        Platform platform = Platform.detectPlatform((String)"paddlepaddle");
        if (platform.isPlaceholder()) {
            return LibUtils.downloadLibrary(platform, fallback);
        }
        String flavor = platform.getFlavor();
        if ("cpu".equals(flavor)) {
            fallback.set(true);
        }
        return LibUtils.loadLibraryFromClasspath(platform);
    }

    private static String loadLibraryFromClasspath(Platform platform) {
        String string;
        block21: {
            Path tmp = null;
            try {
                String libName = System.mapLibraryName(NATIVE_LIB_NAME);
                Path cacheFolder = Utils.getEngineCacheDir((String)"paddle");
                String version = platform.getVersion();
                String flavor = platform.getFlavor();
                String classifier = platform.getClassifier();
                Path dir = cacheFolder.resolve(version + '-' + flavor + '-' + classifier);
                logger.debug("Using cache dir: {}", (Object)dir);
                Path path = dir.resolve(libName);
                if (Files.exists(path, new LinkOption[0])) {
                    String string2 = path.toAbsolutePath().toString();
                    return string2;
                }
                Files.createDirectories(cacheFolder, new FileAttribute[0]);
                tmp = Files.createTempDirectory(cacheFolder, "tmp", new FileAttribute[0]);
                for (String file : platform.getLibraries()) {
                    String libPath = "native/lib/" + file;
                    logger.info("Extracting {} to cache ...", (Object)file);
                    if (file.endsWith(".gz")) {
                        String f = file.substring(0, file.length() - 3);
                        try (GZIPInputStream is = new GZIPInputStream(ClassLoaderUtils.getResourceAsStream((String)libPath));){
                            Files.copy(is, tmp.resolve(f), StandardCopyOption.REPLACE_EXISTING);
                            continue;
                        }
                    }
                    try (InputStream is = ClassLoaderUtils.getResourceAsStream((String)libPath);){
                        Files.copy(is, tmp.resolve(file), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                string = path.toAbsolutePath().toString();
                if (tmp == null) break block21;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to extract PaddlePaddle native library", e);
            }
            finally {
                if (tmp != null) {
                    Utils.deleteQuietly(tmp);
                }
            }
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
    }

    private static String findLibraryInPath(String libPath) {
        String[] paths = libPath.split(File.pathSeparator);
        String mappedLibNames = System.mapLibraryName(NATIVE_LIB_NAME);
        for (String path : paths) {
            File p = new File(path);
            if (!p.exists()) continue;
            if (p.isFile() && p.getName().endsWith(mappedLibNames)) {
                return p.getAbsolutePath();
            }
            File file = new File(path, mappedLibNames);
            if (!file.exists() || !file.isFile()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static String downloadLibrary(Platform platform, AtomicBoolean fallback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

