/*
 * Decompiled with CFR 0.152.
 */
package net.wsttech.gm.sm4;

import net.wsttech.gm.sm4.SM4Process;

public class SM4 {
    public static byte[] ECBEncrypt(byte[] plaintext, byte[] key, String pkcs) {
        if (key.length != 16) {
            throw new RuntimeException("Key Error!");
        }
        long[] rk = new long[32];
        SM4Process.sm4SetKey(rk, key);
        byte[] cipherText = SM4Process.sm4ECBCrypt(rk, plaintext, true, pkcs);
        return cipherText;
    }

    public static byte[] ECBDecrypt(byte[] cipherText, byte[] key) {
        if (cipherText.length % 16 != 0) {
            throw new RuntimeException("\u975e\u6cd5\u53c2\u6570");
        }
        if (key.length != 16) {
            throw new RuntimeException("Key Error!");
        }
        long[] rk = new long[32];
        SM4Process.sm4SetKey(rk, key);
        for (int i = 0; i < 16; ++i) {
            SM4Process.SWAP(rk, i);
        }
        byte[] plainText = SM4Process.sm4ECBCrypt(rk, cipherText, false, null);
        return plainText;
    }

    public static byte[] CBCEncrypt(byte[] plaintext, byte[] key, byte[] iv, String pkcs) {
        if (iv == null || iv.length != 16) {
            throw new RuntimeException("IV Error!");
        }
        if (key.length != 16) {
            throw new RuntimeException("Key Error!");
        }
        long[] rk = new long[32];
        SM4Process.sm4SetKey(rk, key);
        byte[] cipherText = SM4Process.sm4CBCCrypt(rk, iv, plaintext, true, pkcs);
        return cipherText;
    }

    public static byte[] CBCDecrypt(byte[] cipherText, byte[] key, byte[] iv) {
        if (cipherText.length % 16 != 0) {
            throw new RuntimeException("\u975e\u6cd5\u53c2\u6570");
        }
        if (key.length != 16) {
            throw new RuntimeException("Key Error!");
        }
        if (iv == null || iv.length != 16) {
            throw new RuntimeException("IV Error!");
        }
        long[] rk = new long[32];
        SM4Process.sm4SetKey(rk, key);
        for (int i = 0; i < 16; ++i) {
            SM4Process.SWAP(rk, i);
        }
        byte[] plainText = SM4Process.sm4CBCCrypt(rk, iv, cipherText, false, null);
        return plainText;
    }
}

