/*
 * Decompiled with CFR 0.152.
 */
package net.wsttech.gm.sm3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.wsttech.gm.sm3.SM3Params;
import net.wsttech.gm.utils.LongUtils;

public class SM3Process {
    public static final String DATA_INVALID = "\u975e\u6cd5\u53c2\u6570";

    public static byte[] padding(byte[] data) {
        long l = data.length * 8;
        long k = (448L - (l + 1L) % 512L + 512L) % 512L;
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        try {
            res.write(data);
            res.write(SM3Params.FIRST_PADDING);
            for (long i = k - 7L; i > 0L; i -= 8L) {
                res.write(SM3Params.ZERO_PADDING);
            }
            res.write(LongUtils.longToBytes(l));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res.toByteArray();
    }

    public static Integer FF(Integer x, Integer y, Integer z, int j) {
        if (j >= 0 && j <= 15) {
            return x ^ y ^ z;
        }
        if (j >= 16 && j <= 63) {
            return x & y | x & z | y & z;
        }
        throw new RuntimeException(DATA_INVALID);
    }

    public static Integer GG(Integer x, Integer y, Integer z, int j) {
        if (j >= 0 && j <= 15) {
            return x ^ y ^ z;
        }
        if (j >= 16 && j <= 63) {
            return x & y | ~x.intValue() & z;
        }
        throw new RuntimeException(DATA_INVALID);
    }

    public static Integer P0(Integer x) {
        return x ^ Integer.rotateLeft(x, 9) ^ Integer.rotateLeft(x, 17);
    }

    private static Integer P1(Integer x) {
        return x ^ Integer.rotateLeft(x, 15) ^ Integer.rotateLeft(x, 23);
    }

    public static byte[] CF(byte[] vi, byte[] bi) {
        int j;
        int a = SM3Process.toInteger(vi, 0);
        int b = SM3Process.toInteger(vi, 1);
        int c = SM3Process.toInteger(vi, 2);
        int d = SM3Process.toInteger(vi, 3);
        int e = SM3Process.toInteger(vi, 4);
        int f = SM3Process.toInteger(vi, 5);
        int g = SM3Process.toInteger(vi, 6);
        int h = SM3Process.toInteger(vi, 7);
        int[] w = new int[68];
        int[] w1 = new int[64];
        for (int i = 0; i < 16; ++i) {
            w[i] = SM3Process.toInteger(bi, i);
        }
        for (j = 16; j < 68; ++j) {
            w[j] = SM3Process.P1(w[j - 16] ^ w[j - 9] ^ Integer.rotateLeft(w[j - 3], 15)) ^ Integer.rotateLeft(w[j - 13], 7) ^ w[j - 6];
        }
        for (j = 0; j < 64; ++j) {
            w1[j] = w[j] ^ w[j + 4];
        }
        for (int j2 = 0; j2 < 64; ++j2) {
            int ss1 = Integer.rotateLeft(Integer.rotateLeft(a, 12) + e + Integer.rotateLeft(SM3Process.T(j2), j2 % 32), 7);
            int ss2 = ss1 ^ Integer.rotateLeft(a, 12);
            int tt1 = SM3Process.FF(a, b, c, j2) + d + ss2 + w1[j2];
            int tt2 = SM3Process.GG(e, f, g, j2) + h + ss1 + w[j2];
            d = c;
            c = Integer.rotateLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = Integer.rotateLeft(f, 19);
            f = e;
            e = SM3Process.P0(tt2);
        }
        byte[] v = SM3Process.toByteArray(a, b, c, d, e, f, g, h);
        for (int i = 0; i < v.length; ++i) {
            v[i] = (byte)(v[i] ^ vi[i]);
        }
        return v;
    }

    private static int T(int j) {
        if (j >= 0 && j <= 15) {
            return SM3Params.Tj015.intValue();
        }
        if (j >= 16 && j <= 63) {
            return SM3Params.Tj1663.intValue();
        }
        throw new RuntimeException(DATA_INVALID);
    }

    private static byte[] padding64BitLen(long l) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(l >>> (7 - i) * 8);
        }
        return bytes;
    }

    private static int toInteger(byte[] source, int index) {
        StringBuilder valueStr = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            valueStr.append(SM3Params.hexDigits[(byte)((source[index * 4 + i] & 0xF0) >> 4)]);
            valueStr.append(SM3Params.hexDigits[(byte)(source[index * 4 + i] & 0xF)]);
        }
        return Long.valueOf(valueStr.toString(), 16).intValue();
    }

    private static byte[] toByteArray(int a, int b, int c, int d, int e, int f, int g, int h) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32);
        try {
            baos.write(SM3Process.toByteArray(a));
            baos.write(SM3Process.toByteArray(b));
            baos.write(SM3Process.toByteArray(c));
            baos.write(SM3Process.toByteArray(d));
            baos.write(SM3Process.toByteArray(e));
            baos.write(SM3Process.toByteArray(f));
            baos.write(SM3Process.toByteArray(g));
            baos.write(SM3Process.toByteArray(h));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return baos.toByteArray();
    }

    private static byte[] toByteArray(int i) {
        byte[] bytes = new byte[]{(byte)(i >>> 24), (byte)((i & 0xFFFFFF) >>> 16), (byte)((i & 0xFFFF) >>> 8), (byte)(i & 0xFF)};
        return bytes;
    }
}

