/*
 * Decompiled with CFR 0.152.
 */
package net.wsttech.gm.sm3;

import net.wsttech.gm.sm3.SM3;
import net.wsttech.gm.utils.ByteUtils;

public final class HMASM3CProcess {
    private static final int BLOCK_SIZE = 64;
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;

    private static byte[] getBlockSizeKey(byte[] key) {
        if (key.length > 64) {
            return SM3.hash(key);
        }
        byte[] hmacKey = new byte[64];
        System.arraycopy(key, 0, hmacKey, 0, key.length);
        return hmacKey;
    }

    private static byte[] calculateIpadKey(byte[] hmacKey) {
        byte[] IpadKey = new byte[hmacKey.length];
        for (int i = 0; i < hmacKey.length; ++i) {
            IpadKey[i] = (byte)(hmacKey[i] ^ 0x36);
        }
        return IpadKey;
    }

    private static byte[] getMiddleHash(byte[] ipadKey, byte[] message) {
        return SM3.hash(ByteUtils.mergeBytes(ipadKey, message));
    }

    private static byte[] calculateOpadKey(byte[] hmacKey) {
        byte[] OpadKey = new byte[hmacKey.length];
        for (int i = 0; i < hmacKey.length; ++i) {
            OpadKey[i] = (byte)(hmacKey[i] ^ 0x5C);
        }
        return OpadKey;
    }

    private static byte[] calculateHmac(byte[] opadKey, byte[] middleHash) {
        return SM3.hash(ByteUtils.mergeBytes(opadKey, middleHash));
    }

    public static byte[] hmacInit(byte[] key) {
        byte[] hmacKey = HMASM3CProcess.getBlockSizeKey(key);
        return hmacKey;
    }

    public static byte[] hmacUpdate(byte[] hmacKey, byte[] src) {
        byte[] ipadKey = HMASM3CProcess.calculateIpadKey(hmacKey);
        byte[] middleHash = HMASM3CProcess.getMiddleHash(ipadKey, src);
        return middleHash;
    }

    public static byte[] hmacFinal(byte[] hmacKey, byte[] middleHash) {
        byte[] opadKey = HMASM3CProcess.calculateOpadKey(hmacKey);
        return HMASM3CProcess.calculateHmac(opadKey, middleHash);
    }
}

