/*
 * Decompiled with CFR 0.152.
 */
package net.wsttech.gm.sm2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import net.wsttech.gm.sm2.dto.SM2Cer;
import net.wsttech.gm.sm2.dto.SM2KeyPair;
import net.wsttech.gm.utils.ByteUtils;
import net.wsttech.gm.utils.HexUtils;
import net.wsttech.gm.utils.SM2SignASN1Utils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.X509KeyUsage;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class SM2 {
    private static X9ECParameters x9ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
    private static ECParameterSpec ecParameterSpec = new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
    private static final SM2Engine.Mode MODE = SM2Engine.Mode.C1C3C2;
    private static final SM2Engine.Mode MODE_OLD = SM2Engine.Mode.C1C2C3;

    public static SM2KeyPair getKeyPair(KeyPair keyPair) {
        SM2KeyPair sm2KeyPair = new SM2KeyPair();
        if (keyPair == null) {
            keyPair = SM2.generateKeyPair();
        }
        sm2KeyPair.setKeyPair(keyPair);
        return sm2KeyPair;
    }

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator kpGen = KeyPairGenerator.getInstance("EC", "BC");
            kpGen.initialize((AlgorithmParameterSpec)ecParameterSpec, new SecureRandom());
            KeyPair kp = kpGen.generateKeyPair();
            return kp;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encrypt(byte[] data, PublicKey publicKey, String mode) {
        BCECPublicKey key = (BCECPublicKey)publicKey;
        ECParameterSpec ecParameterSpec = key.getParameters();
        ECDomainParameters ecDomainParameters = new ECDomainParameters(ecParameterSpec.getCurve(), ecParameterSpec.getG(), ecParameterSpec.getN());
        ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(key.getQ(), ecDomainParameters);
        SM2Engine sm2Engine = mode.equals("c1c2c3") ? new SM2Engine(MODE_OLD) : new SM2Engine(MODE);
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)ecPublicKeyParameters, new SecureRandom()));
        try {
            return ByteUtils.subBytes(sm2Engine.processBlock(data, 0, data.length), 1);
        }
        catch (InvalidCipherTextException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static byte[] encrypt(byte[] data, String publicKey, String mode) {
        if (publicKey.length() != 128) {
            throw new RuntimeException("public key length error...");
        }
        BCECPublicKey key = SM2.getPublicKeyObj(publicKey);
        return SM2.encrypt(data, (PublicKey)key, mode);
    }

    private static BCECPublicKey getPublicKeyFromXY(BigInteger x, BigInteger y) {
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(x9ECParameters.getCurve().createPoint(x, y), ecParameterSpec);
        return new BCECPublicKey("EC", ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static byte[] decrypt(byte[] data, PrivateKey privateKey, String mode) {
        BCECPrivateKey key = (BCECPrivateKey)privateKey;
        ECParameterSpec ecParameterSpec = key.getParameters();
        ECDomainParameters ecDomainParameters = new ECDomainParameters(ecParameterSpec.getCurve(), ecParameterSpec.getG(), ecParameterSpec.getN());
        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(key.getD(), ecDomainParameters);
        SM2Engine sm2Engine = mode.equals("c1c2c3") ? new SM2Engine(MODE_OLD) : new SM2Engine(MODE);
        sm2Engine.init(false, (CipherParameters)ecPrivateKeyParameters);
        try {
            return sm2Engine.processBlock(ByteUtils.mergeBytes(HexUtils.hexStringToBytes("04"), data), 0, data.length + 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] decrypt(byte[] data, String privateKey, String mode) {
        BigInteger d = new BigInteger(privateKey, 16);
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(d, ecParameterSpec);
        BCECPrivateKey key = new BCECPrivateKey("EC", ecPrivateKeySpec, BouncyCastleProvider.CONFIGURATION);
        return SM2.decrypt(data, (PrivateKey)key, mode);
    }

    public static byte[] sign(byte[] msg, byte[] userId, PrivateKey privateKey) {
        SM2Signer signer = new SM2Signer((DSAEncoding)StandardDSAEncoding.INSTANCE, (Digest)new SM3Digest());
        ParametersWithRandom param = null;
        try {
            param = new ParametersWithRandom((CipherParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        ParametersWithID parametersWithID = new ParametersWithID((CipherParameters)param, userId);
        signer.init(true, (CipherParameters)parametersWithID);
        signer.update(msg, 0, msg.length);
        try {
            return signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] signToRS(byte[] data, byte[] userId, String privateKey) {
        byte[] resultS;
        byte[] resultR;
        byte[] signResultBytes = SM2.sign(data, userId, privateKey);
        StandardDSAEncoding standardDSAEncoding = new StandardDSAEncoding();
        ParametersWithRandom param = null;
        try {
            param = new ParametersWithRandom((CipherParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)SM2.getPrivateKeyObj(privateKey)));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        BigInteger[] decode = null;
        try {
            decode = standardDSAEncoding.decode(((ECKeyParameters)param.getParameters()).getParameters().getN(), signResultBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] sumR = decode[0].toByteArray();
        if (sumR[0] == 0 && sumR.length == 33) {
            resultR = new byte[32];
            System.arraycopy(sumR, 1, resultR, 0, 32);
        } else {
            resultR = sumR;
        }
        byte[] sumS = decode[1].toByteArray();
        if (sumS[0] == 0 && sumS.length == 33) {
            resultS = new byte[32];
            System.arraycopy(sumS, 1, resultS, 0, 32);
        } else {
            resultS = sumS;
        }
        return ByteUtils.mergeBytes(resultR, resultS);
    }

    public static byte[] signWithOutASN1(byte[] msg, byte[] userId, PrivateKey privateKey) throws InvalidKeyException, CryptoException {
        return HexUtils.hexStringToBytes(SM2SignASN1Utils.parseSm2SignAsn1Object(SM2.sign(msg, userId, privateKey)));
    }

    public static byte[] sign(byte[] msg, byte[] userId, String privateKey) {
        BCECPrivateKey key = SM2.getPrivateKeyObj(privateKey);
        return SM2.sign(msg, userId, (PrivateKey)key);
    }

    public static byte[] signWithOutASN1(byte[] msg, byte[] userId, String privateKey) throws InvalidKeyException, CryptoException {
        BCECPrivateKey key = SM2.getPrivateKeyObj(privateKey);
        return HexUtils.hexStringToBytes(SM2SignASN1Utils.parseSm2SignAsn1Object(SM2.sign(msg, userId, (PrivateKey)key)));
    }

    public static boolean verify(byte[] msg, byte[] userId, byte[] sign, PublicKey publicKey) {
        SM2Signer signer = new SM2Signer((DSAEncoding)StandardDSAEncoding.INSTANCE, (Digest)new SM3Digest());
        ParametersWithID parametersWithID = null;
        try {
            parametersWithID = new ParametersWithID((CipherParameters)ECUtil.generatePublicKeyParameter((PublicKey)publicKey), userId);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        signer.init(false, (CipherParameters)parametersWithID);
        signer.update(msg, 0, msg.length);
        return signer.verifySignature(sign);
    }

    public static boolean verify(byte[] plainText, byte[] userId, byte[] sign, String publicKey) {
        BCECPublicKey key = SM2.getPublicKeyObj(publicKey);
        return SM2.verify(plainText, userId, sign, (PublicKey)key);
    }

    public static boolean verifyByRS(byte[] data, byte[] userId, byte[] sign, String publicKey) {
        StandardDSAEncoding standardDSAEncoding = new StandardDSAEncoding();
        ECKeyParameters ecKeyParameters = null;
        try {
            ecKeyParameters = (ECKeyParameters)ECUtil.generatePublicKeyParameter((PublicKey)SM2.getPublicKeyObj(publicKey));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        byte[] R = new byte[32];
        byte[] S = new byte[32];
        System.arraycopy(sign, 0, R, 0, 32);
        System.arraycopy(sign, 32, S, 0, 32);
        byte[] encode = null;
        try {
            encode = standardDSAEncoding.encode(ecKeyParameters.getParameters().getN(), SM2.byteConvertInteger(R), SM2.byteConvertInteger(S));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return SM2.verify(data, userId, encode, publicKey);
    }

    public static BigInteger byteConvertInteger(byte[] b) {
        if (b[0] < 0) {
            byte[] temp = new byte[b.length + 1];
            temp[0] = 0;
            System.arraycopy(b, 0, temp, 1, b.length);
            return new BigInteger(temp);
        }
        return new BigInteger(b);
    }

    public static byte[] generateSM2Cer(PublicKey publicKey, PrivateKey privateKey, SM2Cer sm2Cer) {
        try {
            X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
            builder.addRDN(BCStyle.CN, sm2Cer.getCountry());
            builder.addRDN(BCStyle.O, sm2Cer.getOrganization());
            builder.addRDN(BCStyle.ST, sm2Cer.getProvince());
            builder.addRDN(BCStyle.L, sm2Cer.getArea());
            builder.addRDN(BCStyle.T, sm2Cer.getTitle());
            X509v3CertificateBuilder cerBuilder = new JcaX509v3CertificateBuilder(builder.build(), BigInteger.valueOf(sm2Cer.getSN().hashCode()), new Date(), sm2Cer.getExpires(), builder.build(), publicKey).addExtension(Extension.keyUsage, false, (ASN1Encodable)new X509KeyUsage(192)).addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
            ContentSigner signer = new JcaContentSignerBuilder("SM3WITHSM2").setProvider((Provider)new BouncyCastleProvider()).build(privateKey);
            X509Certificate cer = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(cerBuilder.build(signer));
            return cer.getEncoded();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static byte[] generateSM2Cer(String publicKey, String privateKey, SM2Cer sm2Cer) {
        BCECPublicKey publicKeyObj = SM2.getPublicKeyObj(publicKey);
        BCECPrivateKey privateKeyObj = SM2.getPrivateKeyObj(privateKey);
        return SM2.generateSM2Cer((PublicKey)publicKeyObj, (PrivateKey)privateKeyObj, sm2Cer);
    }

    public static PublicKey readSM2Cer(byte[] cert) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate cer = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert));
            long current = System.currentTimeMillis();
            if (cer.getNotBefore().getTime() < current && cer.getNotAfter().getTime() > current) {
                return cer.getPublicKey();
            }
            throw new RuntimeException("the certificate is invalid...");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static BCECPublicKey getPublicKeyObj(String publicKey) {
        if (publicKey.length() != 128) {
            throw new RuntimeException("private key length error....");
        }
        return SM2.getPublicKeyFromXY(new BigInteger(publicKey.substring(0, 64), 16), new BigInteger(publicKey.substring(64), 16));
    }

    private static BCECPrivateKey getPrivateKeyObj(String privateKey) {
        if (privateKey.length() != 64) {
            throw new RuntimeException("private key length error....");
        }
        BigInteger d = new BigInteger(privateKey, 16);
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(d, ecParameterSpec);
        return new BCECPrivateKey("EC", ecPrivateKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static void main(String[] args) {
        SM2KeyPair keyPair = SM2.getKeyPair(null);
        String publicKeyValue = keyPair.getPublicKeyValue();
        String privateKeyValue = keyPair.getPrivateKeyValue();
        byte[] data = "a52u312".getBytes();
        byte[] c1c3c2s = SM2.encrypt(data, publicKeyValue, "c1c3c2");
        System.out.println(ByteUtils.byteToHexString(c1c3c2s));
        byte[] decrypt = SM2.decrypt(c1c3c2s, privateKeyValue, "c1c3c2");
        System.out.println(new String(decrypt));
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            Security.removeProvider("BC");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

