/*
 * Decompiled with CFR 0.152.
 */
package cn.zjquantum.cm.sdk.client;

import cn.zjquantum.cm.sdk.common.DataTypeEnum;
import cn.zjquantum.cm.sdk.exception.CMEnum;
import cn.zjquantum.cm.sdk.request.auth.GetTokenRequest;
import cn.zjquantum.cm.sdk.request.sm2.SM2DecryptRequest;
import cn.zjquantum.cm.sdk.request.sm2.SM2EncryptRequest;
import cn.zjquantum.cm.sdk.request.sm2.SM2KeyGenerateByKeyIdsRequest;
import cn.zjquantum.cm.sdk.request.sm2.SM2KeyGenerateByNumberRequest;
import cn.zjquantum.cm.sdk.request.sm2.SM2SignRequest;
import cn.zjquantum.cm.sdk.request.sm2.SM2VerifyRequest;
import cn.zjquantum.cm.sdk.request.sm3.SM3HashRequest;
import cn.zjquantum.cm.sdk.request.sm4.SM4DecryptRequest;
import cn.zjquantum.cm.sdk.request.sm4.SM4EncryptRequest;
import cn.zjquantum.cm.sdk.request.sm4.SM4GetKeyByKeyIdRequest;
import cn.zjquantum.cm.sdk.request.sm4.SM4KeyGetKeyByNumberRequest;
import cn.zjquantum.cm.sdk.response.SM2DecRes;
import cn.zjquantum.cm.sdk.response.SM2EncRes;
import cn.zjquantum.cm.sdk.response.SM2GenerateKeyResponse;
import cn.zjquantum.cm.sdk.response.SM2KeyPairResponse;
import cn.zjquantum.cm.sdk.response.SM2SignRes;
import cn.zjquantum.cm.sdk.response.SM2VerifySignRes;
import cn.zjquantum.cm.sdk.response.SM3HashRes;
import cn.zjquantum.cm.sdk.response.SM4DecRes;
import cn.zjquantum.cm.sdk.response.SM4EncRes;
import cn.zjquantum.cm.sdk.response.SM4Key;
import cn.zjquantum.cm.sdk.response.SM4KeyResponse;
import cn.zjquantum.cm.sdk.util.DataEncodeHandle;
import cn.zjquantum.cm.sdk.util.HttpUtil;
import cn.zjquantum.cm.sdk.util.JsonObjectUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Random;
import net.wsttech.gm.sm2.SM2;
import net.wsttech.gm.sm3.SM3;
import net.wsttech.gm.sm4.SM4;
import net.wsttech.gm.utils.ByteUtils;
import net.wsttech.gm.utils.HexUtils;

public class CMClient {
    private String ip;
    private String port = "80";
    private String prefix;
    private String clientId;
    private String clientSecret;
    private String pubKey;
    private String priKey;
    private String sessionKey = null;
    private String token = "";

    public CMClient(String ip, String port, String prefix, String clientId, String clientSecret, String pubKey, String priKey) {
        this.ip = ip;
        this.port = port;
        this.prefix = prefix;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.pubKey = pubKey;
        this.priKey = priKey;
    }

    public CMClient(String clientId, String clientSecret, String pubKey, String priKey) {
        this.ip = "api.zjquantum.cn";
        this.prefix = "/sdk/cm/v1";
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.pubKey = pubKey;
        this.priKey = priKey;
    }

    public CMClient() {
    }

    private String getUrl() {
        StringBuffer url = new StringBuffer();
        url.append("http://").append(this.ip).append(":").append(this.port);
        if (this.prefix != null && this.prefix != "") {
            if (!this.prefix.startsWith("/")) {
                url.append("/");
            }
            if (this.prefix.endsWith("/")) {
                this.prefix = this.prefix.substring(0, this.prefix.length() - 1);
            }
        }
        return url.append(this.prefix).toString();
    }

    public void getToken() {
        byte[] raByte = new byte[16];
        new Random().nextBytes(raByte);
        String raHex = ByteUtils.byteToHexString((byte[])raByte);
        byte[] raEncByte = SM2.encrypt((byte[])raByte, (String)"1FC6A3C876FC1EFA2129669AE05B762E061166981E5AEB9C21D0D26E77D1A8E494E086A47D2A769236C5B47265CE52B45BC203F3EEE207FD881243C577033DA6", (String)"c1c3c2");
        String raEncByteHex = ByteUtils.byteToHexString((byte[])raEncByte);
        String sm3PlainText = this.clientSecret + raHex;
        byte[] hash = SM3.hash((byte[])sm3PlainText.getBytes());
        GetTokenRequest getTokenRequest = new GetTokenRequest();
        getTokenRequest.setClientId(this.clientId);
        getTokenRequest.setRa(raEncByteHex);
        getTokenRequest.setClientSecret(ByteUtils.byteToHexString((byte[])hash));
        String responseStr = null;
        try {
            responseStr = HttpUtil.post(this.getUrl() + "/auth/getToken", JsonObjectUtil.object2JsonObject(getTokenRequest));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject response = JSON.parseObject((String)responseStr);
        if (response.getInteger("code") != 0) {
            throw new RuntimeException(CMEnum.LOGIN_FAIL.getMessage());
        }
        JSONObject data = response.getJSONObject("data");
        String rb = data.getString("rb");
        String token = data.getString("token");
        byte[] rbDecByte = SM2.decrypt((byte[])HexUtils.hexStringToBytes((String)rb), (String)this.priKey, (String)"c1c3c2");
        String rbDecStr = ByteUtils.byteToHexString((byte[])rbDecByte);
        BigInteger bigInt1 = new BigInteger(raHex, 16);
        BigInteger bigInt2 = new BigInteger(rbDecStr, 16);
        BigInteger xorResult = bigInt1.xor(bigInt2);
        String sessionKey = xorResult.toString(16).toUpperCase();
        StringBuilder sessionKeyStr = new StringBuilder();
        int size = 32 - sessionKey.length();
        for (int i = 0; i < size; ++i) {
            sessionKeyStr.append("0");
        }
        sessionKeyStr.append(sessionKey);
        this.token = token;
        this.sessionKey = sessionKeyStr.toString();
    }

    public SM2SignRes sm2Sign(SM2SignRequest sm2SignRequest) {
        if (!DataTypeEnum.HEX.getType().equalsIgnoreCase(sm2SignRequest.getResEncode()) && !DataTypeEnum.BASE64.getType().equalsIgnoreCase(sm2SignRequest.getResEncode())) {
            return SM2SignRes.fail(CMEnum.SIGN_RES_ENCODE_ERROR);
        }
        JsonObject requestParams = JsonObjectUtil.object2JsonObject(sm2SignRequest);
        String s = null;
        try {
            s = HttpUtil.postWithToken(this.getUrl() + "/sm2/sign", requestParams, this.token);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject response = JSON.parseObject((String)s);
        Integer code = response.getInteger("code");
        String msg = response.getString("msg");
        if (response.getInteger("code") != 0) {
            return SM2SignRes.fail(code, msg);
        }
        JSONObject data = response.getJSONObject("data");
        String signResult = data.getString("signResult");
        String resEncodeRes = data.getString("resEncode");
        return SM2SignRes.ok(resEncodeRes, signResult);
    }

    public SM2VerifySignRes sm2VerifySign(SM2VerifyRequest sm2VerifyRequest) {
        JsonObject requestParams = JsonObjectUtil.object2JsonObject(sm2VerifyRequest);
        String s = null;
        try {
            s = HttpUtil.postWithToken(this.getUrl() + "/sm2/verify", requestParams, this.token);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject response = JSON.parseObject((String)s);
        Integer code = response.getInteger("code");
        String msg = response.getString("msg");
        if (response.getInteger("code") != 0) {
            return SM2VerifySignRes.fail(code, msg);
        }
        JSONObject data = response.getJSONObject("data");
        Boolean verifyResult = data.getBoolean("verifyResult");
        return SM2VerifySignRes.ok(verifyResult);
    }

    public SM2EncRes sm2EncData(SM2EncryptRequest sm2EncryptRequest) {
        if (!DataTypeEnum.HEX.getType().equalsIgnoreCase(sm2EncryptRequest.getResEncode()) && !DataTypeEnum.BASE64.getType().equalsIgnoreCase(sm2EncryptRequest.getResEncode())) {
            return SM2EncRes.fail(CMEnum.SM2_ENC_RES_ENCODE_ERROR);
        }
        JsonObject requestParams = JsonObjectUtil.object2JsonObject(sm2EncryptRequest);
        String s = null;
        try {
            s = HttpUtil.postWithToken(this.getUrl() + "/sm2/encrypt", requestParams, this.token);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject response = JSON.parseObject((String)s);
        Integer code = response.getInteger("code");
        String msg = response.getString("msg");
        if (response.getInteger("code") != 0) {
            return SM2EncRes.fail(code, msg);
        }
        JSONObject data = response.getJSONObject("data");
        String resEncodeRes = data.getString("resEncode");
        String ciphertext = data.getString("ciphertext");
        return SM2EncRes.ok(resEncodeRes, ciphertext);
    }

    public SM2DecRes sm2DecData(SM2DecryptRequest sm2DecryptRequest) {
        JsonObject requestParams = JsonObjectUtil.object2JsonObject(sm2DecryptRequest);
        String s = null;
        try {
            s = HttpUtil.postWithToken(this.getUrl() + "/sm2/decrypt", requestParams, this.token);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject response = JSON.parseObject((String)s);
        Integer code = response.getInteger("code");
        String msg = response.getString("msg");
        if (response.getInteger("code") != 0) {
            return SM2DecRes.fail(code, msg);
        }
        JSONObject data = response.getJSONObject("data");
        String plaintext = data.getString("plaintext");
        String resEncodeRes = data.getString("resEncode");
        return SM2DecRes.ok(resEncodeRes, plaintext);
    }

    public SM3HashRes hash(SM3HashRequest sm3HashRequest) {
        if (!(DataTypeEnum.HEX.getType().equalsIgnoreCase(sm3HashRequest.getResEncode()) || DataTypeEnum.BASE64.getType().equalsIgnoreCase(sm3HashRequest.getResEncode()) || DataTypeEnum.UTF8.getType().equalsIgnoreCase(sm3HashRequest.getResEncode()))) {
            return SM3HashRes.fail(CMEnum.SM3_RES_ENCODE_ERROR);
        }
        JsonObject requestParams = JsonObjectUtil.object2JsonObject(sm3HashRequest);
        String s = null;
        try {
            s = HttpUtil.postWithToken(this.getUrl() + "/sm3/hash", requestParams, this.token);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject response = JSON.parseObject((String)s);
        Integer code = response.getInteger("code");
        String msg = response.getString("msg");
        if (response.getInteger("code") != 0) {
            return SM3HashRes.fail(code, msg);
        }
        JSONObject data = response.getJSONObject("data");
        String hashText = data.getString("hashText");
        String resEncodeRes = data.getString("resEncode");
        return SM3HashRes.ok(resEncodeRes, hashText);
    }

    public SM4EncRes sm4EncData(SM4EncryptRequest sm4EncryptRequest) {
        if (!DataTypeEnum.HEX.getType().equalsIgnoreCase(sm4EncryptRequest.getResEncode()) && !DataTypeEnum.BASE64.getType().equalsIgnoreCase(sm4EncryptRequest.getResEncode())) {
            return SM4EncRes.fail(CMEnum.SM4_ENC_RES_ENCODE_ERROR);
        }
        JsonObject requestParams = JsonObjectUtil.object2JsonObject(sm4EncryptRequest);
        String s = null;
        try {
            s = HttpUtil.postWithToken(this.getUrl() + "/sm4/encrypt", requestParams, this.token);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject response = JSON.parseObject((String)s);
        Integer code = response.getInteger("code");
        String msg = response.getString("msg");
        if (response.getInteger("code") != 0) {
            return SM4EncRes.fail(code, msg);
        }
        JSONObject data = response.getJSONObject("data");
        String ciphertext = data.getString("ciphertext");
        String resEncodeRes = data.getString("resEncode");
        return SM4EncRes.ok(resEncodeRes, ciphertext);
    }

    public SM4DecRes sm4DecData(SM4DecryptRequest sm4DecryptRequest) {
        String iv = sm4DecryptRequest.getIv();
        if ("CBC".equals(sm4DecryptRequest.getMode()) && ("".equals(iv) || iv == null)) {
            return SM4DecRes.fail(CMEnum.SM4_IV_ERROR);
        }
        JsonObject requestParams = JsonObjectUtil.object2JsonObject(sm4DecryptRequest);
        String s = null;
        try {
            s = HttpUtil.postWithToken(this.getUrl() + "/sm4/decrypt", requestParams, this.token);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject response = JSON.parseObject((String)s);
        Integer code = response.getInteger("code");
        String msg = response.getString("msg");
        if (response.getInteger("code") != 0) {
            return SM4DecRes.fail(code, msg);
        }
        JSONObject data = response.getJSONObject("data");
        String plaintext = data.getString("plaintext");
        String resEncodeRes = data.getString("resEncode");
        return SM4DecRes.ok(resEncodeRes, plaintext);
    }

    public SM2GenerateKeyResponse sm2GenerateKeyPairByNumber(SM2KeyGenerateByNumberRequest sm2KeyGenerateRequest) {
        ArrayList<SM2KeyPairResponse> result = new ArrayList<SM2KeyPairResponse>();
        JsonObject requestParams = JsonObjectUtil.object2JsonObject(sm2KeyGenerateRequest);
        String s = null;
        try {
            s = HttpUtil.postWithToken(this.getUrl() + "/sm2/getKeyByNumber", requestParams, this.token);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject response = JSON.parseObject((String)s);
        String msg = response.getString("msg");
        Integer code = response.getInteger("code");
        if (code != 0) {
            return SM2GenerateKeyResponse.fail(code, msg);
        }
        JSONArray data = response.getJSONArray("data");
        for (int i = 0; i < data.size(); ++i) {
            JSONObject jsonObject = data.getJSONObject(i);
            SM2KeyPairResponse sm2KeyPairResponse = new SM2KeyPairResponse();
            sm2KeyPairResponse.setKeyId(jsonObject.getString("keyId"));
            byte[] priBytes = SM4.ECBDecrypt((byte[])DataEncodeHandle.requestDecode(jsonObject.getString("privateKey"), sm2KeyGenerateRequest.getResEncode()), (byte[])HexUtils.hexStringToBytes((String)this.sessionKey));
            sm2KeyPairResponse.setPublicKey(jsonObject.getString("publicKey"));
            sm2KeyPairResponse.setPrivateKey(DataEncodeHandle.resultEncode(priBytes, sm2KeyGenerateRequest.getResEncode()));
            sm2KeyPairResponse.setResEncode(jsonObject.getString("resEncode"));
            result.add(sm2KeyPairResponse);
        }
        return SM2GenerateKeyResponse.ok(result);
    }

    public SM2GenerateKeyResponse sm2GenerateKeyPairByKeyId(SM2KeyGenerateByKeyIdsRequest sm2KeyGenerateByKeyIdsRequest) {
        if (!DataTypeEnum.HEX.getType().equalsIgnoreCase(sm2KeyGenerateByKeyIdsRequest.getResEncode()) && !DataTypeEnum.BASE64.getType().equalsIgnoreCase(sm2KeyGenerateByKeyIdsRequest.getResEncode())) {
            return SM2GenerateKeyResponse.fail(CMEnum.SM2_GET_KEY_RES_ENCODE_ERROR);
        }
        ArrayList<SM2KeyPairResponse> result = new ArrayList<SM2KeyPairResponse>();
        JsonObject requestParams = JsonObjectUtil.object2JsonObject(sm2KeyGenerateByKeyIdsRequest);
        String s = null;
        try {
            s = HttpUtil.postWithToken(this.getUrl() + "/sm2/getKeyByKeyId", requestParams, this.token);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject response = JSON.parseObject((String)s);
        String msg = response.getString("msg");
        Integer code = response.getInteger("code");
        if (code != 0) {
            return SM2GenerateKeyResponse.fail(code, msg);
        }
        JSONArray data = response.getJSONArray("data");
        for (int i = 0; i < data.size(); ++i) {
            JSONObject jsonObject = data.getJSONObject(i);
            SM2KeyPairResponse sm2KeyPairResponse = new SM2KeyPairResponse();
            sm2KeyPairResponse.setKeyId(jsonObject.getString("keyId"));
            byte[] priBytes = SM4.ECBDecrypt((byte[])DataEncodeHandle.requestDecode(jsonObject.getString("privateKey"), sm2KeyGenerateByKeyIdsRequest.getResEncode()), (byte[])HexUtils.hexStringToBytes((String)this.sessionKey));
            sm2KeyPairResponse.setPublicKey(jsonObject.getString("publicKey"));
            sm2KeyPairResponse.setPrivateKey(DataEncodeHandle.resultEncode(priBytes, sm2KeyGenerateByKeyIdsRequest.getResEncode()));
            sm2KeyPairResponse.setResEncode(jsonObject.getString("resEncode"));
            result.add(sm2KeyPairResponse);
        }
        return SM2GenerateKeyResponse.ok(result);
    }

    public SM4KeyResponse sm4GetKeyByNumber(SM4KeyGetKeyByNumberRequest sm4KeyGetKeyByNumberRequest) {
        if (!DataTypeEnum.HEX.getType().equalsIgnoreCase(sm4KeyGetKeyByNumberRequest.getResEncode()) && !DataTypeEnum.BASE64.getType().equalsIgnoreCase(sm4KeyGetKeyByNumberRequest.getResEncode())) {
            return SM4KeyResponse.fail(CMEnum.SM4_GET_KEY_RES_ENCODE_ERROR);
        }
        ArrayList<SM4Key> sm4Keys = new ArrayList<SM4Key>();
        JsonObject requestParams = JsonObjectUtil.object2JsonObject(sm4KeyGetKeyByNumberRequest);
        String s = null;
        try {
            s = HttpUtil.postWithToken(this.getUrl() + "/sm4/getKeyByNumber", requestParams, this.token);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject response = JSON.parseObject((String)s);
        String msg = response.getString("msg");
        Integer code = response.getInteger("code");
        if (code != 0) {
            return SM4KeyResponse.fail(code, msg);
        }
        JSONArray data = response.getJSONArray("data");
        for (int i = 0; i < data.size(); ++i) {
            JSONObject jsonObject = data.getJSONObject(i);
            SM4Key sm4Key = new SM4Key();
            sm4Key.setKeyId(jsonObject.getString("keyId"));
            byte[] keyValueBytes = SM4.ECBDecrypt((byte[])DataEncodeHandle.requestDecode(jsonObject.getString("keyValue"), sm4KeyGetKeyByNumberRequest.getResEncode()), (byte[])HexUtils.hexStringToBytes((String)this.sessionKey));
            sm4Key.setKeyValue(DataEncodeHandle.resultEncode(keyValueBytes, sm4KeyGetKeyByNumberRequest.getResEncode()));
            sm4Keys.add(sm4Key);
        }
        return SM4KeyResponse.ok(sm4Keys);
    }

    public SM4KeyResponse sm4GetKeyByKeyId(SM4GetKeyByKeyIdRequest sm4GetKeyByKeyIdRequest) {
        if (!DataTypeEnum.HEX.getType().equalsIgnoreCase(sm4GetKeyByKeyIdRequest.getResEncode()) && !DataTypeEnum.BASE64.getType().equalsIgnoreCase(sm4GetKeyByKeyIdRequest.getResEncode())) {
            return SM4KeyResponse.fail(CMEnum.SM4_GET_KEY_RES_ENCODE_ERROR);
        }
        ArrayList<SM4Key> sm4Keys = new ArrayList<SM4Key>();
        JsonObject requestParams = JsonObjectUtil.object2JsonObject(sm4GetKeyByKeyIdRequest);
        String s = null;
        try {
            s = HttpUtil.postWithToken(this.getUrl() + "/sm4/getKeyByKeyId", requestParams, this.token);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject response = JSON.parseObject((String)s);
        String msg = response.getString("msg");
        Integer code = response.getInteger("code");
        if (code != 0) {
            return SM4KeyResponse.fail(code, msg);
        }
        JSONArray data = response.getJSONArray("data");
        for (int i = 0; i < data.size(); ++i) {
            JSONObject jsonObject = data.getJSONObject(i);
            SM4Key sm4Key = new SM4Key();
            sm4Key.setKeyId(jsonObject.getString("keyId"));
            byte[] keyValueBytes = SM4.ECBDecrypt((byte[])DataEncodeHandle.requestDecode(jsonObject.getString("keyValue"), sm4GetKeyByKeyIdRequest.getResEncode()), (byte[])HexUtils.hexStringToBytes((String)this.sessionKey));
            sm4Key.setKeyValue(DataEncodeHandle.resultEncode(keyValueBytes, sm4GetKeyByKeyIdRequest.getResEncode()));
            sm4Keys.add(sm4Key);
        }
        return SM4KeyResponse.ok(sm4Keys);
    }
}

