/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.september.smartdao.anno.AutoIncrease;
import org.september.smartdao.anno.Column;
import org.september.smartdao.anno.Id;
import org.september.smartdao.anno.Table;
import org.september.smartdao.model.QueryPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlHelper {
    private static final Logger Logger = LoggerFactory.getLogger(SqlHelper.class);

    public static String getTableName(Class<?> clazz) {
        String tableName = clazz.getSimpleName();
        Table tableAno = clazz.getAnnotation(Table.class);
        if (tableAno != null) {
            tableName = tableAno.name();
        }
        return tableName.toLowerCase();
    }

    public static List<QueryPair> getQueryPairs(Object parameterObject) {
        Field[] fields = parameterObject.getClass().getDeclaredFields();
        ArrayList<QueryPair> result = new ArrayList<QueryPair>();
        for (int i = 0; i < fields.length; ++i) {
            Id idAno;
            if (SqlHelper.isTransientField(fields[i]) || (idAno = fields[i].getAnnotation(Id.class)) != null) continue;
            fields[i].setAccessible(true);
            try {
                QueryPair pair;
                Object val = fields[i].get(parameterObject);
                if (val == null) continue;
                if (val instanceof String) {
                    if ("".equals(val)) continue;
                    pair = new QueryPair();
                    pair.setColumnName(SqlHelper.getColumnName(fields[i]));
                    pair.setColumnValue(val);
                    result.add(pair);
                    continue;
                }
                pair = new QueryPair();
                pair.setColumnName(SqlHelper.getColumnName(fields[i]));
                pair.setColumnValue(val);
                result.add(pair);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static boolean isTransientField(Field field) {
        return Modifier.isTransient(field.getModifiers());
    }

    public static String getColumnName(Field field) {
        Column colAno = field.getAnnotation(Column.class);
        if (colAno == null) {
            return field.getName();
        }
        return colAno.name();
    }

    public static Map dbFieldToEntityField(Class<?> clazz, Map dbData) throws SecurityException {
        HashMap result = new HashMap();
        for (Object key : dbData.keySet()) {
            Field field = SqlHelper.getFieldWithAnnotationColumnName(clazz, key.toString());
            if (field == null) {
                result.put(key, dbData.get(key));
                continue;
            }
            result.put(field.getName(), dbData.get(key));
        }
        return result;
    }

    public static Field[] getFieldsWithoutTransient(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Field> result = new ArrayList<Field>();
        for (int i = 0; i < fields.length; ++i) {
            if (SqlHelper.isTransientField(fields[i])) continue;
            result.add(fields[i]);
        }
        return result.toArray(new Field[0]);
    }

    public static boolean isAutoInstreaseField(Field field) {
        if (field == null) {
            return false;
        }
        AutoIncrease ano = field.getAnnotation(AutoIncrease.class);
        return ano != null;
    }

    public static boolean isIdField(Field field) {
        if (field == null) {
            return false;
        }
        Id ano = field.getAnnotation(Id.class);
        return ano != null;
    }

    public static Field getIdOfEntity(Object obj) {
        return SqlHelper.getIdOfClass(obj.getClass());
    }

    public static Field getIdOfClass(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            Id idAno = field.getAnnotation(Id.class);
            if (idAno == null) continue;
            return field;
        }
        throw new RuntimeException("Id not found for " + clazz);
    }

    public static String getIdColumnOfEntity(Object obj) {
        return SqlHelper.getIdColumnOfClass(obj.getClass());
    }

    public static String getIdColumnOfClass(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            Id idAno = field.getAnnotation(Id.class);
            if (idAno == null) continue;
            Column colAno = field.getAnnotation(Column.class);
            if (colAno == null) {
                return field.getName();
            }
            return colAno.name();
        }
        throw new RuntimeException("Id not found for " + clazz);
    }

    private static Field getFieldWithAnnotationColumnName(Class clazz, String annoName) {
        for (Field f : clazz.getDeclaredFields()) {
            Column anno = f.getAnnotation(Column.class);
            if (anno == null || !annoName.equals(anno.name())) continue;
            return f;
        }
        return null;
    }
}

