/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.util;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.september.smartdao.util.SqlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ReflectHelper {
    private static final Logger logger = LoggerFactory.getLogger(ReflectHelper.class);

    public static Map transformEntityToMap(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field f : obj.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            try {
                Object value = f.get(obj);
                if (value == null) continue;
                map.put(f.getName(), value);
            }
            catch (Exception e) {
                logger.warn("get " + f.getName() + " value of " + obj.getClass().getName() + " failed ");
            }
        }
        return map;
    }

    public static Map transEmptyString2Null(Object obj) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Field f : obj.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            try {
                Object value = f.get(obj);
                if (value == null) continue;
                if ("".equals(value)) {
                    map.compute(f.getName(), null);
                    continue;
                }
                map.put(f.getName(), value);
            }
            catch (Exception e) {
                logger.warn("get " + f.getName() + " value of " + obj.getClass().getName() + " failed ");
            }
        }
        return map;
    }

    public static <T> List<T> transformMapToEntity(Class<T> clazz, List<Map> mapResult) {
        ArrayList<T> entityResult = new ArrayList<T>();
        for (Map map : mapResult) {
            try {
                T entity = clazz.newInstance();
                ReflectHelper.setProperties(entity, map);
                entityResult.add(entity);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("try to wrap entity " + clazz.getName() + " failed", e);
            }
        }
        return entityResult;
    }

    public static void setProperties(Object dest, Map origin) throws IllegalArgumentException, IllegalAccessException {
        origin = SqlHelper.dbFieldToEntityField(dest.getClass(), origin);
        final ArrayList fieldList = new ArrayList();
        ReflectionUtils.doWithFields(dest.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                fieldList.add(field);
            }
        });
        for (Field field : fieldList) {
            Timestamp timestamp;
            String name = field.getName();
            Object value = origin.get(name);
            if (value == null) {
                value = origin.get(name.toUpperCase());
            }
            field.setAccessible(true);
            if (value == null) continue;
            if (value instanceof Boolean) {
                value = (Boolean)value != false ? Integer.valueOf(1) : Integer.valueOf(0);
            }
            if (field.getType().equals(Character.class) || field.getClass().equals(Character.TYPE)) {
                String str = (String)value;
                if (str.length() <= 0) continue;
                field.set(dest, Character.valueOf(str.charAt(0)));
                continue;
            }
            if (field.getType().equals(Instant.class)) {
                timestamp = (Timestamp)value;
                field.set(dest, timestamp.toInstant());
                continue;
            }
            if (field.getType().equals(LocalDateTime.class)) {
                timestamp = (Timestamp)value;
                field.set(dest, timestamp.toLocalDateTime());
                continue;
            }
            if (field.getType().equals(LocalDate.class)) {
                Date date = (Date)value;
                field.set(dest, date.toLocalDate());
                continue;
            }
            if (field.getType().equals(LocalTime.class)) {
                Time time = (Time)value;
                field.set(dest, time.toLocalTime());
                continue;
            }
            if (field.getType().equals(ZonedDateTime.class)) {
                timestamp = (Timestamp)value;
                field.set(dest, OffsetDateTime.ofInstant(timestamp.toInstant(), ZoneId.systemDefault()));
                continue;
            }
            if (field.getType().equals(JSONObject.class)) {
                JSONObject json = null;
                json = value.getClass() == byte[].class ? JSONObject.parseObject((String)new String((byte[])value)) : JSONObject.parseObject((String)value.toString());
                field.set(dest, json);
                continue;
            }
            if (field.getType().equals(Short.class)) {
                field.set(dest, Short.valueOf(value.toString()));
                continue;
            }
            if (value.getClass() == byte[].class) {
                field.set(dest, new String((byte[])value));
                continue;
            }
            field.set(dest, value);
        }
    }

    public static <T> T transformMapToEntity(Class<T> clazz, Map map) {
        if (map == null) {
            return null;
        }
        try {
            T entity = clazz.newInstance();
            ReflectHelper.setProperties(entity, map);
            return entity;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("try to wrap entity " + clazz.getName() + " failed", e);
        }
    }

    public static Object getValueByFieldName(Object obj, String fieldName) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = ReflectHelper.getFieldByFieldName(obj, fieldName);
        Object value = null;
        if (field != null) {
            if (field.isAccessible()) {
                value = field.get(obj);
            } else {
                field.setAccessible(true);
                value = field.get(obj);
                field.setAccessible(false);
            }
        }
        return value;
    }

    public static Field getFieldByFieldName(Object obj, String fieldName) {
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }
}

