/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.user.permission.controller;

import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.september.core.constant.enums.DeleteFlag;
import org.september.core.exception.BusinessException;
import org.september.pisces.user.permission.entity.Department;
import org.september.pisces.user.permission.entity.SystemRole;
import org.september.pisces.user.permission.entity.SystemUser;
import org.september.pisces.user.permission.service.DeptService;
import org.september.pisces.user.permission.service.OperationLogService;
import org.september.pisces.user.permission.service.SystemUserService;
import org.september.pisces.user.permission.service.UserOnlineStatusService;
import org.september.pisces.user.permission.utils.UserSessionHelper;
import org.september.simpleweb.auth.DefaultMethod;
import org.september.simpleweb.model.ResponseVo;
import org.september.smartdao.CommonDao;
import org.september.smartdao.CommonValidator;
import org.september.smartdao.model.Page;
import org.september.smartdao.model.ParamMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PiscesSystemUserController {
    @Autowired
    private CommonValidator commonValidator;
    @Autowired
    private CommonDao commonDao;
    @Autowired
    private UserOnlineStatusService userOnlineStatusService;
    @Autowired
    private SystemUserService systemUserService;
    @Autowired
    private OperationLogService operationLogService;
    @Autowired
    private DeptService deptService;
    private static final String Mapping_Prefix = "/userPermission/systemUser";
    public static final String List_Page = "/userPermission/systemUser/systemUserList";
    public static final String List_Data = "/userPermission/systemUser/systemUserListData";
    public static final String Add_Page = "/userPermission/systemUser/addSystemUser";
    public static final String Add_Action = "/userPermission/systemUser/doAddSystemUser";
    public static final String Edit_Page = "/userPermission/systemUser/editSystemUser";
    public static final String Edit_Action = "/userPermission/systemUser/doUpdateSystemUser";
    public static final String Reset_Password_Page = "/userPermission/systemUser/resetMyPwd";
    public static final String Reset_Password_Action = "/userPermission/systemUser/doResetMyPwd";
    public static final String Delete_Action = "/userPermission/systemUser/delete";

    @RequestMapping(value={"/userPermission/systemUser/systemUserList"})
    public ModelAndView systemUserList() throws Exception {
        ModelAndView mv = new ModelAndView();
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/userPermission/systemUser/systemUserListData"})
    public ResponseVo<Page<SystemUser>> systemUserListData(Long deptId, String realname, Page<SystemUser> page) throws Exception {
        SystemUser vo = new SystemUser();
        vo.setDeleteFlag(DeleteFlag.NotDelete.ordinal());
        ParamMap pm = new ParamMap();
        Department department = (Department)((Object)this.commonDao.get(Department.class, (Object)deptId));
        if (deptId != null && department != null) {
            pm.put("fullDeptId", (Object)department.getFullId());
        }
        pm.put("realname", (Object)realname);
        page = this.commonDao.findPageByParams(SystemUser.class, page, "PiscesSystemUser.systemUserListData", pm);
        for (SystemUser su : page.getResult()) {
            if (this.userOnlineStatusService.isUserWebOnline(su.getId())) {
                su.setWebOnline("\u5728\u7ebf");
            }
            if (!this.userOnlineStatusService.isUserAppOnline(su.getId())) continue;
            su.setAppOnline("\u5728\u7ebf");
        }
        return ResponseVo.BUILDER().setData((Object)page).setCode(Integer.valueOf(0));
    }

    @RequestMapping(value={"/userPermission/systemUser/addSystemUser"})
    public ModelAndView addSystemUser(Long deptId) throws Exception {
        ModelAndView mv = new ModelAndView();
        mv.addObject("deptId", (Object)deptId);
        Department dept = (Department)((Object)this.commonDao.get(Department.class, (Object)deptId));
        if (dept == null) {
            throw new BusinessException("\u90e8\u95e8\u4fe1\u606f\u9519\u8bef");
        }
        mv.addObject("deptName", (Object)dept.getName());
        this.prepareAllRoles(mv);
        return mv;
    }

    @ResponseBody
    @PostMapping(value={"/userPermission/systemUser/doAddSystemUser"})
    public ResponseVo<String> doAddSystemUser(@Valid SystemUser systemUser) throws Exception {
        if (StringUtils.isEmpty((Object)systemUser.getRoleIds())) {
            throw new BusinessException("\u8bf7\u5148\u9009\u62e9\u89d2\u8272");
        }
        boolean exist = this.commonValidator.exsits(SystemUser.class, new String[]{"phone", "deleteFlag"}, new Object[]{systemUser.getPhone(), DeleteFlag.NotDelete.ordinal()});
        if (exist) {
            throw new BusinessException("\u624b\u673a\u53f7\u7801\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!");
        }
        Department dept = this.deptService.getDepartmentByName(systemUser.getDeptName());
        if (dept == null) {
            throw new BusinessException("\u7528\u6237\u6240\u5c5e\u90e8\u95e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!");
        }
        systemUser.setFullDeptId(dept.getFullId());
        systemUser.setDeptId(dept.getId());
        this.systemUserService.addUser(systemUser);
        this.operationLogService.addLog("\u6dfb\u52a0\u4e86\u7528\u6237\u3010" + systemUser.getUsername() + "\u3011");
        return ResponseVo.BUILDER().setData((Object)"").setCode(Integer.valueOf(0));
    }

    @RequestMapping(value={"/userPermission/systemUser/editSystemUser"})
    public ModelAndView editSystemUser(Long id) throws Exception {
        ModelAndView mv = new ModelAndView();
        SystemUser po = (SystemUser)this.commonDao.get(SystemUser.class, (Object)id);
        mv.addObject("systemUser", (Object)po);
        Department dept = (Department)((Object)this.commonDao.get(Department.class, (Object)po.getDeptId()));
        po.setDeptName(dept.getName());
        List<Object> userRoleIdList = new ArrayList();
        if (po.getRoleIds() != null) {
            String[] arr = po.getRoleIds().split(";");
            userRoleIdList = Arrays.stream(arr).filter(x -> !StringUtils.isEmpty((Object)x)).map(Long::valueOf).collect(Collectors.toList());
        }
        mv.addObject("urIdList", userRoleIdList);
        this.prepareAllRoles(mv);
        return mv;
    }

    @ResponseBody
    @PostMapping(value={"/userPermission/systemUser/doUpdateSystemUser"})
    public ResponseVo<String> doUpdateSystemUser(@Valid SystemUser systemUser) throws Exception {
        boolean exist = this.commonValidator.exsitsNotMe(SystemUser.class, new String[]{"username", "deleteFlag"}, new Object[]{systemUser.getUsername(), DeleteFlag.NotDelete.ordinal()}, (Object)systemUser.getId());
        if (exist) {
            throw new BusinessException("\u8d26\u53f7\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!");
        }
        Department dept = this.deptService.getDepartmentByName(systemUser.getDeptName());
        if (dept == null) {
            throw new BusinessException("\u7528\u6237\u6240\u5c5e\u90e8\u95e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!");
        }
        systemUser.setFullDeptId(dept.getFullId());
        systemUser.setDeptId(dept.getId());
        if (!systemUser.getRoleIds().endsWith(";")) {
            systemUser.setRoleIds(systemUser.getRoleIds() + ";");
        }
        if (!systemUser.getRoleIds().endsWith(";")) {
            systemUser.setRoleIds(systemUser.getRoleIds() + ";");
        }
        this.commonDao.update((Object)systemUser);
        this.operationLogService.addLog("\u4fee\u6539\u4e86\u7528\u6237\u3010" + systemUser.getUsername() + "\u3011\u7684\u4fe1\u606f");
        return ResponseVo.BUILDER().setData((Object)"").setCode(Integer.valueOf(0));
    }

    @ResponseBody
    @RequestMapping(value={"/userPermission/systemUser/delete"})
    public ResponseVo<String> delete(Long id) throws Exception {
        SystemUser po = (SystemUser)this.commonDao.get(SystemUser.class, (Object)id);
        if (po == null) {
            throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        this.commonDao.delete((Object)po);
        this.operationLogService.addLog("\u5220\u9664\u4e86\u7528\u6237\u3010" + po.getUsername() + "\u3011");
        return ResponseVo.BUILDER().setCode(Integer.valueOf(0));
    }

    @DefaultMethod
    @RequestMapping(value={"/userPermission/systemUser/resetMyPwd"})
    public ModelAndView resetMyPwd() throws Exception {
        ModelAndView mv = new ModelAndView();
        mv.addObject("id", (Object)UserSessionHelper.getLoginUid());
        return mv;
    }

    @DefaultMethod
    @ResponseBody
    @RequestMapping(value={"/userPermission/systemUser/doResetMyPwd"})
    public ResponseVo<String> doResetMyPwd(Long id, String oldPwd, String newPwd, String newPwdRepeat) throws Exception {
        this.systemUserService.doResetMyPwd(id, oldPwd, newPwd, newPwdRepeat);
        return ResponseVo.BUILDER().setData((Object)"").setCode(Integer.valueOf(0));
    }

    private void prepareAllRoles(ModelAndView mv) {
        SystemRole roleVo = new SystemRole();
        roleVo.setDeleteFlag(DeleteFlag.NotDelete.ordinal());
        List roles = this.commonDao.listByExample((Object)roleVo);
        mv.addObject("roles", (Object)roles);
    }
}

