<!DOCTYPE html>
<html>
<head>
<script src="/assets/jquery/jquery-3.1.1.min.js"></script>
<script src="/assets/layui-2.9.18/layui.js"></script>
<link rel="stylesheet" href="/assets/layui-2.9.18/css/layui.css">
<link rel="stylesheet" href="/assets/layui-2.9.18/css/admin.css">
<script src="/assets/september/common.js"></script>
<script src="/assets/september/htmlBuilder.js"></script>
<script src="/assets/september/search.js"></script>
<link rel="stylesheet" href="/assets/pages/form.css">
<script src="/assets/pages/systemUser/form.js"></script>

<script src="/assets/jstree-3.3.17/jstree.min.js"></script>
<link rel="stylesheet" href="/assets/jstree-3.3.17/themes/default/style.min.css"/>

<style type="text/css">
</style>
</head>
<body>

	<div class="layui-form" lay-filter="layuiadmin-form-admin" id="layuiadmin-form-admin">
		<form id="form" class="layui-form">
			<div id="regionTree"></div>
		</form>
		<br/>
		<br/>
		
		<div class="layui-form-item">
			<input type="button" class="layui-btn layui-btn-normal" onclick="doGrantPermission()" style="position: fixed;bottom: 3px;right: 20px;"  value="保存">
		</div>
	</div>


	<script>
		var tree;
	    var mode = 'update';
	    layui.use(function(){
	        var form = layui.form;
	        tree = $('#regionTree').jstree({
	        	"plugins" : ["checkbox"],
	        	"checkbox" : {
			        "tie_selection": false,
			    },
	            'core': {
	                'check_callback': true,
	                'expand_selected_onload': true,
	                'data': [
	                    <#list itemList as item>
	                    {
	                        "id": "${item.id}",
	                        "state": {"opened": false},
	                        <#if item.parentId=="-1">
	                        	"parent": "#"
	                        <#else>
	                        	"parent": "${item.parentId}"
	                        </#if>,
	                        "text": "${item.text}",
	                        "a_attr": {"path": "${item.path!}"},
	                        state: {checked: ${item.checkFlag}}
	                    },
	                    </#list>
	                ]
	            }
	        });
	
	        $('#regionTree').on('changed.jstree', function (e, data) {
	            $('#form').show();
	            //当前选中节点的id
	            currentId = data.instance.get_node(data.selected[0]).id;
	            //当前选中节点的文本值
	            currentName = data.instance.get_node(data.selected[0]).text;
	
	            var parentId = data.node.parent;
	            var parentName = data.instance.get_node(parentId).text;
	
	            $('#id').val(currentId);
	            $('#name').val(currentName);
	
	            $('#parentId').val(parentId);
	            $('#parentName').val(parentName);
	            if (data.instance.get_node(data.selected[0])) {
	                let attr = data.instance.get_node(data.selected[0]).a_attr;
	                $('#type').val(attr.type);
	                $('#remark').val(attr.remark);
	            }
	            mode = 'update';
	        });
	
	    });
		
		function doGrantPermission(){
			var checkedNodeIds = $('#regionTree').jstree('get_checked', true);
			var checkedNodes = checkedNodeIds.map(function(nodeId) {
			  return $('#regionTree').jstree('get_node', nodeId);
			});
			var codes = [];
			for(var i=0;i<checkedNodes.length;i++){
				var node = checkedNodes[i];
				if(node.children.length==0){
					codes.push(node.a_attr.path);
				}
			}
			
			sajax({
				type : "POST",
				url : "/userPermission/systemRole/doGrantPermission",
				data : {roleId : ${roleId} , resources: codes.join(';')},
				success : function(data){
					layer.msg('保存成功',{shade: [0.1,'#fff'], time:1600});
					closeWindowAndRefreshParent();
				}
			});
		}
	</script>
</body>
</html>