<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <script src="/assets/jquery/jquery-3.1.1.min.js"></script>
	<script src="/assets/layui-2.9.18/layui.js"></script>
	<link rel="stylesheet" href="/assets/layui-2.9.18/css/layui.css">
	<link rel="stylesheet" href="/assets/layui-2.9.18/css/admin.css">
	<script src="/assets/september/common.js"></script>
	<script src="/assets/september/htmlBuilder.js"></script>
	<script src="/assets/september/search.js"></script>
	<link rel="stylesheet" href="/assets/pages/list.css">
	
    <script src="/assets/jstree-3.3.17/jstree.min.js"></script>
	<link rel="stylesheet" href="/assets/jstree-3.3.17/themes/default/style.min.css"/>
    <style>
        em {
            color: red
        }

        #regionTreeWrap {
            padding: -1px 15px !important;
        }
        .btn-small{
        	width: 80px;
		    height: 30px;
		    line-height: 30px;
		    padding: 0 10px;
        }
    </style>
</head>
<body class="layui-layout-body">
<div id="LAY_app">
    <div class="layui-layout layui-layout-admin">
            <div class="layui-fluid hei-100">
                <div class="layui-card hei-100">
                    <div class=" tree-wrap hei-100" id="regionTreeWrap"
                         style="width: 25%;float:left;overflow-y: scroll;">
                        <div class="layui-inline">
                            <button class="layui-btn layuiadmin-btn-list btn-small" onclick="openAddDepartment();">添加部门</button>
                        </div>
                        <div class="layui-inline">
                            <button class="layui-btn layuiadmin-btn-list btn-small" onclick="openEditDepartment();">编辑部门</button>
                        </div>
                        <div class="layui-inline">
                            <button class="layui-btn layuiadmin-btn-list btn-small" onclick="deleteDepartment();">删除部门</button>
                        </div>
                        <div id="deptTree"></div>
                    </div>
                    <div class="layui-card-body" style=" width: 72%; margin-left: 26%;">
                        <div class="layui-form-item" style="height:44px;clear:none;">
                            <input name="deptId" id="deptId" type="hidden"/>
                            <div class="layui-inline">
                                <label class="layui-search-form-label " style="display: inline;text-align: left;width: 42px;">姓  名</label>
                                <div class="layui-search-input-inline">
                                    <input type="text" name="realname" autocomplete="off" class="layui-input">
                                </div>
                            </div>
                            <div class="layui-inline">
                                <button class="layui-btn layuiadmin-btn-list" lay-submit
                                        lay-filter="LAY-app-contlist-search" onclick="doSearch(1);">
                                    <i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
                                </button>
                            </div>
                            <div class="layui-inline">
                                <button class="layui-btn layuiadmin-btn-list" onclick="openAddUser();">添加用户</button>
                            </div>
                        </div>
						
						<div id="form" class="layui-table-box layui-form" lay-filter="CadreUserList">
                            <table id="LAY-app-content-list" lay-filter="LAY-app-content-list" class="layui-table">
                                <thead>
                                <tr>
                                    <td align="center"><span>姓名</span></td>
                                    <td align="center"><span>部门</span></td>
                                    <td align="center"><span>登录账号</span></td>
                                    <td align="center"><span>手机号码</span></td>
                                    <td align="center"><span>邮箱</span></td>
                                    <td align="center"><span>权限角色</span></td>
                                    <td align="center"><span>在线状态</span></td>
                                    <th data-minwidth="150" class=" layui-table-col-special">
                                        <div class="layui-table-cell" align="center">
                                            <span>操作</span>
                                        </div>
                                    </th>
                                </tr>
                                </thead>
                                <tbody class="layui-table-body layui-table-main">
                                <tr class="data_row" style="display: none">
                                    <td align="center"><span>$[realname]</span></td>
                                    <td align="center"><span>$[deptName]</span></td>
                                    <td align="center"><span>$[username]</span></td>
                                    <td align="center"><span>$[phone]</span></td>
                                    <td align="center"><span>$[email]</span></td>
                                    <td align="center"><span>$[roleNamesString]</span></td>
                                    <td align="center">
                                    	<div>网页: <span class="online_$[webOnline]">$[webOnline]</span><div>
                                    	<div>APP: <span class="online_$[appOnline]">$[appOnline]</span><div>
                                    </td>
                                    <td align="center" data-minwidth="150" class="layui-table-col-special">
                                        <div class="layui-table-cell">
                                            <a class="layui-btn layui-btn-normal layui-btn-xs" onclick="openEditUser($[id])">编辑</a>
                                            <a class="layui-btn layui-btn-normal layui-btn-xs" onclick="selectStation($[id])">分配点位</a>
                                            <a class="layui-btn layui-btn-danger layui-btn-xs" onclick="deleteUser($[id])">删除</a>
                                        </div>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>

                        <div class="layui-card-body">
                            <div id="page"></div>
                        </div>
                    </div>
                </div>
            </div>
        <!-- 主体内容结束-->
    </div>
</div>
<#include "./deptTree.ftl">
<script type="text/javascript">
    var deptId;
    var tree;
    searchUrl = '/userPermission/systemUser/systemUserListData';
    layui.config({
        base: '../../../assets/layuiadmin/'
    }).use(['laypage', 'form'], function () {
        $('.hei-100').css("height", $(document).height() - 44);
        initTree('deptTree');
    });

function onTreeFinish(){
 	$('#deptTree').on('changed.jstree', function (e, data) {
         //当前选中节点的id
         deptId = data.instance.get_node(data.selected[0]).id;
         $('#deptId').val(deptId);
         doSearch(1);
     });
 	doSearch(1);
}


	function openEditUser(id) {
        layer.open({
            maxmin: true,
            type: 2,
            title: '编辑系统用户',
            area: ['50%', '500px'],
            content: '/userPermission/systemUser/editSystemUser?id=' + id
        });
    }


    function deleteUser(id) {
        confirmDelete(function () {
            sajax({
                type: "POST",
                url: "/userPermission/systemUser/delete?id=" + id,
                success: function (data) {
                    doPage(currentPage);
                    layer.msg('删除成功');
                }
            });
        });
    }
    
    function deleteDepartment(id) {
    	if(!deptId){
    		layer.msg('请先选择部门');
    		return;
    	}
        confirmDelete(function () {
            sajax({
                type: "POST",
                url: "/department/delete?id=" + deptId,
                success: function (data) {
                    doPage(currentPage);
                    layer.msg('删除成功');
                    window.location.reload();
                }
            });
        });
    }

    function openAddUser() {
    	if(!deptId){
    		layer.msg('请先选择部门');
    		return;
    	}
        layer.open({
            maxmin: true,
            type: 2,
            title: '添加系统用户',
            area: ['50%', '500px'],
            content: '/userPermission/systemUser/addSystemUser?deptId='+deptId
        });
    }

    function selectStation(id) {
        layer.open({
            maxmin: true,
            type: 2,
            title: '选择授权站点',
            area: ['80%', '90%'],
            content: '/station/selectStation?type=1&targetId=' + id
        })
    }
    
    function openAddDepartment(){
    	if(!deptId){
    		layer.msg('请先选择部门');
    		return;
    	}
		layer.open({
		  type: 2,
		  title: '添加',
		  area: ['80%', '80%'],
		  content: '/department/addDepartment?parentId='+deptId
		});
	}
	
	function openEditDepartment(){
		if(!deptId){
    		layer.msg('请先选择部门');
    		return;
    	}
		layer.open({
		  type: 2,
		  title: '编辑',
		  area: ['80%', '80%'],
		  content: '/department/editDepartment?id='+deptId
		});
	}

</script>

</body>
</html>
