/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.task.service;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import org.september.core.component.log.LogHelper;
import org.september.core.exception.BusinessException;
import org.september.pisces.task.entity.SimpleTask;
import org.september.pisces.task.enums.SimpleTaskStatus;
import org.september.pisces.task.service.DynamicScheduledTaskRegistrar;
import org.september.pisces.task.service.SimpleTaskLogService;
import org.september.smartdao.CommonDao;
import org.september.smartdao.model.ParamMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.config.ScheduledTask;
import org.springframework.stereotype.Service;

@Service
public class DynamicScheduledTaskService {
    protected LogHelper log = LogHelper.getLogger(this.getClass());
    private List<Long> runningTaskIds = new ArrayList<Long>();
    @Autowired
    private SimpleTaskLogService simpleTaskLogService;
    @Autowired
    private CommonDao commonDao;
    @Value(value="${org.september.pisces.task.enable:true}")
    private boolean enable;
    private final DynamicScheduledTaskRegistrar dynamicScheduledTaskRegistrar;

    public DynamicScheduledTaskService(@Value(value="${org.september.pisces.task.poolSize:16}") int poolSize) {
        this.dynamicScheduledTaskRegistrar = new DynamicScheduledTaskRegistrar(poolSize);
    }

    public void \u6bcf\u5929X\u70b9Y\u5206\u8fd0\u884c(String taskName, int x, int y, Object instance, String methodName) {
        String cron = "* " + y + " " + x + " * * ?";
        String remark = "\u6bcf\u5929" + x + "\u70b9" + y + "\u5206\u8fd0\u884c";
        this.addAndUpdate(taskName, cron, remark, instance, methodName, true, new Object[0]);
    }

    public void \u6bcf\u9694N\u79d2\u8fd0\u884c(String taskName, int seconds, Object instance, String methodName) {
        String cron = "0/" + seconds + " * * * * ?";
        this.addAndUpdate(taskName, cron, "\u6bcf\u9694" + seconds + "\u79d2\u904b\u884c\u4e00\u6b21", instance, methodName, true, new Object[0]);
    }

    public void \u4ece\u73b0\u5728\u5f00\u59cb\u6bcf\u9694N\u5206\u949f\u8fd0\u884c(String taskName, int n, Object instance, String methodName) {
        String cron = "0 0/" + n + " * * * ?";
        String remark = "\u4ece\u73b0\u5728\u5f00\u59cb\u6bcf\u9694" + n + "\u5206\u949f\u8fd0\u884c";
        this.addAndUpdate(taskName, cron, remark, instance, methodName, true, new Object[0]);
    }

    public void \u4ece\u73b0\u5728\u5f00\u59cb\u6bcf\u9694X\u5c0f\u65f6\u8fd0\u884c(String taskName, int x, Object instance, String methodName) {
        String cron = "0 0 0/" + x + " * * ?";
        String remark = "\u4ece\u73b0\u5728\u5f00\u59cb\u6bcf\u9694" + x + "\u5c0f\u65f6\u8fd0\u884c";
        this.addAndUpdate(taskName, cron, remark, instance, methodName, true, new Object[0]);
    }

    public void \u6bcf\u5468X\u7684Y\u70b9\u8fd0\u884c(String taskName, int x, int y, Object instance, String methodName) {
    }

    public SimpleTask addAndUpdate(String taskName, String cron, String remark, Object instance, String methodName, boolean persist, Object ... args) {
        if (persist) {
            SimpleTask taskPo = this.add(taskName, cron, instance, methodName, args);
            if (taskPo != null) {
                taskPo.setRemark(remark);
                taskPo.setCron(cron);
                taskPo.setTaskName(taskName);
                this.commonDao.update((Object)taskPo);
            }
            return taskPo;
        }
        this.dynamicScheduledTaskRegistrar.addCronTask(taskName, cron, () -> {
            try {
                this.log.getBuilder().info(taskName + " \u4efb\u52a1\u7531\u7ebf\u7a0b" + Thread.currentThread().getName() + "\u89e6\u53d1");
                if (!this.enable) {
                    this.log.getBuilder().info(0.01f, "\u5b9a\u65f6\u4efb\u52a1\u672a\u5f00\u542f", new Object[0]);
                    return;
                }
                Method method = instance.getClass().getDeclaredMethod(methodName, this.toClassArray(args));
                method.invoke(instance, args);
            }
            catch (Exception e) {
                this.log.getBuilder().info("\u4efb\u52d9\u57f7\u884c\u5931\u6557", (Throwable)e);
            }
        });
        return null;
    }

    private Class<?>[] toClassArray(Object[] args) {
        Class[] czz = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            czz[i] = args[i].getClass();
        }
        return czz;
    }

    private SimpleTask add(String taskName, String cron, Object instance, String methodName, Object ... args) {
        if (!this.enable) {
            this.log.getBuilder().info("\u5b9a\u65f6\u4efb\u52a1\u672a\u5f00\u542f");
            return null;
        }
        try {
            SimpleTask vo = new SimpleTask();
            vo.setApi(instance.getClass().getName() + "." + methodName);
            SimpleTask po = (SimpleTask)this.commonDao.getByExample((Object)vo);
            if (po == null) {
                vo.setCron(cron);
                vo.setTaskName(taskName);
                vo.setLocker(UUID.randomUUID().toString());
                this.commonDao.save((Object)vo);
                po = vo;
            }
            Method method = instance.getClass().getDeclaredMethod(methodName, this.toClassArray(args));
            Boolean result = this.dynamicScheduledTaskRegistrar.addCronTask(taskName, cron, () -> {
                SimpleTask taskPo = null;
                try {
                    this.log.getBuilder().info(taskName + " \u4efb\u52a1\u7531\u7ebf\u7a0b" + Thread.currentThread().getName() + "\u89e6\u53d1");
                    if (!this.enable) {
                        this.log.getBuilder().info(0.01f, "\u5b9a\u65f6\u4efb\u52a1\u672a\u5f00\u542f", new Object[0]);
                        return;
                    }
                    taskPo = this.lockAndGetTask(taskName);
                    if (taskPo != null) {
                        if (taskPo.getRunStatus() == SimpleTaskStatus.\u5df2\u6682\u505c.id.intValue()) {
                            this.log.getBuilder().info("\u4efb\u52a1" + taskName + "\u5df2\u7ecf\u6682\u505c");
                            return;
                        }
                        if (taskPo.getRunStatus() == SimpleTaskStatus.\u8fd0\u884c\u4e2d.id.intValue() && this.runningTaskIds.contains(taskPo.getId())) {
                            this.log.getBuilder().info("\u4efb\u52a1" + taskName + "\u6b63\u5728\u8fd0\u884c");
                            return;
                        }
                        taskPo.setRunStatus(SimpleTaskStatus.\u8fd0\u884c\u4e2d.id);
                        this.commonDao.update((Object)taskPo);
                        this.runningTaskIds.add(taskPo.getId());
                        method.invoke(instance, args);
                        taskPo.setLastExecuteTime(new Date());
                        taskPo.setRunStatus(SimpleTaskStatus.\u5f85\u8fd0\u884c.id);
                        taskPo.setLocker("");
                        this.commonDao.update((Object)taskPo);
                        this.runningTaskIds.remove(taskPo.getId());
                        this.simpleTaskLogService.addSuccessLog(taskPo);
                    } else {
                        this.log.getBuilder().info("\u4efb\u52a1" + taskName + "\u5df2\u7ecf\u4e0d\u5b58\u5728,\u6216\u8005\u6b63\u5728\u88ab\u5176\u4ed6\u8282\u70b9\u9501\u5b9a");
                    }
                }
                catch (Exception e) {
                    if (taskPo != null) {
                        this.simpleTaskLogService.addSuccessLog(taskPo);
                    }
                    throw new BusinessException("\u4efb\u52d9\u57f7\u884c\u5931\u6557", (Throwable)e);
                }
            });
            this.log.getBuilder().info("\u5b9a\u65f6\u4efb\u52a1\u6dfb\u52a0\u7ed3\u679c\uff1a" + result);
            return po;
        }
        catch (Exception e) {
            throw new BusinessException("\u6dfb\u52a0\u4efb\u52d9\u5931\u6557", (Throwable)e);
        }
    }

    private SimpleTask lockAndGetTask(String taskName) {
        ParamMap pm = new ParamMap();
        pm.put("taskName", (Object)taskName);
        String locker = UUID.randomUUID().toString();
        pm.put("locker", (Object)locker);
        int total = this.commonDao.execute("SimpleTask.lockTask", pm);
        if (total == 1) {
            SimpleTask vo = new SimpleTask();
            vo.setTaskName(taskName);
            vo.setRunStatus(SimpleTaskStatus.\u9501\u5b9a\u4e2d.id);
            vo.setLocker(locker);
            return (SimpleTask)this.commonDao.getByExample((Object)vo);
        }
        return null;
    }

    public void delete(String taskName) {
        this.dynamicScheduledTaskRegistrar.cancelCronTask(taskName);
    }

    private ScheduledFuture getFeature(ScheduledTask task) {
        try {
            Field field = task.getClass().getDeclaredField("future");
            field.setAccessible(true);
            return (ScheduledFuture)field.get(task);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

