/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.settings.controller;

import java.util.Map;
import org.september.core.component.ApplicationContextHolder;
import org.september.core.exception.BusinessException;
import org.september.pisces.settings.entity.SystemSettings;
import org.september.pisces.settings.service.PiscesSettingService;
import org.september.pisces.settings.service.SettingsUpdateEventHandler;
import org.september.pisces.user.permission.service.OperationLogService;
import org.september.simpleweb.controller.BaseController;
import org.september.simpleweb.model.ResponseVo;
import org.september.smartdao.model.Page;
import org.september.smartdao.model.ParamMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class PiscesSettingsController
extends BaseController {
    @Autowired
    private PiscesSettingService systemSettingService;
    @Autowired
    private OperationLogService operationLogService;
    private static final String Mapping_Prefix = "/pisces/settings";
    public static final String List_Page = "/pisces/settings/systemSettingList";
    public static final String List_Page_Data = "/pisces/settings/listSettingsData";
    public static final String Edit_Page = "/pisces/settings/editSetting";
    public static final String Edit_Action = "/pisces/settings/doUpdateSetting";

    @RequestMapping(value={"/pisces/settings/systemSettingList"})
    public ModelAndView systemSettingList() throws Exception {
        ModelAndView mv = new ModelAndView();
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/pisces/settings/listSettingsData"})
    public ResponseVo<Page<SystemSettings>> listSettingsData(Page<SystemSettings> page, SystemSettings vo) throws Exception {
        ParamMap pm = new ParamMap((Object)vo);
        page = this.systemSettingService.getCommonDao().findPageByParams(SystemSettings.class, page, "PiscesSettings.listSettings", pm);
        return ResponseVo.BUILDER().setData((Object)page).setCode(Integer.valueOf(0));
    }

    @RequestMapping(value={"/pisces/settings/editSetting"})
    public ModelAndView editSetting(Long id) throws Exception {
        ModelAndView mv = new ModelAndView();
        SystemSettings po = (SystemSettings)this.systemSettingService.getCommonDao().get(SystemSettings.class, (Object)id);
        mv.addObject("po", (Object)po);
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/pisces/settings/doUpdateSetting"})
    public ResponseVo<String> doUpdateSystemSetting(SystemSettings setting) throws Exception {
        SystemSettings po = (SystemSettings)this.systemSettingService.getCommonDao().get(SystemSettings.class, (Object)setting.getId());
        if (po.getCfgKey().contains("over_rate_level")) {
            if (!setting.getCfgVal().contains(",")) {
                throw new BusinessException("\u914d\u7f6e\u503c\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            String[] vals = setting.getCfgVal().split(",");
            if (vals.length < 2) {
                throw new BusinessException("\u914d\u7f6e\u503c\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            if (Double.parseDouble(vals[0]) >= Double.parseDouble(vals[1])) {
                throw new BusinessException("\u914d\u7f6e\u503c\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        String oldVal = po.getCfgVal();
        po.setCfgVal(setting.getCfgVal());
        po.setRemark(setting.getRemark());
        this.systemSettingService.update(po);
        this.operationLogService.addLog("\u4fee\u6539\u4e86\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f\u3010" + setting.getCfgKey() + "\u3011\u7684\u503c\u4e3a" + setting.getCfgVal() + ",\u539f\u503c\u4e3a" + oldVal);
        Map handlers = ApplicationContextHolder.getContext().getBeansOfType(SettingsUpdateEventHandler.class);
        for (SettingsUpdateEventHandler hd : handlers.values()) {
            hd.onUpdated(setting);
        }
        return ResponseVo.BUILDER().setData((Object)"").setCode(Integer.valueOf(0));
    }
}

