function removePreview(delBtn) {
    $(delBtn).parent().parent().parent().find('input').first().val('');
    $(delBtn).parent().remove();
}

function addPreviewImage(field, fileServer, filePath) {
    $('#' + field).val(filePath);
    $('#' + field + 'Preview').empty();
    var url = fileServer + filePath;
    $('#' + field + 'Preview').append('<div class="photo-thumb-warp"><img onclick="maxShowImage(this)" src="' + url + '" class="photo-thumb"/><i class="layui-icon layui-icon-close photo-thumb-remove" onclick="removePreview(this)"></i></div>');
}

function addPreviewMultiplyImage(field, fileServer, filePath) {
    var url = fileServer + filePath;
    $('#' + field + 'Preview').append('<div class="photo-thumb-warp"><img onclick="maxShowImage(this)" src="' + url + '" class="photo-thumb"/><i class="layui-icon layui-icon-close photo-thumb-remove" onclick="removePreviewAndInputValue(this,\'' + field + '\',\'' + filePath + '\')"></i></div>');
}

function addPreviewMultiplyReadonlyImage(field, fileServer, filePath) {
    var url = fileServer + filePath;
    $('#' + field + 'Preview').append('<div class="photo-thumb-warp"><img onclick="maxShowImage(this)" src="' + url + '" class="photo-thumb"/></div>');
}

function maxShowImage(img) {
    var xx = $(img).viewer({
        navbar: 0, toolbar: {
            zoomIn: 0,
            zoomOut: 0,
            oneToOne: 1,
            reset: 0,
            prev: 0,
            play: {
                show: 0,
                size: 'large',
            },
            next: 0,
            rotateLeft: 1,
            rotateRight: 1,
            flipHorizontal: 0,
            flipVertical: 0,
        },
        title: 0,
        fullscreen: false,
        viewed: function () {
            $(img).viewer('zoomTo', 1);
        }
    });
    /**
     layer.photos({
        photos: {
            "data": [
                {
                    "alt": "",
                    "src": img.src,
                    "thumb": ""
                }]
        },
        anim: 0 //0-6的选择，指定弹出图片动画类型，默认随机
    });
     **/
}

function removePreviewAndInputValue(delBtn, field, filePath) {
    $(delBtn).parent().remove();
    var filterChar = filePath + ";";
    var reg = new RegExp(filterChar, "g");
    $('#' + field).val($('#' + field).val().replace(reg, ""));

}

function addReadonlyPreviewImage(field, fileServer, filePath) {
    $('#' + field + 'Preview').empty();
    var url = fileServer + filePath;
    $('#' + field + 'Preview').append('<div class="photo-thumb-warp"><img onclick="maxShowImage(this)" src="' + url + '" class="photo-thumb"/></div>');
}

function addBase64PreviewImage(field, data) {
    $('#' + field + 'Preview').empty();
    $('#' + field + 'Preview').append('<div class="photo-thumb-warp"><img src="' + data + '" class="photo-thumb"/><i class="layui-icon layui-icon-close photo-thumb-remove" onclick="removePreview(this)"></i></div>');
}

// 默认值一周
function initDoubleDatetimePickerByWeek(id1, id2, type, minDate, layui) {
    initDoubleDatetimePickerWeek($('#' + id1)[0], $('#' + id2)[0], type, minDate, layui,1);
}

function initDoubleDatetimePickerByMonth(id1, id2, type, minDate, layui) {
    initDoubleDatetimePickerWeek($('#' + id1)[0], $('#' + id2)[0], type, minDate, layui,4);
}

function initDoubleDatetimePickerWeek(target1, target2, type, minDate, layui, weeks) {
    if (!type) {
        type = 'datetime';
    }
    var nowDate = new Date();
    var weekAgoDate = new Date(nowDate.getTime() - 1000 * 3600 * 24 * 7 * weeks);
    var startDate = layui.laydate.render({
            elem: target1,
            type: type,
            trigger: 'click',
            max: now(),
            value: weekAgoDate.getFullYear() + "-" +
                getTenUnit(weekAgoDate.getMonth() + 1) + "-" +
                getTenUnit(weekAgoDate.getDate()) + ' 00:00:00',
            done:
                function (value, date) {
                    if (value == '') {
                        endDate.config.min = now();
                    } else {
                        endDate.config.min = {
                            year: date.year,
                            month: date.month - 1,
                            date: date.date,
                            hours: date.hours,
                            minutes: date.minutes,
                            seconds: date.seconds
                        };

                        endDate.config.max = {
                            year: date.year,
                            month: date.month,
                            date: date.date,
                            hours: date.hours,
                            minutes: date.minutes,
                            seconds: date.seconds
                        }
                        var d = endDate.config.max;
                        $(target2).val(d.year + '-' +
                            getTenUnit(d.month + 1) + '-' +
                            getTenUnit(d.date) + ' ' +
                            getTenUnit(d.hours) + ':' + getTenUnit(d.minutes) + ':' + getTenUnit(d.seconds));
                    }
                }
        }
    );

    var endDate = layui.laydate.render({
        elem: target2,
        type: type,
        trigger: 'click',
        value: nowDate.getFullYear() + "-" + getTenUnit(nowDate.getMonth() + 1) + "-" +
            getTenUnit(nowDate.getDate()) + ' ' +
            getTenUnit(nowDate.getHours()) + ':' + getTenUnit(nowDate.getMinutes()) + ':' + getTenUnit(nowDate.getSeconds()),
        done: function (value, date) {
            if (value == '') {
                startDate.config.max = {
                    year: 2100,
                    month: 12,
                    date: 31
                }
            } else {
                startDate.config.max = {
                    year: date.year,
                    month: date.month - 1,
                    date: date.date,
                    hours: date.hours,
                    minutes: date.minutes,
                    seconds: date.seconds
                }
            }
        }
    });
}

function initDoubleDatetimePickerById(id1, id2, type, minDate, layui, day) {
    initDoubleDatetimePicker($('#' + id1)[0], $('#' + id2)[0], type, minDate, layui, day - 1);
}

function initDoubleDatetimePicker(target1, target2, type, minDate, layui, day) {
    if (!minDate) {
        minDate = now();
    }
    if (!type) {
        type = 'datetime';
    }
    var agoDate = new Date();
    agoDate.setTime(agoDate.getTime() - (24 * 60 * 60 * 1000) * Number(day))
    var nowDate = new Date();
    var startVal = agoDate.getFullYear() + "-" +
        getTenUnit(agoDate.getMonth() + 1) + "-" +
        getTenUnit(agoDate.getDate()) + ' 00:00:00'
    var endVal = nowDate.getFullYear() + "-" +
        getTenUnit(nowDate.getMonth() + 1) + "-" +
        getTenUnit(nowDate.getDate()) + ' ' +
        getTenUnit(nowDate.getHours()) + ':' + getTenUnit(nowDate.getMinutes()) + ':' + getTenUnit(nowDate.getSeconds())
    var startDate = layui.laydate.render({
        elem: target1,
        type: type,
        trigger: 'click',
        max: now(),
        value: startVal,
        done: function (value, date) {
            const startTime = new Date(value).getTime();
            const endTime = new Date($(target2).val()).getTime();
            if (startTime > endTime) {
                layer.msg("开始时间不能大于结束时间", { icon: 2 });
                $(target1).val(endVal);
            }
        }
    });

    var endDate = layui.laydate.render({
        elem: target2,
        type: type,
        trigger: 'click',
        max: now(),
        value: endVal,
        done: function (value, date) {
            const startTime = new Date($(target1).val()).getTime();
            const endTime = new Date(value).getTime();
            if (startTime > endTime) {
                layer.msg("结束时间不能小于开始时间", { icon: 2 });
                $(target2).val(startVal);
            }
        }
    });
}

function getTenUnit(number) {
    return number < 10 ? '0' + number : number;
}

function initDoubleDatetimeBeforeNow(id1, id2, minDate) {
    var startDate = layui.laydate.render({
        elem: '#' + id1,
        type: 'date',
        trigger: 'click',
        min: minDate,
        max: now(),
        done: function (value, date) {
            if (value == '') {
                endDate.config.min = minDate;
            } else {
                endDate.config.min = {
                    year: date.year,
                    month: date.month - 1,
                    date: date.date
                };
            }
        }
    });

    var endDate = layui.laydate.render({
        elem: '#' + id2,
        type: 'date',
        min: minDate,
        max: now(),
        trigger: 'click',
        done: function (value, date) {
            if (value == '') {
                startDate.config.max = now();
            } else {
                startDate.config.max = {
                    year: date.year,
                    month: date.month - 1,
                    date: date.date
                }
            }
        }
    });
}

function initSingleDatetimePicker(target, type, minDate, maxDate) {
    if (!minDate) {
        minDate = now();
    }
    if (!maxDate) {
        maxDate = '2100-01-01 00:00:00';
    }
    if (!type) {
        type = 'datetime';
    }
    layui.laydate.render({
        elem: target,
        type: type,
        trigger: 'click',
        min: minDate,
        max: maxDate
    });
}

function initSingleDatetimePickerById(id, type, minDate, maxDate) {
    initSingleDatetimePicker($('#' + id)[0], type, minDate, maxDate);
}

function now() {
    var now = new Date();
    return now.getFullYear() + "-" + (now.getMonth() + 1) + "-" + now.getDate() + " " + now.getHours() + ":" + now.getMinutes() + ":" + now.getSeconds();
}

function isDate(str) {
    if (!str) return '不能为空';
    if (str.length != 7 || !str.indexOf('-') < 0) return '请输入正确的格式';
    var split = str.split('-');
    if (split[0].length != 4 || parseInt(split[1]) > 12 || parseInt(split[1]) < 1) return '请输入正确的格式';
    return null;
}