/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.operation.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import org.apache.catalina.startup.Tomcat;
import org.september.simpleweb.auth.PublicMethod;
import org.september.simpleweb.model.ResponseVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/pisces/operation"})
public class StatusController {
    private static final Logger log = LoggerFactory.getLogger(StatusController.class);
    @Autowired
    private ServletWebServerApplicationContext applicationContext;

    @ResponseBody
    @RequestMapping(value={"/systemStatus"})
    public ModelAndView systemStatus() {
        ModelAndView mv = new ModelAndView();
        mv.addObject("freeSpace", (Object)"");
        mv.addObject("totalSpace", (Object)"");
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory() / 1024L / 1024L;
        long freeMemory = runtime.freeMemory() / 1024L / 1024L;
        long usedMemory = totalMemory - freeMemory;
        mv.addObject("totalMemory", (Object)totalMemory);
        mv.addObject("freeMemory", (Object)freeMemory);
        mv.addObject("usedMemory", (Object)usedMemory);
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        String osJson = JSON.toJSONString((Object)osBean, (boolean)true);
        JSONObject json = JSON.parseObject((String)osJson);
        mv.addObject("freePhysicalMemorySize", (Object)(json.getDouble("freePhysicalMemorySize") / 1024.0 / 1024.0 / 1024.0));
        mv.addObject("systemCpuLoad", (Object)(json.getDouble("systemCpuLoad") * 100.0));
        mv.addObject("processCpuLoad", (Object)(json.getDouble("processCpuLoad") * 100.0));
        mv.addObject("osJson", (Object)osJson);
        mv.addObject("lastBootTime", (Object)"");
        return mv;
    }

    @RequestMapping(value={"/all"})
    @ResponseBody
    @PublicMethod
    public ResponseVo<String> all() {
        Tomcat tomcat = ((TomcatWebServer)this.applicationContext.getWebServer()).getTomcat();
        String tomcatLog = tomcat.getConnector().getProtocolHandler().getExecutor().toString();
        return ResponseVo.BUILDER().setData((Object)tomcatLog).setCode(Integer.valueOf(0));
    }
}

