/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.filestore.service.hik;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.json.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.september.pisces.filestore.service.hik.ByteArrayUtil;
import org.september.pisces.filestore.service.hik.GmtTimeUtil;
import org.september.pisces.filestore.service.hik.HikPoolService;
import org.september.pisces.filestore.service.hik.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VideoClientImpl {
    private static final Logger log = LoggerFactory.getLogger(VideoClientImpl.class);
    @Autowired
    private HikPoolService poolService;
    private final String endStr = "\r\n";
    private final String twoHyphens = "--";
    private final String boundaryStr = "############";
    private final String divide = "--############";
    private final String contentType = "multipart/form-data";
    private static final String PREFIX = "storage";
    private static final String VIDEO_BEST_NODE_BASE_URI = "/ISAPI/Storage/bestNode";
    private static final String UPLOAD_VIDEO_URI = "/ISAPI/Storage/video/write";
    private static final String VIDEO_URI = "/ISAPI/Storage/videoStream/download?key=";

    private String getBestNode(String serialID) {
        return this.poolService.getBestNode("/ISAPI/Storage/bestNode?serialID=" + serialID + "&poolID=" + HikPoolService.videoPoolId + "&dataType=", PREFIX, 1, "application/json");
    }

    public String uploadVideo(byte[] data) throws JsonProcessingException {
        String gmtTime = GmtTimeUtil.getGmtTime();
        String serialID = "" + new Random().nextInt(1000000);
        String bestNode = this.getBestNode(serialID);
        JSONObject node = new JSONObject((Object)bestNode);
        String authorization = this.poolService.postAuth(PREFIX, "multipart/form-data", gmtTime, UPLOAD_VIDEO_URI, 1);
        String uri = "http://" + node.getStr((Object)"gatewayIP") + ":" + node.getStr((Object)"gatewayPort") + UPLOAD_VIDEO_URI;
        PostMethod postMethod = new PostMethod(uri);
        postMethod = this.buildUploadVideoRequestHeader(postMethod, gmtTime, authorization, "multipart/form-data");
        String body = this.buildUploadVideoRequestBody(serialID, node.getStr((Object)"token"), data.length);
        byte[] bodyAndPic = ByteArrayUtil.byteMerger(body.getBytes(StandardCharsets.UTF_8), data);
        String tail_str = "--############--\r\n\r\n";
        byte[] bytes = ByteArrayUtil.byteMerger(bodyAndPic, tail_str.getBytes(StandardCharsets.UTF_8));
        postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(bytes));
        RequestHandler requestHandler = new RequestHandler();
        String result = requestHandler.sendRequest((HttpMethodBase)postMethod);
        String url = new JSONObject((Object)result).getStr((Object)"url");
        String path = URLUtil.getPath((String)url);
        return path;
    }

    public InputStream getVideoStream(String key) {
        String gmtTime = GmtTimeUtil.getGmtTime();
        String url = VIDEO_URI + key + "&startTime=0&endTime=0&dataType=1";
        String authorization = this.poolService.getAuth(PREFIX, "", gmtTime, url, 1);
        GetMethod getMethod = new GetMethod("http://" + this.poolService.getAddress() + url);
        getMethod.addRequestHeader("Authorization", authorization);
        getMethod.addRequestHeader("Host", this.poolService.getAddress());
        getMethod.addRequestHeader("Date", gmtTime);
        getMethod.addRequestHeader("Connection", "close");
        RequestHandler requestHandler = new RequestHandler();
        return requestHandler.sendRequestReturnStream((HttpMethodBase)getMethod);
    }

    private PostMethod buildUploadVideoRequestHeader(PostMethod postMethod, String gmtTime, String authorization, String contentType) {
        postMethod.setRequestHeader("Host", this.poolService.getAddress());
        postMethod.setRequestHeader("Accept-Language", "zh-cn");
        postMethod.setRequestHeader("Authorization", authorization);
        postMethod.setRequestHeader("Date", gmtTime);
        postMethod.setRequestHeader("Content-Type", contentType + ";boundary=############");
        postMethod.setRequestHeader("Connection", "keep-alive");
        return postMethod;
    }

    public String buildUploadVideoRequestBody(String serialID, String token, int videoLen) {
        StringBuilder body = new StringBuilder("--############\r\n");
        body.append(" Content-Disposition: form-data;");
        body.append(" name=\"serialID\"\r\n\r\n" + serialID + "\r\n--############\r\nContent-Disposition: form-data;");
        body.append(" name=\"poolID\"\r\n\r\n" + HikPoolService.videoPoolId + "\r\n--############\r\nContent-Disposition: form-data;");
        body.append(" name=\"sourceDataType\"\r\n\r\n0\r\n--############\r\nContent-Disposition: form-data;");
        body.append(" name=\"token\"\r\n\r\n" + token + "\r\n--############\r\nContent-Disposition: form-data;");
        body.append(" name=\"dataLength\"\r\n\r\n" + videoLen + "\r\n--############\r\nContent-Disposition: form-data;");
        body.append(" name=\"data\"\r\nContent-Type:  video/h264\r\n\r\n");
        return body.toString();
    }

    public String uploadVideoFile(String path) {
        try {
            File file = new File(path);
            if (!file.exists()) {
                log.error("file does not exist");
                return null;
            }
            byte[] bytes = ByteArrayUtil.inputStream2ByteArray(path);
            log.info("Uploading video file {},length={} ", (Object)path, (Object)bytes.length);
            return this.uploadVideo(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void downloadVideo(String key, String localPath) {
        InputStream inputStream = this.getVideoStream(key);
        FileUtil.writeFromStream((InputStream)inputStream, (String)localPath);
    }
}

