/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.filestore.service;

import java.io.InputStream;
import org.september.core.component.log.LogHelper;
import org.september.core.exception.BusinessException;
import org.september.pisces.filestore.api.FileStoreService;
import org.september.pisces.filestore.entity.FileStoreItem;
import org.september.pisces.filestore.entity.FileStorePool;
import org.september.pisces.filestore.service.hik.ImageClientImpl;
import org.september.pisces.filestore.service.hik.VideoClientImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HikFileStoreService
implements FileStoreService {
    protected LogHelper log = LogHelper.getLogger(this.getClass());
    @Autowired
    private VideoClientImpl videoClient;
    @Autowired
    private ImageClientImpl imageClient;

    @Override
    public String saveWithThumb(FileStorePool pool, byte[] data, String ext, boolean needThumb, float thumbRate) {
        try {
            if (ext.toLowerCase().endsWith("mp4")) {
                return this.videoClient.uploadVideo(data);
            }
            return this.imageClient.uploadImage(data);
        }
        catch (Exception e) {
            throw new BusinessException("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public String save(FileStorePool pool, byte[] data, String ext) {
        return this.saveWithThumb(pool, data, ext, false, 0.0f);
    }

    @Override
    public String getHttpPath(String uuid) {
        return null;
    }

    @Override
    public InputStream getInputStream(FileStorePool pool, FileStoreItem item, boolean thumb) {
        boolean isVideo = item.getExt().toLowerCase().endsWith("mp4");
        if (isVideo) {
            return this.videoClient.getVideoStream(item.getPath());
        }
        return this.imageClient.getImageStream((String)(thumb ? item.getPath() + "&act=get&ztype=2&zvalue=30" : item.getPath()));
    }

    @Override
    public boolean deleteFile(FileStorePool pool, FileStoreItem item) {
        return false;
    }
}

