/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.excel.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.metadata.data.ImageData;
import com.alibaba.excel.metadata.data.WriteCellData;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.september.core.component.log.LogHelper;
import org.september.core.exception.BusinessException;
import org.september.pisces.excel.entity.ExcelTemplate;
import org.september.pisces.excel.vo.ExcelImage;
import org.september.pisces.filestore.entity.FileStoreItem;
import org.september.pisces.filestore.service.FileStoreManager;
import org.september.pisces.user.permission.service.OperationLogService;
import org.september.smartdao.common.BaseEntity;
import org.september.smartdao.common.BaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PiscesExcelService {
    protected LogHelper log = LogHelper.getLogger(this.getClass());
    @Autowired
    private BaseService baseService;
    @Autowired
    private FileStoreManager fileStoreManager;
    @Autowired
    private OperationLogService operationLogService;

    public ExcelTemplate addExcelTmpl(String name, byte[] fileData) {
        String[] arr = name.split("\\.");
        Object ext = "";
        if (arr.length > 1) {
            ext = "." + arr[arr.length - 1];
        }
        FileStoreItem item = this.fileStoreManager.save(null, fileData, (String)ext);
        ExcelTemplate vo = new ExcelTemplate();
        vo.setName(name);
        vo.setPath(item.getPath());
        vo.setFileUuid(item.getFileUUID());
        this.baseService.save((BaseEntity)vo);
        return vo;
    }

    public void doExport(HttpServletResponse response, String tmplName, List<Map<String, Object>> datas, String downloadFileName) throws Exception {
        ExcelTemplate tpl = this.getTemplate(tmplName);
        for (Map<String, Object> map : datas) {
            for (String key : map.keySet()) {
                Object val = map.get(key);
                if (!(val instanceof ExcelImage)) continue;
                map.put(key, this.getWriteCellData((ExcelImage)val));
            }
        }
        FileStoreItem item = this.fileStoreManager.getFileItem(tpl.getFileUuid());
        InputStream ins = this.fileStoreManager.getInputStreamByUUID(item);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode(downloadFileName, "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName);
        EasyExcel.write((OutputStream)response.getOutputStream()).withTemplate(ins).sheet().doFill(datas);
        ins.close();
        response.getOutputStream().close();
    }

    public void deleteTemplate(Long tplId) {
        ExcelTemplate po = (ExcelTemplate)((Object)this.baseService.getCommonDao().get(ExcelTemplate.class, (Object)tplId));
        if (po == null) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        this.fileStoreManager.deleteFile(po.getFileUuid());
        this.baseService.delete((BaseEntity)po);
        this.operationLogService.addLog("\u5220\u9664\u4e86excel\u6a21\u677f\u3010" + po.getName() + "\u3011");
    }

    public ExcelTemplate getTemplate(String tmplName) {
        ExcelTemplate vo = new ExcelTemplate();
        vo.setDeleteFlag(0);
        vo.setName(tmplName);
        ExcelTemplate po = (ExcelTemplate)((Object)this.baseService.getCommonDao().getByExample((Object)vo));
        return po;
    }

    private WriteCellData<Void> getWriteCellData(ExcelImage emg) throws IOException {
        WriteCellData cell = new WriteCellData();
        ArrayList<ImageData> imageDataList = new ArrayList<ImageData>();
        ImageData img = new ImageData();
        img.setImage(emg.getDatas());
        imageDataList.add(img);
        cell.setImageDataList(imageDataList);
        return cell;
    }
}

