/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.cache.vo;

import java.util.Date;

public class CacheVo {
    private boolean autoRefresh;
    private String key;
    private String remark;
    private Date expireTime;
    private int timeoutSec;
    private Date addTime;
    private int leftSeconds;
    private long size;
    private Object target;
    private volatile boolean updating;

    public CacheVo(String key, Object target, String remark, int timeoutSec, boolean autoRefresh) {
        this.key = key;
        this.remark = remark.length() > 200 ? remark.substring(0, 200) : remark;
        this.timeoutSec = timeoutSec;
        this.target = target;
        this.expireTime = new Date(System.currentTimeMillis() + (long)(timeoutSec * 1000));
        this.autoRefresh = autoRefresh;
    }

    public boolean isExpired() {
        Long endTime = this.expireTime.getTime();
        return endTime == null || System.currentTimeMillis() >= endTime;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public int getTimeoutSec() {
        return this.timeoutSec;
    }

    public void setTimeoutSec(int timeoutSec) {
        this.timeoutSec = timeoutSec;
    }

    public Date getAddTime() {
        return this.addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public int getLeftSeconds() {
        return this.leftSeconds;
    }

    public void setLeftSeconds(int leftSeconds) {
        this.leftSeconds = leftSeconds;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }
}

