/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.cache.controller;

import java.util.ArrayList;
import java.util.List;
import org.september.pisces.cache.service.ExpirableCacheService2;
import org.september.pisces.cache.vo.CacheVo;
import org.september.simpleweb.model.ResponseVo;
import org.september.smartdao.model.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CacheController {
    @Autowired
    private ExpirableCacheService2 expirableCacheService2;
    private static final String Mapping_Prefix = "/pisces/cache";
    public static final String List_Page = "/pisces/cache/cacheList";
    public static final String List_Data = "/pisces/cache/listCacheData";
    public static final String Delete_Action = "/pisces/cache/delete";

    public CacheController() {
        System.out.println("CacheController......");
    }

    @RequestMapping(value={"/pisces/cache/cacheList"})
    public ModelAndView cacheList() throws Exception {
        ModelAndView mv = new ModelAndView();
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/pisces/cache/listCacheData"})
    public ResponseVo<Page<CacheVo>> listCacheData(Page<CacheVo> page, String name) throws Exception {
        List<CacheVo> caches = this.expirableCacheService2.toList();
        List<Object> result = new ArrayList();
        if (StringUtils.hasText((String)name)) {
            for (CacheVo cache : caches) {
                if (!cache.getKey().contains(name)) continue;
                result.add(cache);
            }
        } else {
            result = caches;
        }
        page.setResult(result);
        page.setPageSize(result.size() + 1);
        page.setTotalResult(result.size());
        return ResponseVo.BUILDER().setData(page).setCode(Integer.valueOf(0));
    }

    @ResponseBody
    @RequestMapping(value={"/pisces/cache/delete"})
    public ResponseVo<String> delete(String key) throws Exception {
        this.expirableCacheService2.remove(key);
        return ResponseVo.BUILDER().setData((Object)"success").setCode(Integer.valueOf(0));
    }
}

