/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.util;

import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.september.core.component.log.LogHelper;
import org.september.smartdao.anno.AutoIncrease;
import org.september.smartdao.anno.Id;
import org.september.smartdao.anno.IntegerDefaultValue;
import org.september.smartdao.model.QueryPair;
import org.september.smartdao.util.ReflectHelper;

public class SqlHelper {
    private static final LogHelper logger = LogHelper.getLogger(SqlHelper.class);

    public String getTableName(Class<?> clazz) {
        String tableName = clazz.getSimpleName();
        Table tableAno = clazz.getAnnotation(Table.class);
        if (tableAno != null && ((tableName = tableAno.name()) == null || "".equals(tableName))) {
            tableName = tableAno.value();
        }
        return tableName.toLowerCase();
    }

    public List<QueryPair> getQueryPairs(Object parameterObject) {
        return this.getQueryPairs(parameterObject, false);
    }

    public List<QueryPair> getQueryPairs(Object parameterObject, boolean defaultValue) {
        ArrayList<QueryPair> result = new ArrayList<QueryPair>();
        if (parameterObject == null) {
            return result;
        }
        Field[] fields = this.getFieldsWithoutTransient(parameterObject.getClass());
        int i = 0;
        while (i < fields.length) {
            Id idAno = fields[i].getAnnotation(Id.class);
            if (idAno == null) {
                fields[i].setAccessible(true);
                try {
                    Object val = fields[i].get(parameterObject);
                    if (val != null) {
                        pair = new QueryPair();
                        if (val instanceof Enum) {
                            pair.setColumnName(this.getColumnName(fields[i]));
                            pair.setColumnValue(((Enum)val).ordinal());
                            result.add(pair);
                        } else {
                            pair.setColumnName(this.getColumnName(fields[i]));
                            pair.setColumnValue(val);
                            result.add(pair);
                        }
                    } else if (defaultValue) {
                        pair = new QueryPair();
                        pair.setColumnName(this.getColumnName(fields[i]));
                        IntegerDefaultValue anno = fields[i].getAnnotation(IntegerDefaultValue.class);
                        if (anno != null) {
                            pair.setColumnValue(anno.value());
                            result.add(pair);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ++i;
        }
        return result;
    }

    public String getColumnName(Field field) {
        Column colAno = field.getAnnotation(Column.class);
        if (colAno == null) {
            return field.getName();
        }
        return colAno.name();
    }

    public Map<String, Object> dbFieldToEntityField(Class<?> clazz, Map<String, Object> dbData) throws SecurityException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : dbData.keySet()) {
            Field field = this.getFieldWithAnnotationColumnName(clazz, key.toString());
            if (field == null) {
                String snakeName = SqlHelper.camelToSnake(key.toString());
                field = this.getFieldWithAnnotationColumnName(clazz, snakeName);
                if (field != null) {
                    result.put(field.getName(), dbData.get(key));
                    continue;
                }
                logger.getBuilder().error(key.toString() + "\u4e0e\u5b9e\u4f53\u7c7b\u5b57\u6bb5\u4e0d\u5339\u914d");
                continue;
            }
            result.put(field.getName(), dbData.get(key));
        }
        return result;
    }

    public Field[] getFieldsWithoutTransient(Class<?> clazz) {
        Field[] fields = ReflectHelper.getAllDeclaredFields(clazz);
        ArrayList<Field> result = new ArrayList<Field>();
        int i = 0;
        while (i < fields.length) {
            if (!ReflectHelper.isTransientField(fields[i])) {
                result.add(fields[i]);
            }
            ++i;
        }
        return result.toArray(new Field[0]);
    }

    public boolean isAutoInstreaseField(Field field) {
        if (field == null) {
            return false;
        }
        AutoIncrease ano = field.getAnnotation(AutoIncrease.class);
        return ano != null;
    }

    public boolean isIdField(Field field) {
        if (field == null) {
            return false;
        }
        Id ano = field.getAnnotation(Id.class);
        return ano != null;
    }

    public Field getIdOfEntity(Object obj) {
        return this.getIdOfClass(obj.getClass());
    }

    public Field getIdOfClass(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Id idAno = field.getAnnotation(Id.class);
            if (idAno != null) {
                return field;
            }
            ++n2;
        }
        if (clazz.getSuperclass() != Object.class) {
            return this.getIdOfClass(clazz.getSuperclass());
        }
        throw new RuntimeException("Id not found for " + String.valueOf(clazz));
    }

    public String getIdColumnOfEntity(Object obj) {
        return this.getIdColumnOfClass(obj.getClass());
    }

    public String getIdColumnOfClass(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Id idAno = field.getAnnotation(Id.class);
            if (idAno != null) {
                Column colAno = field.getAnnotation(Column.class);
                if (colAno == null) {
                    return field.getName();
                }
                return colAno.name();
            }
            ++n2;
        }
        throw new RuntimeException("Id not found for " + String.valueOf(clazz));
    }

    protected Field getFieldWithAnnotationColumnName(Class clazz, String dbName) {
        for (Field f : this.getAllDeclaredFields(clazz)) {
            Column anno = f.getAnnotation(Column.class);
            if (!(anno == null ? f.getName().equals(dbName) : dbName.equals(anno.name()))) continue;
            return f;
        }
        return null;
    }

    protected List<Field> getAllDeclaredFields(Class clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields;
            if (clazz.equals(Object.class)) break;
            Field[] fieldArray = fields = clazz.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                result.add(field);
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static String camelToSnake(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.replaceAll("([a-z])([A-Z0-9])", "$1_$2").toLowerCase();
    }

    public static void main(String[] args) {
        System.out.println(SqlHelper.camelToSnake("maxWeightAxel6"));
    }
}

