/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.mybatis.spring.SqlSessionTemplate;
import org.september.core.exception.BusinessException;
import org.september.smartdao.CommonDaoHolder;
import org.september.smartdao.anno.AutoIncrease;
import org.september.smartdao.anno.IntegerDefaultValue;
import org.september.smartdao.anno.OptimisticLock;
import org.september.smartdao.anno.Sequence;
import org.september.smartdao.config.FieldDataConverter;
import org.september.smartdao.datasource.MyDataSource;
import org.september.smartdao.datasource.SmartDatasourceHolder;
import org.september.smartdao.model.Order;
import org.september.smartdao.model.Page;
import org.september.smartdao.model.ParamMap;
import org.september.smartdao.model.QueryPair;
import org.september.smartdao.util.DMSqlHelper;
import org.september.smartdao.util.ReflectHelper;
import org.september.smartdao.util.SqlHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CommonDao {
    @Autowired(required=false)
    FieldDataConverter fieldDataConverter;
    @Autowired
    SqlSessionTemplate sqlSessionTemplate;
    private SqlHelper sqlHelper;

    public CommonDao() {
        CommonDaoHolder.dao = this;
        if ("mysql".equals(SmartDatasourceHolder.srds.getDialect())) {
            this.sqlHelper = new SqlHelper();
        } else if ("dm".equals(SmartDatasourceHolder.srds.getDialect())) {
            this.sqlHelper = new DMSqlHelper();
        }
    }

    public void save(Object entity, String tableName) {
        try {
            if (StringUtils.isEmpty((Object)tableName)) {
                throw new BusinessException("tablename should not be empty!");
            }
            SmartDatasourceHolder.switchToWrite();
            List<QueryPair> queryPairList = this.sqlHelper.getQueryPairs(entity, true);
            ParamMap pm = new ParamMap();
            pm.put("columnList", (Object)queryPairList);
            pm.put("tableName", (Object)tableName);
            String keyName = this.sqlHelper.getIdOfClass(entity.getClass()).getName();
            Sequence seq = this.sqlHelper.getIdOfClass(entity.getClass()).getAnnotation(Sequence.class);
            AutoIncrease auto = this.sqlHelper.getIdOfClass(entity.getClass()).getAnnotation(AutoIncrease.class);
            if (seq != null) {
                pm.put("selectKey", (Object)seq.selectKey());
                this.sqlSessionTemplate.insert("CommonEntityMapper.insertEntityWithSequence", (Object)pm);
                long id = (Long)pm.get("id");
                BeanUtils.setProperty((Object)entity, (String)keyName, (Object)id);
            } else if (auto != null) {
                MyDataSource ds = SmartDatasourceHolder.getCurrentDataSource();
                if (ds.getUrl().contains("mysql")) {
                    this.sqlSessionTemplate.insert("CommonEntityMapper.insertEntityAutoIncrease", (Object)pm);
                } else if (ds.getUrl().contains("sqlserver")) {
                    this.sqlSessionTemplate.insert("CommonEntityMapper.insertMSEntityAutoIncrease", (Object)pm);
                } else if (ds.getUrl().contains("dm")) {
                    this.sqlSessionTemplate.insert("CommonEntityMapper.insertEntityAutoIncrease", (Object)pm);
                } else {
                    throw new BusinessException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u91cf\u7c7b\u578b");
                }
                long id = (Long)pm.get("id");
                BeanUtils.setProperty((Object)entity, (String)keyName, (Object)id);
            } else {
                Field idField = this.sqlHelper.getIdOfEntity(entity);
                idField.setAccessible(true);
                QueryPair id = new QueryPair();
                id.setColumnName(keyName);
                id.setColumnValue(idField.get(entity));
                queryPairList.add(id);
                this.sqlSessionTemplate.insert("CommonEntityMapper.insertEntityWithId", (Object)pm);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4fdd\u5b58\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    public void save(Object entity) {
        this.save(entity, this.sqlHelper.getTableName(entity.getClass()));
    }

    public int update(Object entity) {
        String tableName = this.sqlHelper.getTableName(entity.getClass());
        return this.update(entity, tableName);
    }

    public int update(Object entity, String tableName) {
        try {
            SmartDatasourceHolder.switchToWrite();
            Field id = this.sqlHelper.getIdOfEntity(entity);
            id.setAccessible(true);
            if (id != null) {
                Object val = id.get(entity);
                if (val == null) {
                    throw new BusinessException("id can't be null when update");
                }
                if (StringUtils.isEmpty((Object)tableName)) {
                    tableName = this.sqlHelper.getTableName(entity.getClass());
                }
                return this.updateByField(entity.getClass(), id.getName(), val, entity, false, tableName);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new BusinessException("\u66f4\u65b0\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return 0;
    }

    public void updateWithNullFields(Object entity) {
        try {
            SmartDatasourceHolder.switchToWrite();
            Field id = this.sqlHelper.getIdOfEntity(entity);
            id.setAccessible(true);
            if (id != null) {
                Object val = id.get(entity);
                if (val == null) {
                    throw new RuntimeException("id can't be null when update");
                }
                String tableName = this.sqlHelper.getTableName(entity.getClass());
                this.updateByField(entity.getClass(), id.getName(), val, entity, true, tableName);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new BusinessException("\u66f4\u65b0\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    public int deleteByIds(Class<?> clazz, List<Object> ids) {
        SmartDatasourceHolder.switchToWrite();
        ParamMap pm = new ParamMap();
        pm.put("idColumn", (Object)this.sqlHelper.getIdColumnOfClass(clazz));
        pm.put("tableName", (Object)this.sqlHelper.getTableName(clazz));
        pm.put("ids", (Object)ids);
        return this.sqlSessionTemplate.delete("CommonEntityMapper.deleteByIds", (Object)pm);
    }

    public void delete(Object entity) {
        Object val;
        SmartDatasourceHolder.switchToWrite();
        ParamMap pm = new ParamMap();
        Field id = this.sqlHelper.getIdOfEntity(entity);
        if (id != null) {
            val = null;
            try {
                id.setAccessible(true);
                val = id.get(entity);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (val == null) {
                throw new RuntimeException("id can't be null when delete");
            }
        } else {
            throw new RuntimeException("id field not found for class " + entity.getClass());
        }
        pm.put("idColumn", (Object)this.sqlHelper.getIdColumnOfEntity(entity));
        pm.put("idValue", val);
        pm.put("tableName", (Object)this.sqlHelper.getTableName(entity.getClass()));
        this.sqlSessionTemplate.delete("CommonEntityMapper.deleteById", (Object)pm);
    }

    public <T> T get(Class<T> clazz, Object id) {
        if (id == null) {
            return null;
        }
        SmartDatasourceHolder.switchToRead();
        String tableName = this.sqlHelper.getTableName(clazz);
        ParamMap pm = new ParamMap();
        pm.put("tableName", (Object)tableName);
        pm.put("idColumn", (Object)this.sqlHelper.getIdColumnOfClass(clazz));
        pm.put("idValue", id);
        Map map = (Map)this.sqlSessionTemplate.selectOne("CommonEntityMapper.getById", (Object)pm);
        T result = ReflectHelper.transformMapToEntity(clazz, map);
        return result;
    }

    public Map<String, Object> get(String tableName, String idColumn, Object id) {
        if (id == null) {
            return null;
        }
        SmartDatasourceHolder.switchToRead();
        ParamMap pm = new ParamMap();
        pm.put("tableName", (Object)tableName);
        pm.put("idColumn", (Object)idColumn);
        pm.put("idValue", id);
        Map map = (Map)this.sqlSessionTemplate.selectOne("CommonEntityMapper.getById", (Object)pm);
        return map;
    }

    public <T> List<T> listByIds(Class<T> clazz, List<? extends Object> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList();
        }
        SmartDatasourceHolder.switchToRead();
        String tableName = this.sqlHelper.getTableName(clazz);
        ParamMap pm = new ParamMap();
        pm.put("tableName", (Object)tableName);
        pm.put("idColumn", (Object)this.sqlHelper.getIdColumnOfClass(clazz));
        pm.put("ids", (Object)ids);
        List mapResult = this.sqlSessionTemplate.selectList("CommonEntityMapper.listByIds", (Object)pm);
        List<T> entityResult = ReflectHelper.transformMapToEntity(clazz, mapResult);
        return entityResult;
    }

    public <T> T getByExample(T example) {
        if (example == null) {
            return null;
        }
        List<T> list = this.listByExample(example);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public <T> List<T> listByExample(T example) {
        return this.listByExample(example, null);
    }

    public <T> List<T> listByExample(T vo, List<Order> orders) {
        SmartDatasourceHolder.switchToRead();
        String tableName = this.sqlHelper.getTableName(vo.getClass());
        List<QueryPair> queryPairs = this.sqlHelper.getQueryPairs(vo);
        ParamMap pm = new ParamMap();
        pm.put("tableName", (Object)tableName);
        pm.put("queryPairList", (Object)queryPairs);
        if (orders != null && !orders.isEmpty()) {
            pm.put("orders", (Object)orders);
        }
        List mapResult = this.sqlSessionTemplate.selectList("CommonEntityMapper.listByExample", (Object)pm);
        List<?> entityResult = ReflectHelper.transformMapToEntity(vo.getClass(), mapResult);
        return entityResult;
    }

    public List<Map<String, Object>> listByParams(String statementId, ParamMap pm) {
        SmartDatasourceHolder.switchToRead();
        List result = this.sqlSessionTemplate.selectList(statementId, (Object)pm);
        return result;
    }

    public Map<String, Object> findOne(String statement, ParamMap paramMap) {
        List<Map<String, Object>> list = this.listByParams(statement, paramMap);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public <T> List<T> listByParams(Class<T> clazz, String statementId, ParamMap paramMap) {
        List<Map<String, Object>> mapResult = this.listByParams(statementId, paramMap);
        List<Object> entityResult = null;
        entityResult = mapResult.isEmpty() ? new ArrayList() : ReflectHelper.transformMapToEntity(clazz, mapResult);
        return entityResult;
    }

    public <T> Page<T> findPageByExample(Class<T> clazz, Page<T> page, Object example) {
        return this.findPageByExample(clazz, page, example, null);
    }

    public <T> Page<T> findPageByExample(Class<T> clazz, Page<T> page, Object example, List<Order> orders) {
        SmartDatasourceHolder.switchToRead();
        String tableName = this.sqlHelper.getTableName(clazz);
        List<QueryPair> queryPairs = this.sqlHelper.getQueryPairs(example);
        ParamMap paramMap = new ParamMap();
        paramMap.put("tableName", (Object)tableName);
        paramMap.put("queryPairList", (Object)queryPairs);
        paramMap.put("page", (Object)page);
        paramMap.put("queryPairList", (Object)queryPairs);
        if (orders != null && !orders.isEmpty()) {
            paramMap.put("orders", (Object)orders);
        }
        com.github.pagehelper.Page innerPage = PageHelper.startPage((int)page.getCurrentPage(), (int)page.getPageSize());
        List mapResult = this.sqlSessionTemplate.selectList("CommonEntityMapper.findPage", (Object)paramMap);
        List<T> entityResult = ReflectHelper.transformMapToEntity(clazz, mapResult);
        page.setResult(entityResult);
        PageInfo pageInfo = innerPage.toPageInfo();
        page.setTotalResult((int)pageInfo.getTotal());
        page.setStartRow(pageInfo.getStartRow());
        page.setEndRow(pageInfo.getEndRow());
        return page;
    }

    public <T> Page<T> findPageByParams(Class<T> clazz, Page<T> page, String statement, ParamMap paramMap) {
        if (page == null) {
            throw new RuntimeException("page can not be null when findPageByParams");
        }
        com.github.pagehelper.Page innerPage = PageHelper.startPage((int)page.getCurrentPage(), (int)page.getPageSize());
        List<T> resultLists = this.listByParams(clazz, statement, paramMap);
        PageInfo pageInfo = innerPage.toPageInfo();
        page.setResult(resultLists);
        page.setTotalResult((int)pageInfo.getTotal());
        page.setStartRow(pageInfo.getStartRow());
        page.setEndRow(pageInfo.getEndRow());
        return page;
    }

    public Page<Map<String, Object>> findPageByParams(Page<Map<String, Object>> page, String statement, ParamMap paramMap) {
        if (page == null) {
            throw new RuntimeException("page can not be null when findPageByParams");
        }
        com.github.pagehelper.Page innerPage = PageHelper.startPage((int)page.getCurrentPage(), (int)page.getPageSize());
        List<Map<String, Object>> resultsMap = this.listByParams(statement, paramMap);
        PageInfo pageInfo = innerPage.toPageInfo();
        page.setResult(resultsMap);
        page.setTotalResult((int)pageInfo.getTotal());
        page.setStartRow(pageInfo.getStartRow());
        page.setEndRow(pageInfo.getEndRow());
        return page;
    }

    public int execute(String statement, ParamMap paramMap) {
        SmartDatasourceHolder.switchToWrite();
        return this.sqlSessionTemplate.update(statement, (Object)paramMap);
    }

    public <T> int updateByField(Class<T> clazz, String fieldName, Object fieldValue, Object updateObj, boolean updateNull) {
        String tableName = this.sqlHelper.getTableName(clazz);
        return this.updateByField(clazz, fieldName, fieldValue, updateObj, updateNull, tableName);
    }

    public <T> int updateByField(Class<T> clazz, String fieldName, Object fieldValue, Object updateObj, boolean updateNull, String tableName) {
        int result;
        block12: {
            Field[] fields = this.sqlHelper.getFieldsWithoutTransient(clazz);
            ArrayList columns = new ArrayList();
            String whereColumnName = fieldName;
            String lockFieldName = null;
            Object lockFieldValue = null;
            Field versionField = null;
            for (Field f : fields) {
                if (f.getName().equals(fieldName)) {
                    whereColumnName = this.sqlHelper.getColumnName(f);
                    continue;
                }
                HashMap<String, Object> column = new HashMap<String, Object>();
                String columnName = this.sqlHelper.getColumnName(f);
                column.put("name", columnName);
                f.setAccessible(true);
                try {
                    Object value = f.get(updateObj);
                    if (value == null && !updateNull) continue;
                    if (f.getType().isEnum() && value != null) {
                        column.put("value", ((Enum)value).ordinal());
                    } else {
                        column.put("value", value);
                    }
                    OptimisticLock lockAnno = f.getAnnotation(OptimisticLock.class);
                    if (lockAnno != null) {
                        versionField = f;
                        lockFieldName = this.sqlHelper.getColumnName(f);
                        lockFieldValue = value;
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                columns.add(column);
            }
            ParamMap pm = new ParamMap();
            pm.put("tableName", (Object)tableName);
            pm.put("fieldName", (Object)whereColumnName);
            pm.put("fieldValue", fieldValue);
            pm.put("columnList", (Object)columns);
            pm.put("lockFieldName", (Object)lockFieldName);
            pm.put("lockFieldValue", lockFieldValue);
            result = this.execute("CommonEntityMapper.updateByField", pm);
            if (result > 0 && versionField != null) {
                try {
                    Object val = versionField.get(updateObj);
                    if (val instanceof Integer) {
                        versionField.set(updateObj, (Integer)val + 1);
                        break block12;
                    }
                    if (val instanceof Long) {
                        versionField.set(updateObj, (Long)val + 1L);
                        break block12;
                    }
                    throw new BusinessException("OptimisticLock does not add to a Integer or Long field");
                }
                catch (Exception e) {
                    throw new BusinessException("\u66f4\u65b0OptimisticLock\u6807\u8bb0\u7684\u5b57\u6bb5\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return result;
    }

    public <T> int batchInsert(Class<T> clazz, List<T> list) {
        if (list == null || list.isEmpty()) {
            return 0;
        }
        SmartDatasourceHolder.switchToWrite();
        ParamMap pm = new ParamMap();
        Field[] fields = this.sqlHelper.getFieldsWithoutTransient(clazz);
        ArrayList<String> columns = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            if (this.sqlHelper.isAutoInstreaseField(fields[i])) continue;
            columns.add(this.sqlHelper.getColumnName(fields[i]));
        }
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        for (T obj : list) {
            List<Object> values = this.getBatchInsertColumnValues(obj);
            rows.add(values);
        }
        pm.put("tableName", (Object)this.sqlHelper.getTableName(clazz));
        pm.put("columns", (Object)columns);
        pm.put("rows", (Object)rows);
        if (this.sqlHelper.isAutoInstreaseField(this.sqlHelper.getIdOfClass(clazz))) {
            return this.execute("CommonEntityMapper.batchInsertAutoIncrease", pm);
        }
        Sequence seq = this.sqlHelper.getIdOfClass(clazz).getAnnotation(Sequence.class);
        pm.put("selectKey", (Object)seq.selectKey());
        return this.execute("CommonEntityMapper.batchInsertBySequence", pm);
    }

    private List<Object> getBatchInsertColumnValues(Object obj) {
        ArrayList<Object> values = new ArrayList<Object>();
        Field[] fields = this.sqlHelper.getFieldsWithoutTransient(obj.getClass());
        for (int i = 0; i < fields.length; ++i) {
            Field idField;
            Sequence seqAno;
            if (this.sqlHelper.isAutoInstreaseField(fields[i])) continue;
            if (this.sqlHelper.isIdField(fields[i]) && (seqAno = (idField = fields[i]).getAnnotation(Sequence.class)) != null) {
                String selectKey = seqAno.selectKey();
                ParamMap pm = new ParamMap();
                pm.put("selectKey", (Object)selectKey);
                Long id = (Long)this.sqlSessionTemplate.selectOne("CommonEntityMapper.selectId", (Object)pm);
                values.add(id);
                continue;
            }
            try {
                IntegerDefaultValue anno;
                fields[i].setAccessible(true);
                Object val = fields[i].get(obj);
                if (val == null && (anno = fields[i].getAnnotation(IntegerDefaultValue.class)) != null) {
                    val = anno.value();
                }
                values.add(val);
                continue;
            }
            catch (Exception e) {
                throw new BusinessException("\u6279\u91cf\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return values;
    }

    public int countByExample(Object vo, String tableName) {
        SmartDatasourceHolder.switchToRead();
        Field[] fields = this.sqlHelper.getFieldsWithoutTransient(vo.getClass());
        ArrayList columns = new ArrayList();
        for (Field f : fields) {
            HashMap<String, Object> column = new HashMap<String, Object>();
            String columnName = this.sqlHelper.getColumnName(f);
            column.put("name", columnName);
            f.setAccessible(true);
            try {
                Object value = f.get(vo);
                if (value == null) continue;
                if (f.getType().isEnum() && value != null) {
                    column.put("value", ((Enum)value).ordinal());
                } else {
                    column.put("value", value);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            columns.add(column);
        }
        ParamMap pm = new ParamMap();
        pm.put("tableName", (Object)tableName);
        pm.put("columnList", (Object)columns);
        Long result = (Long)this.sqlSessionTemplate.selectOne("CommonEntityMapper.countByExample", (Object)pm);
        return result.intValue();
    }

    public int countByExample(Object vo) {
        String tableName = this.sqlHelper.getTableName(vo.getClass());
        return this.countByExample(vo, tableName);
    }

    public int count(String statment, ParamMap pm) {
        Map<String, Object> map = this.findOne(statment, pm);
        long total = (Long)map.get("total");
        return (int)total;
    }

    public SqlHelper getSqlHelper() {
        return this.sqlHelper;
    }

    public FieldDataConverter getFieldDataConverter() {
        return this.fieldDataConverter;
    }
}

