package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.util.Properties;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.september.smartdao.datasource.SmartDatasourceHolder;
import org.springframework.aop.support.AopUtils;
import org.springframework.lang.Nullable;
import org.springframework.transaction.PlatformTransactionManager;

@SuppressWarnings("serial")
public class TransactionInterceptor  extends TransactionAspectSupport implements MethodInterceptor, Serializable{



	/**
	 * Create a new TransactionInterceptor.
	 * <p>Transaction manager and transaction attributes still need to be set.
	 * @see #setTransactionManager
	 * @see #setTransactionAttributes(java.util.Properties)
	 * @see #setTransactionAttributeSource(TransactionAttributeSource)
	 */
	public TransactionInterceptor() {
	}

	/**
	 * Create a new TransactionInterceptor.
	 * @param ptm the default transaction manager to perform the actual transaction management
	 * @param attributes the transaction attributes in properties format
	 * @see #setTransactionManager
	 * @see #setTransactionAttributes(java.util.Properties)
	 */
	public TransactionInterceptor(PlatformTransactionManager ptm, Properties attributes) {
		setTransactionManager(ptm);
		setTransactionAttributes(attributes);
	}

	/**
	 * Create a new TransactionInterceptor.
	 * @param ptm the default transaction manager to perform the actual transaction management
	 * @param tas the attribute source to be used to find transaction attributes
	 * @see #setTransactionManager
	 * @see #setTransactionAttributeSource(TransactionAttributeSource)
	 */
	public TransactionInterceptor(PlatformTransactionManager ptm, TransactionAttributeSource tas) {
		setTransactionManager(ptm);
		setTransactionAttributeSource(tas);
	}


	@Override
	@Nullable
	public Object invoke(MethodInvocation invocation) throws Throwable {
		// Work out the target class: may be {@code null}.
		// The TransactionAttributeSource should be passed the target class
		// as well as the method, which may be from an interface.
		Class<?> targetClass = (invocation.getThis() != null ? AopUtils.getTargetClass(invocation.getThis()) : null);

		// Adapt to TransactionAspectSupport's invokeWithinTransaction...
		// add by xzye
		// 事务只走写库
		SmartDatasourceHolder.switchToWrite();
		
		// 其实在开始事务之前就已经确定了数据库，事务方法内不管有多少个读写方法都不会再选择数据库，所以没有必要
		// lock 和 release datasource
		
//		SmartDatasourceHolder.lockDataSource(); // lock datasource context
		Object result = invokeWithinTransaction(invocation.getMethod(), targetClass, invocation::proceed);
		// release datasource context
//		SmartDatasourceHolder.releaseDataSourceLock();
		return result;
	}


	//---------------------------------------------------------------------
	// Serialization support
	//---------------------------------------------------------------------

//	private void writeObject(ObjectOutputStream oos) throws IOException {
//		// Rely on default serialization, although this class itself doesn't carry state anyway...
//		oos.defaultWriteObject();
//
//		// Deserialize superclass fields.
//		oos.writeObject(getTransactionManagerBeanName());
//		oos.writeObject(getTransactionManager());
//		oos.writeObject(getTransactionAttributeSource());
//		oos.writeObject(getBeanFactory());
//	}

//	private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
//		// Rely on default serialization, although this class itself doesn't carry state anyway...
//		ois.defaultReadObject();
//
//		// Serialize all relevant superclass fields.
//		// Superclass can't implement Serializable because it also serves as base class
//		// for AspectJ aspects (which are not allowed to implement Serializable)!
//		setTransactionManagerBeanName((String) ois.readObject());
//		setTransactionManager((PlatformTransactionManager) ois.readObject());
//		setTransactionAttributeSource((TransactionAttributeSource) ois.readObject());
//		setBeanFactory((BeanFactory) ois.readObject());
//	}


}
