/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.util;

import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.september.smartdao.anno.Id;
import org.september.smartdao.datasource.SmartDatasourceHolder;
import org.september.smartdao.model.QueryPair;
import org.september.smartdao.util.ReflectHelper;
import org.september.smartdao.util.SqlHelper;
import org.springframework.util.StringUtils;

public class DMSqlHelper
extends SqlHelper {
    @Override
    public String getTableName(Class<?> clazz) {
        String schema = SmartDatasourceHolder.getCurrentDataSource().getShcema();
        String tableName = clazz.getSimpleName();
        Table tableAno = clazz.getAnnotation(Table.class);
        if (tableAno != null) {
            tableName = tableAno.name();
        }
        if (StringUtils.hasText((String)schema)) {
            return this.wrapWithQuotation(schema) + "." + this.wrapWithQuotation(tableName.toLowerCase());
        }
        return this.wrapWithQuotation(tableName.toLowerCase());
    }

    @Override
    public List<QueryPair> getQueryPairs(Object parameterObject, boolean defaultValue) {
        List<QueryPair> result = super.getQueryPairs(parameterObject, defaultValue);
        for (QueryPair pair : result) {
            pair.setColumnName(this.wrapWithQuotation(pair.getColumnName()));
        }
        return result;
    }

    private String wrapWithQuotation(String str) {
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str;
        }
        return "\"" + str + "\"";
    }

    @Override
    public String getColumnName(Field field) {
        Column colAno = field.getAnnotation(Column.class);
        if (colAno == null) {
            return this.wrapWithQuotation(field.getName());
        }
        return this.wrapWithQuotation(colAno.name());
    }

    @Override
    public Map<String, Object> dbFieldToEntityField(Class<?> clazz, Map<String, Object> dbData) throws SecurityException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : dbData.keySet()) {
            Field field = this.getFieldWithAnnotationColumnName(clazz, key.toString());
            if (field == null) {
                result.put(key, dbData.get(key));
                continue;
            }
            result.put(field.getName(), dbData.get(key));
        }
        return result;
    }

    @Override
    public Field[] getFieldsWithoutTransient(Class<?> clazz) {
        Field[] fields = ReflectHelper.getAllDeclaredFields(clazz);
        ArrayList<Field> result = new ArrayList<Field>();
        for (int i = 0; i < fields.length; ++i) {
            if (ReflectHelper.isTransientField(fields[i])) continue;
            result.add(fields[i]);
        }
        return result.toArray(new Field[0]);
    }

    @Override
    public String getIdColumnOfEntity(Object obj) {
        return this.getIdColumnOfClass(obj.getClass());
    }

    @Override
    public String getIdColumnOfClass(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            Id idAno = field.getAnnotation(Id.class);
            if (idAno == null) continue;
            Column colAno = field.getAnnotation(Column.class);
            if (colAno == null) {
                return this.wrapWithQuotation(field.getName());
            }
            return this.wrapWithQuotation(colAno.name());
        }
        throw new RuntimeException("Id not found for " + clazz);
    }
}

