/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.september.core.component.log.LogHelper;
import org.september.smartdao.anno.AutoIncrease;
import org.september.smartdao.anno.Column;
import org.september.smartdao.anno.Id;
import org.september.smartdao.anno.Table;
import org.september.smartdao.model.QueryPair;
import org.september.smartdao.util.ReflectHelper;

public class SqlHelper {
    private static final LogHelper Logger = LogHelper.getLogger(SqlHelper.class);

    public static String getTableName(Class<?> clazz) {
        String tableName = clazz.getSimpleName();
        Table tableAno = clazz.getAnnotation(Table.class);
        if (tableAno != null) {
            tableName = tableAno.name();
        }
        return tableName.toLowerCase();
    }

    public static List<QueryPair> getQueryPairs(Object parameterObject) {
        ArrayList<QueryPair> result = new ArrayList<QueryPair>();
        if (parameterObject == null) {
            return result;
        }
        Field[] fields = SqlHelper.getFieldsWithoutTransient(parameterObject.getClass());
        int i = 0;
        while (i < fields.length) {
            Id idAno = fields[i].getAnnotation(Id.class);
            if (idAno == null) {
                fields[i].setAccessible(true);
                try {
                    Object val = fields[i].get(parameterObject);
                    if (val != null) {
                        QueryPair pair = new QueryPair();
                        if (val instanceof Enum) {
                            pair.setColumnName(SqlHelper.getColumnName(fields[i]));
                            pair.setColumnValue(((Enum)val).ordinal());
                            result.add(pair);
                        } else {
                            pair.setColumnName(SqlHelper.getColumnName(fields[i]));
                            pair.setColumnValue(val);
                            result.add(pair);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ++i;
        }
        return result;
    }

    public static String getColumnName(Field field) {
        Column colAno = field.getAnnotation(Column.class);
        if (colAno == null) {
            return field.getName();
        }
        return colAno.name();
    }

    public static Map<String, Object> dbFieldToEntityField(Class<?> clazz, Map<String, Object> dbData) throws SecurityException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : dbData.keySet()) {
            Field field = SqlHelper.getFieldWithAnnotationColumnName(clazz, key.toString());
            if (field == null) {
                result.put(key, dbData.get(key));
                continue;
            }
            result.put(field.getName(), dbData.get(key));
        }
        return result;
    }

    public static Field[] getFieldsWithoutTransient(Class<?> clazz) {
        Field[] fields = ReflectHelper.getAllDeclaredFields(clazz);
        ArrayList<Field> result = new ArrayList<Field>();
        int i = 0;
        while (i < fields.length) {
            if (!ReflectHelper.isTransientField(fields[i])) {
                result.add(fields[i]);
            }
            ++i;
        }
        return result.toArray(new Field[0]);
    }

    public static boolean isAutoInstreaseField(Field field) {
        if (field == null) {
            return false;
        }
        AutoIncrease ano = field.getAnnotation(AutoIncrease.class);
        return ano != null;
    }

    public static boolean isIdField(Field field) {
        if (field == null) {
            return false;
        }
        Id ano = field.getAnnotation(Id.class);
        return ano != null;
    }

    public static Field getIdOfEntity(Object obj) {
        return SqlHelper.getIdOfClass(obj.getClass());
    }

    public static Field getIdOfClass(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Id idAno = field.getAnnotation(Id.class);
            if (idAno != null) {
                return field;
            }
            ++n2;
        }
        if (clazz.getSuperclass() != Object.class) {
            return SqlHelper.getIdOfClass(clazz.getSuperclass());
        }
        throw new RuntimeException("Id not found for " + clazz);
    }

    public static String getIdColumnOfEntity(Object obj) {
        return SqlHelper.getIdColumnOfClass(obj.getClass());
    }

    public static String getIdColumnOfClass(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Id idAno = field.getAnnotation(Id.class);
            if (idAno != null) {
                Column colAno = field.getAnnotation(Column.class);
                if (colAno == null) {
                    return field.getName();
                }
                return colAno.name();
            }
            ++n2;
        }
        throw new RuntimeException("Id not found for " + clazz);
    }

    private static Field getFieldWithAnnotationColumnName(Class clazz, String annoName) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            Column anno = f.getAnnotation(Column.class);
            if (anno != null && annoName.equals(anno.name())) {
                return f;
            }
            ++n2;
        }
        return null;
    }
}

