/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.september.core.component.log.LogHelper;
import org.september.smartdao.util.SqlHelper;

public class ReflectHelper {
    private static final LogHelper logger = LogHelper.getLogger(ReflectHelper.class);

    public static Map<String, Object> transEmptyString2Null(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fieldArray = ReflectHelper.getAllDeclaredFields(obj.getClass());
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            f.setAccessible(true);
            try {
                Object value = f.get(obj);
                if (value != null) {
                    if ("".equals(value)) {
                        map.put(f.getName(), null);
                    } else {
                        map.put(f.getName(), value);
                    }
                }
            }
            catch (Exception e) {
                logger.getBuilder().warn("get " + f.getName() + " value of " + obj.getClass().getName() + " failed ");
            }
            ++n2;
        }
        return map;
    }

    public static <T> List<T> transformMapToEntity(Class<T> clazz, List<Map<String, Object>> mapResult) {
        ArrayList<T> entityResult = new ArrayList<T>();
        for (Map<String, Object> map : mapResult) {
            entityResult.add(ReflectHelper.transformMapToEntity(clazz, map));
        }
        return entityResult;
    }

    private static void setProperties(Object dest, Map<String, Object> origin) throws IllegalArgumentException, IllegalAccessException {
        Field[] fieldList;
        origin = SqlHelper.dbFieldToEntityField(dest.getClass(), origin);
        Field[] fieldArray = fieldList = ReflectHelper.getAllDeclaredFields(dest.getClass());
        int n = fieldList.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String name = field.getName();
            Object value = origin.get(name);
            if (value == null) {
                value = origin.get(name.toUpperCase());
            }
            field.setAccessible(true);
            if (value != null) {
                Timestamp timestamp;
                if (field.getType().equals(Character.class) || field.getClass().equals(Character.TYPE)) {
                    String str = (String)value;
                    if (str.length() > 0) {
                        field.set(dest, Character.valueOf(str.charAt(0)));
                    }
                } else if (field.getType().equals(Instant.class)) {
                    timestamp = (Timestamp)value;
                    field.set(dest, timestamp.toInstant());
                } else if (field.getType().equals(LocalDateTime.class)) {
                    timestamp = (Timestamp)value;
                    field.set(dest, timestamp.toLocalDateTime());
                } else if (field.getType().equals(LocalDate.class)) {
                    Date date = (Date)value;
                    field.set(dest, date.toLocalDate());
                } else if (field.getType().equals(LocalTime.class)) {
                    Time time = (Time)value;
                    field.set(dest, time.toLocalTime());
                } else if (field.getType().equals(ZonedDateTime.class)) {
                    timestamp = (Timestamp)value;
                    field.set(dest, OffsetDateTime.ofInstant(timestamp.toInstant(), ZoneId.systemDefault()));
                } else if (value instanceof Timestamp) {
                    Timestamp tvalue = (Timestamp)value;
                    field.set(dest, new java.util.Date(tvalue.getTime()));
                } else if (field.getType().isEnum()) {
                    field.set(dest, field.getType().getEnumConstants()[(Integer)value]);
                } else {
                    field.set(dest, value);
                }
            }
            ++n2;
        }
    }

    public static <T> T transformMapToEntity(Class<T> clazz, Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        try {
            T entity = clazz.newInstance();
            ReflectHelper.setProperties(entity, map);
            return entity;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("try to wrap entity " + clazz.getName() + " failed", e);
        }
    }

    public static Field[] getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> target = new ArrayList<Field>();
        while (clazz != null && !clazz.equals(Object.class)) {
            target.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return target.toArray(new Field[0]);
    }

    public static boolean isTransientField(Field field) {
        return Modifier.isTransient(field.getModifiers());
    }
}

