/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.listener;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.september.core.util.JVMUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
public class MyBatisMapperChangeListener
implements InitializingBean,
ApplicationContextAware {
    private volatile ConfigurableApplicationContext context = null;
    private volatile Scanner scanner = null;
    private final ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (ConfigurableApplicationContext)applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (!JVMUtil.isDebug()) {
            return;
        }
        this.scanner = new Scanner();
        new Thread(new watchMapper()).start();
    }

    private List<String> getMapperDir() {
        SqlSessionFactory factory = (SqlSessionFactory)this.context.getBean(SqlSessionFactory.class);
        Configuration configuration = factory.getConfiguration();
        ArrayList<String> dirs = new ArrayList<String>();
        try {
            Field field = configuration.getClass().getDeclaredField("loadedResources");
            field.setAccessible(true);
            Set resources = (Set)field.get(configuration);
            if (resources.isEmpty()) {
                System.out.println("---------falid to find mytabis mapper path-----------");
                return dirs;
            }
            for (String path : resources) {
                String result;
                if ("resource loaded through InputStream".equals(path) || path.contains("CommonEntityMapper.xml") || dirs.contains(result = String.valueOf(path.split("mapper")[0].split("\\[")[1]) + "mapper")) continue;
                dirs.add(result);
                System.out.println("---------find mytabis mapper path-----------");
                System.out.println("---------" + result + "-----------");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dirs;
    }

    private Collection<File> getWatchDirs() {
        try {
            ArrayList<File> dirList = new ArrayList<File>();
            for (String rootDir : this.getMapperDir()) {
                Collection dirs = FileUtils.listFilesAndDirs((File)new File(rootDir), (IOFileFilter)FalseFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
                dirList.addAll(dirs);
            }
            return dirList;
        }
        catch (Exception ex) {
            System.out.println("\u83b7\u53d6mapper\u6587\u4ef6\u76ee\u5f55\u5931\u8d25\uff0c\u5982\u679c\u4f60\u6b63\u5728\u4f7f\u7528tomcat\u8c03\u8bd5\uff0c\u8bf7\u4f7f\u7528jetty\u5373\u53ef\u3002");
            return new ArrayList<File>();
        }
    }

    class Scanner {
        private static final String COMMONENTITYMAPPER_RESOURCE_PATTERN = "classpath*:CommonEntityMapper.xml";

        public void reloadXML() throws Exception {
            SqlSessionFactory factory = (SqlSessionFactory)MyBatisMapperChangeListener.this.context.getBean(SqlSessionFactory.class);
            Configuration configuration = factory.getConfiguration();
            List dirs = MyBatisMapperChangeListener.this.getMapperDir();
            this.removeConfig(configuration);
            for (Resource resource : this.findResource(dirs)) {
                try {
                    XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(resource.getInputStream(), configuration, resource.toString(), configuration.getSqlFragments());
                    xmlMapperBuilder.parse();
                }
                finally {
                    ErrorContext.instance().reset();
                }
            }
            Resource[] resourceArray = this.findCommonEntityMapper();
            int n = resourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource;
                resource = resourceArray[n2];
                try {
                    XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(resource.getInputStream(), configuration, resource.toString(), configuration.getSqlFragments());
                    xmlMapperBuilder.parse();
                }
                finally {
                    ErrorContext.instance().reset();
                }
                ++n2;
            }
        }

        private void removeConfig(Configuration configuration) throws Exception {
            Class<?> classConfig = configuration.getClass();
            this.clearStatments(configuration);
            this.clearMap(classConfig, configuration, "caches");
            this.clearMap(classConfig, configuration, "resultMaps");
            this.clearMap(classConfig, configuration, "parameterMaps");
            this.clearMap(classConfig, configuration, "keyGenerators");
            this.clearMap(classConfig, configuration, "sqlFragments");
            this.clearSet(classConfig, configuration, "loadedResources");
        }

        private void clearStatments(Configuration configuration) throws Exception {
            Field field = Configuration.class.getDeclaredField("mappedStatements");
            field.setAccessible(true);
            Map mapper = (Map)field.get(configuration);
            ArrayList targetList = new ArrayList();
            for (Object key : mapper.keySet()) {
                MappedStatement ms = (MappedStatement)mapper.get(key);
                if (ms.getId().startsWith("CommonEntityMapper")) continue;
                targetList.add(key);
            }
            for (Object key : targetList) {
                mapper.remove(key);
            }
        }

        private void clearMap(Class<?> classConfig, Configuration configuration, String fieldName) throws Exception {
            Field field = classConfig.getDeclaredField(fieldName);
            field.setAccessible(true);
            ((Map)field.get(configuration)).clear();
        }

        private void clearSet(Class<?> classConfig, Configuration configuration, String fieldName) throws Exception {
            Field field = classConfig.getDeclaredField(fieldName);
            field.setAccessible(true);
            ((Set)field.get(configuration)).clear();
        }

        private List<Resource> findResource(List<String> dirs) throws IOException {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (String path : dirs) {
                resources.addAll(this.findResource(path));
            }
            return resources;
        }

        private List<Resource> findResource(String path) throws IOException {
            File dir = new File(path);
            Collection xmlList = FileUtils.listFiles((File)dir, (String[])new String[]{"xml"}, (boolean)true);
            ArrayList<Resource> arraySource = new ArrayList<Resource>();
            for (File xml : xmlList) {
                arraySource.add((Resource)new FileSystemResource(xml));
            }
            return arraySource;
        }

        private Resource[] findCommonEntityMapper() throws IOException {
            return MyBatisMapperChangeListener.this.resourcePatternResolver.getResources(COMMONENTITYMAPPER_RESOURCE_PATTERN);
        }
    }

    class watchMapper
    implements Runnable {
        watchMapper() {
        }

        @Override
        public void run() {
            WatchKey key;
            boolean valid;
            WatchService watcher = null;
            try {
                watcher = FileSystems.getDefault().newWatchService();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                Collection dirs = MyBatisMapperChangeListener.this.getWatchDirs();
                for (File dir : dirs) {
                    Paths.get(dir.getAbsolutePath(), new String[0]).register(watcher, StandardWatchEventKinds.ENTRY_MODIFY);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            block9: do {
                key = null;
                try {
                    key = watcher.take();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                List<WatchEvent<?>> events = key.pollEvents();
                for (WatchEvent<?> event : events) {
                    if (!event.kind().equals(StandardWatchEventKinds.ENTRY_MODIFY)) continue;
                    System.out.println(event.context() + "\u88ab\u4fee\u6539");
                    if (!event.context().toString().endsWith(".xml")) continue;
                    System.out.println("reload mapper");
                    try {
                        MyBatisMapperChangeListener.this.scanner.reloadXML();
                        continue block9;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } while (valid = key.reset());
        }
    }
}

